/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.sparse;

import gnu.trove.map.hash.TLongIntHashMap;
import net.imglib2.AbstractWrappedInterval;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Sampler;
import net.imglib2.img.basictypeaccess.IntAccess;
import net.imglib2.roi.IterableRegion;
import net.imglib2.sparse.IntervalIndexer2;
import net.imglib2.sparse.MappingCursor;
import net.imglib2.sparse.SparseIterableRegion;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.integer.IntType;

public class SparseRandomAccessIntType
extends AbstractWrappedInterval<Interval>
implements RandomAccessibleInterval<IntType> {
    private final IntervalIndexer2 indexer;
    private final TLongIntHashMap values;
    private final int noEntryValue;

    public SparseRandomAccessIntType(Interval source) {
        this(source, 0);
    }

    public SparseRandomAccessIntType(Interval source, int noEntryValue) {
        super(source);
        this.indexer = new IntervalIndexer2(source);
        this.values = new TLongIntHashMap(10, 0.5f, -1L, noEntryValue);
        this.noEntryValue = noEntryValue;
    }

    public RandomAccess<IntType> randomAccess() {
        return new MyRandomAccess();
    }

    public RandomAccess<IntType> randomAccess(Interval interval) {
        return this.randomAccess();
    }

    public Cursor<IntType> sparseCursor() {
        return new MappingCursor<IntType>(this.sparsityPattern().cursor(), this.randomAccess());
    }

    public IterableRegion<? extends BooleanType<?>> sparsityPattern() {
        return new SparseIterableRegion((Interval)this, this.values.keySet());
    }

    private int get(MyRandomAccess position) {
        return this.values.get(this.indexer.positionToIndex((Localizable)position));
    }

    private void set(MyRandomAccess position, int value) {
        Long index = this.indexer.positionToIndex((Localizable)position);
        if (value == this.noEntryValue) {
            this.values.remove(index.longValue());
        } else {
            this.values.put(index.longValue(), value);
        }
    }

    private class MyRandomAccess
    extends Point
    implements RandomAccess<IntType> {
        private IntType value;

        private MyRandomAccess() {
            super(SparseRandomAccessIntType.this.numDimensions());
            this.value = new IntType(new IntAccess(){

                public int getValue(int ignored) {
                    return SparseRandomAccessIntType.this.get(MyRandomAccess.this);
                }

                public void setValue(int ignored, int value) {
                    SparseRandomAccessIntType.this.set(MyRandomAccess.this, value);
                }
            });
        }

        private MyRandomAccess(Localizable localizable) {
            super(localizable);
            this.value = new IntType(new /* invalid duplicate definition of identical inner class */);
        }

        public RandomAccess<IntType> copyRandomAccess() {
            return new MyRandomAccess((Localizable)this);
        }

        public IntType get() {
            return this.value;
        }

        public Sampler<IntType> copy() {
            throw new UnsupportedOperationException();
        }
    }
}

