/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import mcib3d.geom2.tracking.TrackingAssociation;
import mcib3d.image3d.ImageHandler;

public class Association_
implements PlugIn {
    private int idxA;
    private int idxB;
    private int costChoice = 0;
    private double minColoc = 0.1;
    private double maxBB = 0.0;

    public void run(String s) {
        if (!this.dialog()) {
            return;
        }
        ImageHandler img1 = ImageHandler.wrap((ImagePlus)WindowManager.getImage((int)(this.idxA + 1)));
        ImageHandler img2 = ImageHandler.wrap((ImagePlus)WindowManager.getImage((int)(this.idxB + 1)));
        TrackingAssociation trackingAssociation = new TrackingAssociation(img1, img2, this.maxBB, this.minColoc);
        trackingAssociation.getTrackedImage().show(img1.getTitle() + "-association");
    }

    private boolean dialog() {
        int nbima = WindowManager.getImageCount();
        if (nbima < 2) {
            IJ.error((String)"Needs at least two labelled images");
            return false;
        }
        this.idxA = 0;
        this.idxB = 1;
        String[] namesA = new String[nbima];
        String[] namesB = new String[nbima];
        for (int i = 0; i < nbima; ++i) {
            namesA[i] = WindowManager.getImage((int)(i + 1)).getShortTitle();
            namesB[i] = WindowManager.getImage((int)(i + 1)).getShortTitle();
        }
        String[] costChoices = new String[]{"Colocalisation", "Distance Border-Border"};
        GenericDialog dia = new GenericDialog("Association");
        dia.addMessage("Images to associate");
        dia.addChoice("Image_A", namesA, namesA[this.idxA]);
        dia.addChoice("Image_B", namesB, namesB[this.idxB]);
        dia.addMessage("Method for association");
        dia.addChoice("Method", costChoices, costChoices[this.costChoice]);
        dia.addNumericField("Min coloc (% object in A)", this.minColoc * 100.0, 5);
        dia.addNumericField("Max dist BB (pixel unit)", this.maxBB, 3);
        dia.showDialog();
        if (dia.wasOKed()) {
            this.idxA = dia.getNextChoiceIndex();
            this.idxB = dia.getNextChoiceIndex();
            this.costChoice = dia.getNextChoiceIndex();
            this.minColoc = dia.getNextNumber() / 100.0;
            this.maxBB = dia.getNextNumber();
        }
        return dia.wasOKed();
    }
}

