/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.Concatenator;
import ij.plugin.Duplicator;
import ij.plugin.HyperStackConverter;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import mcib3d.geom2.tracking.TrackingAssociation;
import mcib3d.image3d.ImageHandler;

public class Association_Tracking
implements PlugInFilter {
    private ImagePlus plus;
    private int costChoice = 0;
    private double minColoc = 0.1;
    private double maxBB = 0.0;
    private boolean trackSlices = false;

    public int setup(String s, ImagePlus imagePlus) {
        this.plus = imagePlus;
        return 2061;
    }

    public void run(ImageProcessor imageProcessor) {
        ImagePlus plusTrack;
        if (!this.dialog()) {
            return;
        }
        int[] dims = this.plus.getDimensions();
        if (this.trackSlices) {
            if (dims[3] < 2) {
                IJ.log((String)"Nb slices should be > 2 when using track slices option");
            }
            IJ.log((String)("Dim " + dims[0] + " " + dims[1] + " " + dims[2] + " " + dims[3] + " " + dims[4]));
            plusTrack = HyperStackConverter.toHyperStack((ImagePlus)this.plus.duplicate(), (int)1, (int)1, (int)dims[3], (String)"xyzct", (String)"composite");
        } else {
            plusTrack = this.plus.duplicate();
        }
        int nFrames = plusTrack.getNFrames();
        dims = plusTrack.getDimensions();
        int channel = plusTrack.getChannel();
        int frame = plusTrack.getFrame();
        IJ.log((String)("Dim track " + dims[0] + " " + dims[1] + " " + dims[2] + " " + dims[3] + " " + dims[4]));
        if (plusTrack.isHyperStack() || dims[2] > 1 || dims[4] > 1) {
            IJ.log((String)("Hyperstack found, extracting current channel " + channel + " and frame " + frame));
            Duplicator duplicator = new Duplicator();
            ImagePlus plus1 = duplicator.run(plusTrack, channel, channel, 1, dims[3], frame, frame);
            ImagePlus plus2 = duplicator.run(plusTrack, channel, channel, 1, dims[3], frame + 1, frame + 1);
            ImagePlus result = plus1.duplicate();
            ImageHandler img1 = ImageHandler.wrap((ImagePlus)plus1);
            ImageHandler img2 = ImageHandler.wrap((ImagePlus)plus2);
            TrackingAssociation trackingAssociation = new TrackingAssociation(img1, img2, this.maxBB, this.minColoc);
            for (int i = frame + 1; i <= nFrames; ++i) {
                IJ.log((String)("Processing " + i));
                ImageHandler tracked = trackingAssociation.getTrackedImage();
                result = Concatenator.run((ImagePlus)result, (ImagePlus)tracked.getImagePlus());
                if (i >= nFrames) continue;
                trackingAssociation.setImage1(tracked);
                ImagePlus plusTmp = duplicator.run(plusTrack, channel, channel, 1, dims[3], i + 1, i + 1);
                trackingAssociation.setImage2(ImageHandler.wrap((ImagePlus)plusTmp));
            }
            result = HyperStackConverter.toHyperStack((ImagePlus)result, (int)1, (int)img1.sizeZ, (int)(nFrames - frame + 1), (String)"xyzct", (String)"composite");
            result.show("Tracked image");
        }
    }

    private boolean dialog() {
        String[] costChoices = new String[]{"Colocalisation", "Distance Border-Border"};
        GenericDialog dia = new GenericDialog("Association Tracking");
        dia.addMessage("Method for association");
        dia.addChoice("Method", costChoices, costChoices[this.costChoice]);
        dia.addNumericField("Min coloc (% object in A)", this.minColoc * 100.0, 5);
        dia.addNumericField("Max dist BB (pixel unit)", this.maxBB, 3);
        dia.addCheckbox("Track_slices instead of frames", this.trackSlices);
        dia.showDialog();
        if (dia.wasOKed()) {
            this.costChoice = dia.getNextChoiceIndex();
            this.minColoc = dia.getNextNumber() / 100.0;
            this.maxBB = dia.getNextNumber();
            this.trackSlices = dia.getNextBoolean();
        }
        return dia.wasOKed();
    }
}

