/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.processing.BinaryMultiLabel;

public class Binary_Close
implements PlugInFilter {
    float radiusXY;
    float radiusZ;
    String method = "Close";
    ImagePlus plus;

    public ImageHandler process(ImageHandler input) {
        float radXY = Math.max(this.radiusXY, 1.0f);
        float radZ = Math.max(this.radiusZ, 0.0f);
        if (input.sizeZ == 1) {
            radZ = 0.0f;
        }
        switch (this.method) {
            case "Open": {
                return BinaryMultiLabel.binaryOpenMultilabel((ImageHandler)input, (float)radXY, (float)radZ);
            }
            case "Dilate": {
                return BinaryMultiLabel.binaryDilateMultilabel((ImageHandler)input, (float)radXY, (float)radZ);
            }
            case "Erode": {
                return BinaryMultiLabel.binaryErodeMultiLabel((ImageHandler)input, (float)radXY, (float)radZ);
            }
            case "FillHoles": {
                return BinaryMultiLabel.fillHoles2DMultiLabel((ImageHandler)input);
            }
        }
        return BinaryMultiLabel.binaryCloseMultilabel((ImageHandler)input, (float)radXY, (float)radZ);
    }

    public int setup(String arg, ImagePlus imp) {
        this.plus = imp;
        return 13;
    }

    public void run(ImageProcessor ip) {
        IJ.showStatus((String)"BinaryClose");
        GenericDialog gd = new GenericDialog("BinaryClose");
        gd.addNumericField("radiusXY (pix):", 5.0, 1);
        gd.addNumericField("radiusZ (pix):", 3.0, 1);
        gd.addChoice("Operation", new String[]{"Close", "Dilate", "Open", "Erode", "FillHoles"}, this.method);
        gd.showDialog();
        ImageHandler input = ImageHandler.wrap((ImagePlus)this.plus);
        if (gd.wasOKed()) {
            this.radiusXY = (float)gd.getNextNumber();
            this.radiusZ = (float)gd.getNextNumber();
            this.method = gd.getNextChoice();
            ImageHandler res = this.process(input);
            ImagePlus resPlus = res.getImagePlus();
            Calibration cal = this.plus.getCalibration();
            if (cal != null) {
                resPlus.setCalibration(cal);
            }
            resPlus.setTitle("CloseLabels");
            resPlus.show();
        }
    }
}

