/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.NewImage;
import ij.measure.Calibration;
import ij.plugin.filter.EDM;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class Binary_Interpolator
implements PlugInFilter {
    ImagePlus plus;

    public int setup(String arg, ImagePlus imp) {
        this.plus = imp;
        return 2177;
    }

    public void run(ImageProcessor ip) {
        GenericDialog genericDialog = new GenericDialog("Interpolate Binary");
        genericDialog.addCheckbox("Make isotropic ?", true);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        boolean isotropic = genericDialog.getNextBoolean();
        this.isotropic(this.plus, isotropic).show();
    }

    private ImagePlus isotropic(ImagePlus plus, boolean iso) {
        double ratio = plus.getCalibration().getZ(1.0) / plus.getCalibration().getX(1.0);
        ImageStack stack = plus.getStack();
        int size = stack.getSize();
        if (!iso) {
            ratio = 1.0;
        }
        int nsize = (int)Math.ceil((double)size * ratio);
        ImagePlus imagePlus = NewImage.createByteImage((String)"interpolated", (int)stack.getWidth(), (int)stack.getHeight(), (int)nsize, (int)1);
        Calibration calibration = plus.getCalibration();
        Calibration calibration1 = new Calibration(imagePlus);
        calibration1.pixelWidth = calibration.pixelWidth;
        calibration1.pixelHeight = calibration.pixelHeight;
        calibration1.pixelDepth = calibration.pixelDepth / ratio;
        calibration1.setUnit(calibration.getUnit());
        imagePlus.setCalibration(calibration1);
        ImagePlus plus1 = plus.duplicate();
        ImageStack stack1 = plus1.getImageStack();
        ImageStack imageStack = imagePlus.getImageStack();
        for (int s = 0; s < plus.getNSlices(); ++s) {
            imageStack.setProcessor(stack1.getProcessor(s + 1), (int)Math.round((double)s * ratio) + 1);
        }
        EDM edm = new EDM();
        ImagePlus edmImage = NewImage.createFloatImage((String)"edm", (int)stack.getWidth(), (int)stack.getHeight(), (int)nsize, (int)1);
        ImageStack edmStack = edmImage.getStack();
        for (int s = 1; s <= edmImage.getNSlices(); ++s) {
            ImageProcessor ip = imageStack.getProcessor(s).duplicate();
            ip.invert();
            FloatProcessor fp = edm.makeFloatEDM(ip, 0, false);
            edmStack.setProcessor((ImageProcessor)fp, s);
        }
        int s0 = this.findNextNonZero(edmStack, 1);
        while (s0 < edmStack.getSize()) {
            int s1 = this.findNextNonZero(edmStack, s0);
            if (s1 < edmStack.getSize() && s1 - s0 > 1) {
                this.fillInterpolate(imageStack, edmStack, s0, s1);
            }
            s0 = s1;
        }
        return imagePlus;
    }

    private int findNextNonZero(ImageStack stack, int s0) {
        ImageStatistics imageStatistics = ImageStatistics.getStatistics((ImageProcessor)stack.getProcessor(++s0));
        while (imageStatistics.min == imageStatistics.max && s0 < stack.getSize()) {
            imageStatistics = ImageStatistics.getStatistics((ImageProcessor)stack.getProcessor(++s0));
        }
        return s0;
    }

    private void fillInterpolate(ImageStack stack, ImageStack edm, int s0, int s1) {
        IJ.log((String)("Interpolating between " + s0 + " " + s1));
        int delta = s1 - s0;
        if (delta < 2) {
            return;
        }
        ImageProcessor frame0 = edm.getProcessor(s0);
        ImageProcessor frame1 = edm.getProcessor(s1);
        for (int s = 1; s < delta; ++s) {
            ImageProcessor ipp = stack.getProcessor(s + s0);
            for (int x = 0; x < stack.getWidth(); ++x) {
                for (int y = 0; y < stack.getHeight(); ++y) {
                    float value = frame0.getPixelValue(x, y) * (float)(s1 - (s + s0)) + frame1.getPixelValue(x, y) * (float)(s + s0 - s0);
                    if (!(value < (float)delta)) continue;
                    ipp.putPixelValue(x, y, 255.0);
                }
            }
        }
    }
}

