/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.processing.CannyEdge3D;
import mcib3d.image3d.processing.SymmetryFilter;

public class Canny_Symmetry
implements PlugInFilter {
    ImagePlus plus = null;
    double alpha = Prefs.get((String)"mcib_symmetry_alpha.double ", (double)0.5);
    int radius = (int)Prefs.get((String)"mcib_symmetry_radius.int", (double)10.0);
    double normalize = Prefs.get((String)"mcib_symmetry_normalize.double", (double)10.0);
    double scaling = Prefs.get((String)"mcib_symmetry_scaling.double", (double)2.0);
    boolean showEdgesXYZ = false;
    boolean showIntermediate = false;
    boolean improved = true;
    boolean symmetry = true;

    public int setup(String string, ImagePlus ip) {
        this.plus = ip;
        return 13;
    }

    public void run(ImageProcessor ip) {
        if (!this.dialog()) {
            return;
        }
        ImageHandler img = ImageHandler.wrap((ImagePlus)this.plus);
        CannyEdge3D edges = new CannyEdge3D(img, this.alpha);
        ImageHandler[] gg = edges.getGradientsXYZ();
        if (this.showEdgesXYZ) {
            gg[0].show("EdgeX");
            gg[1].show("EdgeY");
            gg[2].show("EdgeZ");
        }
        ImageHandler ed = edges.getEdge();
        ed.show("Edges");
        if (!this.symmetry) {
            return;
        }
        SymmetryFilter sy = new SymmetryFilter(gg, this.radius, this.improved);
        sy.setNormalize(this.normalize);
        sy.setScaling(this.scaling);
        sy.setImproved(this.improved);
        if (this.showIntermediate) {
            sy.getIntermediates()[0].show("Bin");
            sy.getIntermediates()[1].show("BinEdge");
        }
        sy.getSymmetry(false).show("Symmetry_" + this.radius);
        sy.getSymmetry(true).show("Symmetry_smoothed_" + this.radius);
    }

    private boolean dialog() {
        GenericDialog gd = new GenericDialog("Edge and Symmetry");
        gd.addMessage("Edge detection Canny Deriche");
        gd.addNumericField("alpha Canny", this.alpha, 3, 10, "");
        gd.addCheckbox("Show edges in X-Y-Z", this.showEdgesXYZ);
        gd.addMessage("Symmetry detection");
        gd.addCheckbox("Compute_symmetry", this.symmetry);
        gd.addNumericField("Radius", (double)this.radius, 0, 10, "pix");
        gd.addNumericField("Normalization", this.normalize, 2, 10, "");
        gd.addNumericField("Scaling", this.scaling, 2, 10, "");
        gd.addCheckbox("Show intermediates", this.showIntermediate);
        gd.addCheckbox("Improved seed detection ", this.improved);
        gd.showDialog();
        this.alpha = gd.getNextNumber();
        this.showEdgesXYZ = gd.getNextBoolean();
        this.symmetry = gd.getNextBoolean();
        this.radius = (int)gd.getNextNumber();
        this.normalize = gd.getNextNumber();
        this.scaling = gd.getNextNumber();
        this.showIntermediate = gd.getNextBoolean();
        this.improved = gd.getNextBoolean();
        Prefs.set((String)"mcib_symmetry_alpha.double ", (double)this.alpha);
        Prefs.set((String)"mcib_symmetry_radius.int", (int)this.radius);
        Prefs.set((String)"mcib_symmetry_normalize.double", (double)this.normalize);
        Prefs.set((String)"mcib_symmetry_scaling.double", (double)this.scaling);
        return gd.wasOKed();
    }
}

