/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.TrimmedButton;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.plugin.frame.PasteController;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import mcib_plugins.ThresholdPlot;

public class ConnectionThresholding_
extends PlugInFrame
implements PlugIn,
Measurements,
Runnable,
ActionListener,
AdjustmentListener,
ItemListener {
    static final int RED = 0;
    static final int BLACK_AND_WHITE = 1;
    static final int OVER_UNDER = 2;
    static final String[] modes = new String[]{"Red", "Black & White", "Over/Under"};
    static final double defaultMinThreshold = 85.0;
    static final double defaultMaxThreshold = 170.0;
    static final int RESET = 0;
    static final int AUTO = 1;
    static final int HIST = 2;
    static final int APPLY = 3;
    static final int STATE_CHANGE = 4;
    static final int MIN_THRESHOLD = 5;
    static final int MAX_THRESHOLD = 6;
    static final int SET = 7;
    static final int MINUS_HYST = 8;
    static final int PLUS_HYST = 9;
    static boolean fill1 = true;
    static boolean fill2 = true;
    static boolean useBW = true;
    static boolean backgroundToNaN = true;
    static Frame instance;
    static int mode;
    static Choice choice;
    ThresholdPlot plot = new ThresholdPlot();
    Thread thread;
    int minValue = -1;
    int maxValue = -1;
    int sliderRange = 256;
    boolean doAutoAdjust;
    boolean doReset;
    boolean doApplyLut;
    boolean doStateChange;
    boolean doSet;
    Panel panel;
    Button autoB;
    Button resetB;
    Button applyB;
    Button setB;
    int previousImageID;
    int previousImageType;
    double previousMin;
    double previousMax;
    ImageJ ij;
    double minThreshold;
    double maxThreshold;
    int minusHyst = 5;
    int plusHyst = 5;
    int minusHystValue;
    int plusHystValue;
    Scrollbar minSlider;
    Scrollbar maxSlider;
    Scrollbar minhystSlider;
    Scrollbar maxhystSlider;
    Label label1;
    Label label2;
    Label label3;
    Label label4;
    boolean done;
    boolean invertedLut;
    int lutColor;
    boolean firstActivation;
    ImagePlus impOrig;
    ImageProcessor ipOrig;

    public ConnectionThresholding_() {
        super("Connection Thresholding");
        if (instance != null) {
            instance.toFront();
            return;
        }
        WindowManager.addWindow((Frame)((Object)this));
        instance = this;
        IJ.register(PasteController.class);
        this.ij = IJ.getInstance();
        Font font = new Font("SansSerif", 0, 10);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        int y = 0;
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 2;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(10, 10, 0, 10);
        this.add(this.plot, c);
        this.plot.addKeyListener((KeyListener)this.ij);
        this.minSlider = new Scrollbar(0, this.sliderRange / 3, 1, 0, this.sliderRange);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 90.0 : 100.0;
        c.fill = 2;
        c.insets = new Insets(5, 10, 0, 0);
        this.add(this.minSlider, c);
        this.minSlider.addAdjustmentListener(this);
        this.minSlider.addKeyListener((KeyListener)this.ij);
        this.minSlider.setUnitIncrement(1);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 10.0 : 0.0;
        c.insets = new Insets(5, 0, 0, 10);
        this.label1 = new Label("      ", 2);
        this.label1.setFont(font);
        this.add(this.label1, c);
        this.maxSlider = new Scrollbar(0, this.sliderRange * 2 / 3, 1, 0, this.sliderRange);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = 100.0;
        c.insets = new Insets(0, 10, 0, 0);
        this.add(this.maxSlider, c);
        this.maxSlider.addAdjustmentListener(this);
        this.maxSlider.addKeyListener((KeyListener)this.ij);
        this.maxSlider.setUnitIncrement(1);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 10);
        this.label2 = new Label("      ", 2);
        this.label2.setFont(font);
        this.add(this.label2, c);
        this.minhystSlider = new Scrollbar(0, 5, 1, 0, this.sliderRange);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 90.0 : 100.0;
        c.fill = 2;
        c.insets = new Insets(0, 10, 0, 0);
        this.add(this.minhystSlider, c);
        this.minhystSlider.addAdjustmentListener(this);
        this.minhystSlider.addKeyListener((KeyListener)this.ij);
        this.minhystSlider.setUnitIncrement(1);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 10.0 : 0.0;
        c.insets = new Insets(0, 0, 0, 10);
        this.label3 = new Label("      ", 2);
        this.label3.setFont(font);
        this.add(this.label3, c);
        this.maxhystSlider = new Scrollbar(0, 5, 1, 0, this.sliderRange);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 90.0 : 100.0;
        c.fill = 2;
        c.insets = new Insets(0, 10, 0, 0);
        this.add(this.maxhystSlider, c);
        this.maxhystSlider.addAdjustmentListener(this);
        this.maxhystSlider.addKeyListener((KeyListener)this.ij);
        this.maxhystSlider.setUnitIncrement(1);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 10.0 : 0.0;
        c.insets = new Insets(0, 0, 0, 10);
        this.label4 = new Label("      ", 2);
        this.label4.setFont(font);
        this.add(this.label4, c);
        int trim = IJ.isMacOSX() ? 11 : 0;
        this.panel = new Panel();
        this.autoB = new TrimmedButton("Auto", trim);
        this.autoB.addActionListener(this);
        this.autoB.addKeyListener((KeyListener)this.ij);
        this.panel.add(this.autoB);
        this.applyB = new TrimmedButton("Multi", trim);
        this.applyB.addActionListener(this);
        this.applyB.addKeyListener((KeyListener)this.ij);
        this.panel.add(this.applyB);
        this.resetB = new TrimmedButton("Hyst", trim);
        this.resetB.addActionListener(this);
        this.resetB.addKeyListener((KeyListener)this.ij);
        this.panel.add(this.resetB);
        this.setB = new TrimmedButton("Set", trim);
        this.setB.addActionListener(this);
        this.setB.addKeyListener((KeyListener)this.ij);
        this.panel.add(this.setB);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 2;
        c.insets = new Insets(0, 5, 10, 5);
        this.add(this.panel, c);
        this.addKeyListener((KeyListener)this.ij);
        this.pack();
        GUI.center((Window)((Object)this));
        this.firstActivation = true;
        if (IJ.isMacOSX()) {
            this.setResizable(false);
        }
        this.setVisible(true);
        this.thread = new Thread((Runnable)this, "Hysteresis_");
        this.thread.start();
        this.impOrig = WindowManager.getCurrentImage();
        if (this.impOrig != null) {
            this.ipOrig = this.setup(this.impOrig);
        }
    }

    @Override
    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this.minSlider) {
            this.minValue = this.minSlider.getValue();
        } else if (e.getSource() == this.maxSlider) {
            this.maxValue = this.maxSlider.getValue();
        } else if (e.getSource() == this.minhystSlider) {
            this.minusHystValue = this.minhystSlider.getValue();
        } else {
            this.plusHystValue = this.maxhystSlider.getValue();
        }
        this.notify();
    }

    @Override
    public synchronized void actionPerformed(ActionEvent e) {
        Button b = (Button)e.getSource();
        if (b == null) {
            return;
        }
        if (b == this.resetB) {
            this.doReset = true;
        } else if (b == this.autoB) {
            this.doAutoAdjust = true;
        } else if (b == this.applyB) {
            this.doApplyLut = true;
        } else if (b == this.setB) {
            this.doSet = true;
        }
        this.notify();
    }

    @Override
    public synchronized void itemStateChanged(ItemEvent e) {
        mode = choice.getSelectedIndex();
        this.doStateChange = true;
        this.notify();
    }

    ImageProcessor setup(ImagePlus imp) {
        boolean not8Bits;
        int type = imp.getType();
        if (type == 4) {
            return null;
        }
        ImageProcessor ip = imp.getProcessor();
        boolean minMaxChange = false;
        boolean bl = not8Bits = type == 1 || type == 2;
        if (not8Bits) {
            if (ip.getMin() == this.plot.stackMin && ip.getMax() == this.plot.stackMax) {
                minMaxChange = false;
            } else if (ip.getMin() != this.previousMin || ip.getMax() != this.previousMax) {
                minMaxChange = true;
                this.previousMin = ip.getMin();
                this.previousMax = ip.getMax();
            }
        }
        int id = imp.getID();
        if (minMaxChange || id != this.previousImageID || type != this.previousImageType) {
            if (not8Bits && minMaxChange) {
                ip.resetMinAndMax();
                imp.updateAndDraw();
            }
            this.invertedLut = imp.isInvertedLut();
            this.minThreshold = ip.getMinThreshold();
            this.maxThreshold = ip.getMaxThreshold();
            ImageStatistics stats = this.plot.setHistogram(imp, false);
            if (this.minThreshold == -808080.0) {
                this.autoSetLevels(ip, stats);
            } else {
                this.minThreshold = this.scaleDown(ip, this.minThreshold);
                this.maxThreshold = this.scaleDown(ip, this.maxThreshold);
            }
            this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold, this.minusHyst, this.plusHyst);
            this.updateLabels(imp, ip);
            this.updatePlot();
            this.updateScrollBars();
            imp.updateAndDraw();
        }
        this.previousImageID = id;
        this.previousImageType = type;
        return ip;
    }

    void autoSetLevels(ImageProcessor ip, ImageStatistics stats) {
        boolean unbalanced;
        if (stats == null || stats.histogram == null) {
            this.minThreshold = 85.0;
            this.maxThreshold = 170.0;
            return;
        }
        int threshold = ip.getAutoThreshold(stats.histogram);
        int count1 = 0;
        int count2 = 0;
        for (int i = 0; i < 256; ++i) {
            if (i < threshold) {
                count1 += stats.histogram[i];
                continue;
            }
            count2 += stats.histogram[i];
        }
        boolean bl = unbalanced = (double)count1 / (double)count2 > 1.25 || (double)count2 / (double)count1 > 1.25;
        if (unbalanced) {
            if (stats.max - stats.dmode > stats.dmode - stats.min) {
                this.minThreshold = threshold;
                this.maxThreshold = stats.max;
            } else {
                this.minThreshold = stats.min;
                this.maxThreshold = threshold;
            }
        } else if (ip.isInvertedLut()) {
            this.minThreshold = threshold;
            this.maxThreshold = 255.0;
        } else {
            this.minThreshold = 0.0;
            this.maxThreshold = threshold;
        }
        if (Recorder.record) {
            Recorder.record((String)"setAutoThreshold");
        }
    }

    void scaleUpAndSet(ImageProcessor ip, double minThreshold, double maxThreshold, int minus, int plus) {
        double min = this.scaleUp(ip, minThreshold);
        double max = this.scaleUp(ip, maxThreshold);
        byte[] rLUT2 = new byte[256];
        byte[] gLUT2 = new byte[256];
        byte[] bLUT2 = new byte[256];
        for (int i = 0; i < 256; ++i) {
            double ii = this.scaleUp(ip, i);
            if (ii >= min && ii <= max) {
                rLUT2[i] = -1;
                gLUT2[i] = 0;
                bLUT2[i] = 0;
                continue;
            }
            if (ii >= min - (double)minus && ii < min) {
                rLUT2[i] = 0;
                gLUT2[i] = 0;
                bLUT2[i] = -1;
                continue;
            }
            if (ii > max && ii <= max + (double)plus) {
                rLUT2[i] = 0;
                gLUT2[i] = -1;
                bLUT2[i] = 0;
                continue;
            }
            rLUT2[i] = 0;
            gLUT2[i] = 0;
            bLUT2[i] = 0;
        }
        IndexColorModel cm = new IndexColorModel(8, 256, rLUT2, gLUT2, bLUT2);
        ip.setColorModel((ColorModel)cm);
    }

    double scaleDown(ImageProcessor ip, double threshold) {
        if (ip instanceof ByteProcessor) {
            return threshold;
        }
        double min = ip.getMin();
        double max = ip.getMax();
        if (max > min) {
            return (threshold - min) / (max - min) * 255.0;
        }
        return -808080.0;
    }

    double scaleUp(ImageProcessor ip, double threshold) {
        double min = ip.getMin();
        double max = ip.getMax();
        if (max > min) {
            return min + threshold / 255.0 * (max - min);
        }
        return -808080.0;
    }

    void updatePlot() {
        this.plot.minThreshold = this.minThreshold;
        this.plot.maxThreshold = this.maxThreshold;
        this.plot.mode = mode;
        this.plot.repaint();
    }

    void updateLabels(ImagePlus imp, ImageProcessor ip) {
        double min = this.scaleUp(imp.getProcessor(), this.minThreshold);
        double max = this.scaleUp(imp.getProcessor(), this.maxThreshold);
        this.label1.setText(IJ.d2s((double)min, (int)2));
        this.label2.setText(IJ.d2s((double)max, (int)2));
        this.label3.setText(String.valueOf(this.minusHyst));
        this.label4.setText(String.valueOf(this.plusHyst));
    }

    void updateScrollBars() {
        this.minSlider.setValue((int)this.minThreshold);
        this.maxSlider.setValue((int)this.maxThreshold);
        this.minhystSlider.setValue(this.minusHyst);
        this.maxhystSlider.setValue(this.plusHyst);
    }

    void doMasking(ImagePlus imp, ImageProcessor ip) {
        ImageProcessor mask = imp.getMask();
        if (mask != null) {
            ip.reset(mask);
        }
    }

    void adjustMinThreshold(ImagePlus imp, ImageProcessor ip, double value) {
        if (IJ.altKeyDown() || IJ.shiftKeyDown()) {
            double width = this.maxThreshold - this.minThreshold;
            if (width < 1.0) {
                width = 1.0;
            }
            this.minThreshold = value;
            this.maxThreshold = this.minThreshold + width;
            if (this.minThreshold + width > 255.0) {
                this.minThreshold = 255.0 - width;
                this.maxThreshold = this.minThreshold + width;
                this.minSlider.setValue((int)this.minThreshold);
            }
            this.maxSlider.setValue((int)this.maxThreshold);
            this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold, this.minusHyst, this.plusHyst);
            return;
        }
        this.minThreshold = value;
        if (this.maxThreshold < this.minThreshold) {
            this.maxThreshold = this.minThreshold;
            this.maxSlider.setValue((int)this.maxThreshold);
        }
        double min = ip.getMin();
        double mint = this.scaleUp(ip, this.minThreshold);
        if (mint - (double)this.minusHyst < min) {
            this.minusHyst = (int)(mint - min);
            this.minhystSlider.setValue(this.minusHyst);
        }
        this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold, this.minusHyst, this.plusHyst);
    }

    void adjustMinusHyst(ImagePlus imp, ImageProcessor ip, double value) {
        this.minusHyst = (int)value;
        double min = ip.getMin();
        double mint = this.scaleUp(ip, this.minThreshold);
        if (mint - (double)this.minusHyst < min) {
            this.minusHyst = (int)(mint - min);
            this.minhystSlider.setValue(this.minusHyst);
        }
        this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold, this.minusHyst, this.plusHyst);
    }

    void adjustPlusHyst(ImagePlus imp, ImageProcessor ip, double value) {
        this.plusHyst = (int)value;
        double max = ip.getMax();
        double maxt = this.scaleUp(ip, this.maxThreshold);
        if (maxt + (double)this.plusHyst > max) {
            this.plusHyst = (int)(max - maxt);
            this.maxhystSlider.setValue(this.plusHyst);
        }
        this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold, this.minusHyst, this.plusHyst);
    }

    void adjustMaxThreshold(ImagePlus imp, ImageProcessor ip, int cvalue) {
        this.maxThreshold = cvalue;
        if (this.minThreshold > this.maxThreshold) {
            this.minThreshold = this.maxThreshold;
            this.minSlider.setValue((int)this.minThreshold);
        }
        double max = ip.getMax();
        double maxt = this.scaleUp(ip, this.maxThreshold);
        if (maxt + (double)this.plusHyst > max) {
            this.plusHyst = (int)(max - maxt);
            this.maxhystSlider.setValue(this.plusHyst);
        }
        this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold, this.minusHyst, this.plusHyst);
        IJ.setKeyUp((int)18);
        IJ.setKeyUp((int)16);
    }

    void doSet(ImagePlus imp, ImageProcessor ip) {
        boolean outOfRange;
        double level1 = ip.getMinThreshold();
        double level2 = ip.getMaxThreshold();
        if (level1 == -808080.0) {
            level1 = this.scaleUp(ip, 85.0);
            level2 = this.scaleUp(ip, 170.0);
        }
        Calibration cal = imp.getCalibration();
        int digits = ip instanceof FloatProcessor || cal.calibrated() ? 2 : 0;
        level1 = cal.getCValue(level1);
        level2 = cal.getCValue(level2);
        GenericDialog gd = new GenericDialog("Set Threshold Levels");
        gd.addNumericField("Lower Threshold Level: ", level1, digits);
        gd.addNumericField("Upper Threshold Level: ", level2, digits);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        level1 = gd.getNextNumber();
        level2 = gd.getNextNumber();
        level1 = cal.getRawValue(level1);
        if ((level2 = cal.getRawValue(level2)) < level1) {
            level2 = level1;
        }
        double minDisplay = ip.getMin();
        double maxDisplay = ip.getMax();
        ip.resetMinAndMax();
        double minValue = ip.getMin();
        double maxValue = ip.getMax();
        if (level1 < minValue) {
            level1 = minValue;
        }
        if (level2 > maxValue) {
            level2 = maxValue;
        }
        boolean bl = outOfRange = level1 < minDisplay || level2 > maxDisplay;
        if (outOfRange) {
            this.plot.setHistogram(imp, false);
        } else {
            ip.setMinAndMax(minDisplay, maxDisplay);
        }
        this.minThreshold = this.scaleDown(ip, level1);
        this.maxThreshold = this.scaleDown(ip, level2);
        this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold, this.minusHyst, this.plusHyst);
        this.updateScrollBars();
        if (Recorder.record) {
            if (imp.getBitDepth() == 32) {
                Recorder.record((String)"setThreshold", (double)ip.getMinThreshold(), (double)ip.getMaxThreshold());
            } else {
                int min = (int)ip.getMinThreshold();
                int max = (int)ip.getMaxThreshold();
                if (cal.isSigned16Bit()) {
                    min = (int)cal.getCValue(level1);
                    max = (int)cal.getCValue(level2);
                }
                Recorder.record((String)"setThreshold", (int)min, (int)max);
            }
        }
    }

    void changeState(ImagePlus imp, ImageProcessor ip) {
        this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold, this.minusHyst, this.plusHyst);
        this.updateScrollBars();
    }

    void autoThreshold(ImagePlus imp, ImageProcessor ip) {
        ip.resetThreshold();
        this.previousImageID = 0;
        this.setup(imp);
    }

    public ImagePlus doTrin(ImagePlus imaplus, double T1, double T2, int minhyst, int plushyst) {
        int ns = imaplus.getStack().getSize();
        if (ns > 1) {
            ImageStack st = imaplus.getStack();
            ImageStack res = new ImageStack(st.getWidth(), st.getHeight());
            for (int s = 1; s <= ns; ++s) {
                res.addSlice("", (ImageProcessor)this.trin(st.getProcessor(s), T1, T2, minhyst, plushyst));
            }
            return new ImagePlus("Multi_Thresholding", res);
        }
        return new ImagePlus("Multi_Thresholding", (ImageProcessor)this.trin(imaplus.getProcessor(), T1, T2, minhyst, plushyst));
    }

    public ImagePlus doHyst(ImagePlus imaplus, double T1, double T2, int minhyst, int plushyst) {
        boolean do3d = false;
        int ns = imaplus.getStack().getSize();
        if (ns > 1) {
            ImageStack st = imaplus.getStack();
            ImageStack res = new ImageStack(st.getWidth(), st.getHeight());
            for (int s = 1; s <= ns; ++s) {
                res.addSlice("", (ImageProcessor)this.hyst(st.getProcessor(s), T1, T2, minhyst, plushyst));
            }
            return new ImagePlus("Hysteresis_Thresholding", res);
        }
        return new ImagePlus("Hysteresis_Thresholding", (ImageProcessor)this.hyst(imaplus.getProcessor(), T1, T2, minhyst, plushyst));
    }

    private ByteProcessor trin(ImageProcessor ima, double T1, double T2, int minhyst, int plushyst) {
        int la = ima.getWidth();
        int ha = ima.getHeight();
        ByteProcessor res = new ByteProcessor(la, ha);
        double min = this.scaleUp(ima, this.minThreshold);
        double max = this.scaleUp(ima, this.maxThreshold);
        for (int x = 0; x < la; ++x) {
            for (int y = 0; y < ha; ++y) {
                float pix = ima.getPixelValue(x, y);
                if ((double)pix >= min && (double)pix <= max) {
                    res.putPixelValue(x, y, 255.0);
                    continue;
                }
                if ((double)pix >= min - (double)minhyst && (double)pix < min) {
                    res.putPixelValue(x, y, 100.0);
                    continue;
                }
                if (!((double)pix <= max + (double)plushyst) || !((double)pix > max)) continue;
                res.putPixelValue(x, y, 200.0);
            }
        }
        return res;
    }

    private ByteProcessor hyst(ImageProcessor ima, double T1, double T2, int minhyst, int plushyst) {
        int y;
        int x;
        int la = ima.getWidth();
        int ha = ima.getHeight();
        boolean change = true;
        ByteProcessor trin = new ByteProcessor(la, ha);
        double min = this.scaleUp(ima, this.minThreshold);
        double max = this.scaleUp(ima, this.maxThreshold);
        for (int x2 = 0; x2 < la; ++x2) {
            for (int y2 = 0; y2 < ha; ++y2) {
                float pix = ima.getPixelValue(x2, y2);
                if ((double)pix >= min && (double)pix <= max) {
                    trin.putPixelValue(x2, y2, 255.0);
                    continue;
                }
                if (!((double)pix >= min - (double)minhyst && (double)pix < min) && (!((double)pix <= max + (double)plushyst) || !((double)pix > max))) continue;
                trin.putPixelValue(x2, y2, 128.0);
            }
        }
        ByteProcessor res = (ByteProcessor)trin.duplicate();
        while (change) {
            change = false;
            for (x = 1; x < la - 1; ++x) {
                for (y = 1; y < ha - 1; ++y) {
                    if (res.getPixelValue(x, y) != 255.0f) continue;
                    if (res.getPixelValue(x + 1, y) == 128.0f) {
                        change = true;
                        res.putPixelValue(x + 1, y, 255.0);
                    }
                    if (res.getPixelValue(x - 1, y) == 128.0f) {
                        change = true;
                        res.putPixelValue(x - 1, y, 255.0);
                    }
                    if (res.getPixelValue(x, y + 1) == 128.0f) {
                        change = true;
                        res.putPixelValue(x, y + 1, 255.0);
                    }
                    if (res.getPixelValue(x, y - 1) == 128.0f) {
                        change = true;
                        res.putPixelValue(x, y - 1, 255.0);
                    }
                    if (res.getPixelValue(x + 1, y + 1) == 128.0f) {
                        change = true;
                        res.putPixelValue(x + 1, y + 1, 255.0);
                    }
                    if (res.getPixelValue(x - 1, y - 1) == 128.0f) {
                        change = true;
                        res.putPixelValue(x - 1, y - 1, 255.0);
                    }
                    if (res.getPixelValue(x - 1, y + 1) == 128.0f) {
                        change = true;
                        res.putPixelValue(x - 1, y + 1, 255.0);
                    }
                    if (res.getPixelValue(x + 1, y - 1) != 128.0f) continue;
                    change = true;
                    res.putPixelValue(x + 1, y - 1, 255.0);
                }
            }
            if (!change) continue;
            for (x = la - 2; x > 0; --x) {
                for (y = ha - 2; y > 0; --y) {
                    if (res.getPixelValue(x, y) != 255.0f) continue;
                    if (res.getPixelValue(x + 1, y) == 128.0f) {
                        change = true;
                        res.putPixelValue(x + 1, y, 255.0);
                    }
                    if (res.getPixelValue(x - 1, y) == 128.0f) {
                        change = true;
                        res.putPixelValue(x - 1, y, 255.0);
                    }
                    if (res.getPixelValue(x, y + 1) == 128.0f) {
                        change = true;
                        res.putPixelValue(x, y + 1, 255.0);
                    }
                    if (res.getPixelValue(x, y - 1) == 128.0f) {
                        change = true;
                        res.putPixelValue(x, y - 1, 255.0);
                    }
                    if (res.getPixelValue(x + 1, y + 1) == 128.0f) {
                        change = true;
                        res.putPixelValue(x + 1, y + 1, 255.0);
                    }
                    if (res.getPixelValue(x - 1, y - 1) == 128.0f) {
                        change = true;
                        res.putPixelValue(x - 1, y - 1, 255.0);
                    }
                    if (res.getPixelValue(x - 1, y + 1) == 128.0f) {
                        change = true;
                        res.putPixelValue(x - 1, y + 1, 255.0);
                    }
                    if (res.getPixelValue(x + 1, y - 1) != 128.0f) continue;
                    change = true;
                    res.putPixelValue(x + 1, y - 1, 255.0);
                }
            }
        }
        for (x = 0; x < la; ++x) {
            for (y = 0; y < ha; ++y) {
                if (res.getPixelValue(x, y) != 128.0f) continue;
                res.putPixelValue(x, y, 0.0);
            }
        }
        return res;
    }

    void runThresholdCommand() {
        Recorder.recordInMacros = true;
        IJ.run((String)"Convert to Mask");
        Recorder.recordInMacros = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.done) {
            ConnectionThresholding_ connectionThresholding_ = this;
            synchronized (connectionThresholding_) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.doUpdate();
        }
    }

    void doUpdate() {
        int action;
        int min = this.minValue;
        int max = this.maxValue;
        int minus = this.minusHystValue;
        int plus = this.plusHystValue;
        System.out.println(this.minusHystValue + " " + this.plusHystValue);
        if (this.doReset) {
            action = 0;
        } else if (this.doAutoAdjust) {
            action = 1;
        } else if (this.doApplyLut) {
            action = 3;
        } else if (this.doStateChange) {
            action = 4;
        } else if (this.doSet) {
            action = 7;
        } else if (this.minValue >= 0) {
            action = 5;
        } else if (this.maxValue >= 0) {
            action = 6;
        } else if (this.minusHystValue >= 0) {
            action = 8;
        } else if (this.plusHystValue >= 0) {
            action = 9;
        } else {
            return;
        }
        this.minValue = -1;
        this.maxValue = -1;
        this.minusHystValue = -1;
        this.plusHystValue = -1;
        this.doReset = false;
        this.doAutoAdjust = false;
        this.doApplyLut = false;
        this.doStateChange = false;
        this.doSet = false;
        switch (action) {
            case 0: {
                this.doHyst(this.impOrig, this.minThreshold, this.maxThreshold, this.minusHyst, this.plusHyst).show();
                break;
            }
            case 1: {
                this.autoThreshold(this.impOrig, this.ipOrig);
                break;
            }
            case 3: {
                this.doTrin(this.impOrig, this.minThreshold, this.maxThreshold, this.minusHyst, this.plusHyst).show();
                break;
            }
            case 4: {
                this.changeState(this.impOrig, this.ipOrig);
                break;
            }
            case 7: {
                this.doSet(this.impOrig, this.ipOrig);
                break;
            }
            case 5: {
                this.adjustMinThreshold(this.impOrig, this.ipOrig, min);
                break;
            }
            case 6: {
                this.adjustMaxThreshold(this.impOrig, this.ipOrig, max);
                break;
            }
            case 8: {
                this.adjustMinusHyst(this.impOrig, this.ipOrig, minus);
                break;
            }
            case 9: {
                this.adjustPlusHyst(this.impOrig, this.ipOrig, plus);
            }
        }
        this.updatePlot();
        this.updateLabels(this.impOrig, this.ipOrig);
        this.ipOrig.setLutAnimation(true);
        this.impOrig.updateAndDraw();
    }

    public void windowClosing(WindowEvent e) {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        instance = null;
        this.done = true;
        ConnectionThresholding_ connectionThresholding_ = this;
        synchronized (connectionThresholding_) {
            this.notify();
        }
    }

    public void windowActivated(WindowEvent e) {
        super.windowActivated(e);
        if (this.impOrig != null) {
            if (!this.firstActivation) {
                this.previousImageID = 0;
                this.setup(this.impOrig);
            }
            this.firstActivation = false;
        }
    }

    static {
        mode = 0;
    }
}

