/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.text.NumberFormat;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.ObjectCreator3D;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;

public class Convex_Hull3D
implements PlugInFilter {
    ImagePlus imp;
    float rad;

    public void run(ImageProcessor ip) {
        Calibration cal = this.imp.getCalibration();
        double resXY = 1.0;
        double resZ = 1.0;
        String unit = "pix";
        if (cal != null && cal.scaled()) {
            resXY = cal.pixelWidth;
            resZ = cal.pixelDepth;
            unit = cal.getUnits();
        }
        ImageInt ima = ImageInt.wrap((ImagePlus)this.imp.duplicate());
        ima.setScale(1.0, 1.0, "pix");
        ObjectCreator3D hulls = new ObjectCreator3D(ima.sizeX, ima.sizeY, ima.sizeZ);
        hulls.setResolution(resXY, resZ, unit);
        int valmin = (int)ima.getMinAboveValue(0.0f);
        int valmax = (int)ima.getMax();
        for (int val = valmin; val <= valmax; ++val) {
            if (!ima.hasOneValue((float)val)) continue;
            Object3DVoxels obj = new Object3DVoxels((ImageHandler)ima, val);
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(3);
            if (obj.getVolumePixels() <= 0) continue;
            IJ.log((String)("Processing obj " + val));
            Object3DVoxels objC = obj.getConvexObject();
            objC.draw(hulls, val);
        }
        ImageHandler imageHandler = hulls.getImageHandler();
        if (cal != null) {
            imageHandler.setCalibration(cal);
        }
        ImagePlus plus = imageHandler.getImagePlus();
        plus.setCalibration(cal);
        plus.setSlice(plus.getStackSize() / 2);
        plus.setDisplayRange(0.0, (double)valmax);
        plus.setTitle("convex_Hull");
        plus.show();
    }

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 133;
    }
}

