/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.io.File;
import java.util.List;
import mcib3d.geom2.Objects3DIntPopulation;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.processing.ImageCropper;

public class Crop3D_All
implements PlugInFilter {
    ImagePlus imp;
    String dir = Prefs.get((String)"Crop3DAll_dir.string", (String)"Existing Folder");

    public void run(ImageProcessor ip) {
        if (this.Dialogue()) {
            File dirFile = new File(this.dir);
            if (!dirFile.exists()) {
                IJ.log((String)("Directory " + this.dir + " does not exist, please create it before running this plugin."));
                return;
            }
            Prefs.set((String)"Crop3DAll_dir.string", (String)this.dir);
            ImageHandler ima = ImageHandler.wrap((ImagePlus)this.imp);
            Objects3DIntPopulation population = new Objects3DIntPopulation(ima);
            List crops = new ImageCropper(ima).cropBoundingBoxMaskPopulation(population);
            String name = ima.getTitle();
            for (ImageHandler crop : crops) {
                crop.setTitle(name + "_" + crop.getTitle() + ".tif");
                crop.save(this.dir);
            }
        }
    }

    private boolean Dialogue() {
        GenericDialog gd = new GenericDialog("3D Crop All");
        gd.addDirectoryField("Choose directory", IJ.getDirectory((String)"home"));
        gd.showDialog();
        this.dir = gd.getNextString();
        return !gd.wasCanceled();
    }

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 13;
    }
}

