/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import mcib3d.geom2.Objects3DIntPopulation;
import mcib3d.geom2.measurementsPopulation.MeasurePopulationDistance;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.processing.ImageCropper;

public class DistancesContainer_
implements PlugIn {
    private int idxA;
    private int idxB;
    private double maxDist = 1000.0;
    private String measurement = "DistCenterCenterPix";

    public void run(String s) {
        int nbima = WindowManager.getImageCount();
        if (nbima < 2) {
            IJ.error((String)"Requires two labelled image");
            return;
        }
        if (this.dialog()) {
            IJ.log((String)"");
            IJ.log((String)"Building objects population");
            ImagePlus plusA = WindowManager.getImage((int)(this.idxA + 1));
            ImagePlus plusB = WindowManager.getImage((int)(this.idxB + 1));
            ImageHandler image1 = ImageHandler.wrap((ImagePlus)plusA);
            ImageHandler image2 = ImageHandler.wrap((ImagePlus)plusB);
            Objects3DIntPopulation population2 = new Objects3DIntPopulation(image2);
            List objects3d = population2.getObjects3DInt();
            AtomicInteger row = new AtomicInteger(0);
            ResultsTable rt = ResultsTable.getResultsTable() == null ? new ResultsTable() : ResultsTable.getResultsTable();
            rt.reset();
            objects3d.forEach(cont3d -> {
                IJ.log((String)("Computing distances within object " + cont3d.getLabel()));
                ImageHandler cropped = new ImageCropper(image1).cropBoundingBoxMaskObject(cont3d);
                Objects3DIntPopulation popCropped = new Objects3DIntPopulation(cropped);
                MeasurePopulationDistance distance = new MeasurePopulationDistance(popCropped, popCropped, this.maxDist, this.measurement);
                popCropped.getObjects3DInt().forEach(obj3d -> {
                    double[] dists = distance.getValuesObject1Sorted(obj3d.getLabel(), true);
                    rt.incrementCounter();
                    for (int i = 0; i < dists.length; i += 3) {
                        rt.setValue("LabelCont", row.get(), (double)cont3d.getLabel());
                        rt.setValue("LabelObj", row.get(), dists[i]);
                        rt.setValue("O" + (i + 3) / 3, row.get(), dists[i + 1]);
                        rt.setValue("V" + (i + 3) / 3, row.get(), dists[i + 2]);
                    }
                    row.getAndIncrement();
                });
            });
            rt.show("Distances");
        }
    }

    private boolean dialog() {
        int nbima = WindowManager.getImageCount();
        String[] namesA = new String[nbima];
        String[] namesB = new String[nbima];
        for (int i = 0; i < nbima; ++i) {
            namesA[i] = WindowManager.getImage((int)(i + 1)).getShortTitle();
            namesB[i] = WindowManager.getImage((int)(i + 1)).getShortTitle();
        }
        String[] measurements = new String[]{"DistCenterCenterPix", "DistCenterCenterUnit", "DistBorderBorderPix", "DistBorderBorderUnit"};
        this.idxA = 0;
        this.idxB = nbima > 1 ? 1 : 0;
        this.maxDist = Prefs.get((String)"3DSuiteDistContainer_distMax.double", (double)this.maxDist);
        GenericDialog dia = new GenericDialog("Distances Inside");
        dia.addChoice("Objects for distances", namesA, namesA[this.idxA]);
        dia.addChoice("Containers", namesB, namesB[this.idxB]);
        dia.addChoice("Distance", measurements, this.measurement);
        dia.addNumericField("Max distance", this.maxDist);
        dia.showDialog();
        if (dia.wasOKed()) {
            this.idxA = dia.getNextChoiceIndex();
            this.idxB = dia.getNextChoiceIndex();
            this.measurement = dia.getNextChoice();
            this.maxDist = dia.getNextNumber();
            Prefs.set((String)"3DSuiteDistContainer_distMax.double", (double)this.maxDist);
        }
        return dia.wasOKed();
    }
}

