/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import mcib3d.geom2.Objects3DIntPopulation;
import mcib3d.geom2.measurementsPopulation.MeasurePopulationDistance;
import mcib3d.image3d.ImageHandler;

public class Distances_
implements PlugIn {
    private String measurement = "DistCenterCenterPix";
    private double distMax = 1000.0;
    private int idxA;
    private int idxB;

    public void run(String s) {
        int nbima = WindowManager.getImageCount();
        if (nbima < 1) {
            IJ.error((String)"Needs at least one labelled image");
            return;
        }
        if (this.dialog()) {
            IJ.log((String)"");
            IJ.log((String)"Building objects population");
            ImagePlus plusA = WindowManager.getImage((int)(this.idxA + 1));
            ImagePlus plusB = WindowManager.getImage((int)(this.idxB + 1));
            Objects3DIntPopulation population1 = new Objects3DIntPopulation(ImageHandler.wrap((ImagePlus)plusA));
            Objects3DIntPopulation population2 = new Objects3DIntPopulation(ImageHandler.wrap((ImagePlus)plusB));
            IJ.log((String)"Measuring distances");
            MeasurePopulationDistance distance = new MeasurePopulationDistance(population1, population2);
            distance.setDistanceMax(this.distMax);
            distance.setMeasurementMethod(this.measurement);
            distance.getResultsTableOnlyColoc().show(this.measurement);
        }
    }

    private boolean dialog() {
        int nbima = WindowManager.getImageCount();
        String[] namesA = new String[nbima];
        String[] namesB = new String[nbima];
        for (int i = 0; i < nbima; ++i) {
            namesA[i] = WindowManager.getImage((int)(i + 1)).getShortTitle();
            namesB[i] = WindowManager.getImage((int)(i + 1)).getShortTitle();
        }
        String[] measurements = new String[]{"DistCenterCenterPix", "DistCenterCenterUnit", "DistBorderBorderPix", "DistBorderBorderUnit"};
        this.idxA = 0;
        this.idxB = nbima > 1 ? 1 : 0;
        this.distMax = Prefs.get((String)"3DSuiteDistances_distMax.double", (double)this.distMax);
        GenericDialog dia = new GenericDialog("All Distances");
        dia.addChoice("Image_A", namesA, namesA[this.idxA]);
        dia.addChoice("Image_B", namesB, namesB[this.idxB]);
        dia.addChoice("Distance", measurements, this.measurement);
        dia.addNumericField("Distance_Maximum", this.distMax);
        dia.showDialog();
        if (dia.wasOKed()) {
            this.idxA = dia.getNextChoiceIndex();
            this.idxB = dia.getNextChoiceIndex();
            this.measurement = dia.getNextChoice();
            this.distMax = dia.getNextNumber();
            Prefs.set((String)"3DSuiteDistances_distMax.double", (double)this.distMax);
        }
        return dia.wasOKed();
    }
}

