/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import mcib3d.geom2.Objects3DIntPopulation;
import mcib3d.geom2.measurementsPopulation.MeasurePopulationClosestDistance;
import mcib3d.image3d.ImageHandler;

public class Distances_Closest
implements PlugIn {
    private final boolean removeZero = false;
    private String measurement = "DistCenterCenterPix";
    private double distMax = 1000.0;
    private int idxA;
    private int idxB;
    private double nbClosest = 1.0;

    public void run(String arg) {
        int nbima = WindowManager.getImageCount();
        if (nbima < 1) {
            IJ.error((String)"Needs at least one labelled image");
            return;
        }
        if (this.dialog()) {
            MeasurePopulationClosestDistance closestDistance;
            ImagePlus plusA = WindowManager.getImage((int)(this.idxA + 1));
            ImagePlus plusB = WindowManager.getImage((int)(this.idxB + 1));
            IJ.log((String)"Computing populations");
            Objects3DIntPopulation population1 = new Objects3DIntPopulation(ImageHandler.wrap((ImagePlus)plusA));
            Objects3DIntPopulation population2 = new Objects3DIntPopulation(ImageHandler.wrap((ImagePlus)plusB));
            IJ.log((String)"Computing distances");
            if (this.measurement.equals("DistCenterCenterPix")) {
                closestDistance = this.nbClosest == 1.0 ? new MeasurePopulationClosestDistance(population1, population2, this.distMax, "Closest1CenterPix") : new MeasurePopulationClosestDistance(population1, population2, this.distMax, "Closest2CenterPix");
                closestDistance.setRemoveZeroDistance(false);
                closestDistance.getResultsTableOnlyColoc(true).show("ClosestDistanceCCPix");
            }
            if (this.measurement.equals("DistCenterCenterUnit")) {
                closestDistance = this.nbClosest == 1.0 ? new MeasurePopulationClosestDistance(population1, population2, this.distMax, "Closest1CenterUnit") : new MeasurePopulationClosestDistance(population1, population2, this.distMax, "Closest2CenterUnit");
                closestDistance.setRemoveZeroDistance(false);
                closestDistance.getResultsTableOnlyColoc(true).show("ClosestDistanceCCUnit");
            }
            if (this.measurement.equals("DistBorderBorderPix")) {
                closestDistance = this.nbClosest == 1.0 ? new MeasurePopulationClosestDistance(population1, population2, this.distMax, "Closest1BorderPix") : new MeasurePopulationClosestDistance(population1, population2, this.distMax, "Closest2BorderPix");
                closestDistance.setRemoveZeroDistance(false);
                closestDistance.getResultsTableOnlyColoc(true).show("ClosestDistanceBBPix");
            }
            if (this.measurement.equals("DistBorderBorderUnit")) {
                closestDistance = this.nbClosest == 1.0 ? new MeasurePopulationClosestDistance(population1, population2, this.distMax, "Closest1BorderUnit") : new MeasurePopulationClosestDistance(population1, population2, this.distMax, "Closest2BorderUnit");
                closestDistance.setRemoveZeroDistance(false);
                closestDistance.getResultsTableOnlyColoc(true).show("ClosestDistanceBBUnit");
            }
            IJ.log((String)"Finished");
        }
    }

    private boolean dialog() {
        int nbima = WindowManager.getImageCount();
        String[] namesA = new String[nbima];
        String[] namesB = new String[nbima];
        for (int i = 0; i < nbima; ++i) {
            namesA[i] = WindowManager.getImage((int)(i + 1)).getShortTitle();
            namesB[i] = WindowManager.getImage((int)(i + 1)).getShortTitle();
        }
        String[] measurements = new String[]{"DistCenterCenterPix", "DistCenterCenterUnit", "DistBorderBorderPix", "DistBorderBorderUnit"};
        this.idxA = 0;
        this.idxB = nbima > 1 ? 1 : 0;
        this.distMax = Prefs.get((String)"3DSuiteClosest_distMax.double", (double)this.distMax);
        GenericDialog dia = new GenericDialog("Closest Distances");
        dia.addChoice("Image_A", namesA, namesA[this.idxA]);
        dia.addChoice("Image_B", namesB, namesB[this.idxB]);
        dia.addSlider("Number of closest", 1.0, 2.0, this.nbClosest);
        dia.addMessage("Choose distance to use to compute closest");
        dia.addChoice("Distance", measurements, this.measurement);
        dia.addNumericField("Distance_Maximum", this.distMax);
        dia.showDialog();
        if (dia.wasOKed()) {
            this.idxA = dia.getNextChoiceIndex();
            this.idxB = dia.getNextChoiceIndex();
            this.nbClosest = dia.getNextNumber();
            this.measurement = dia.getNextChoice();
            this.distMax = dia.getNextNumber();
            Prefs.set((String)"3DSuiteClosest_distMax.double", (double)this.distMax);
        }
        return dia.wasOKed();
    }
}

