/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.util.logging.Level;
import java.util.logging.Logger;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.distanceMap3d.EDT;

public class EDT_3D
implements PlugIn {
    boolean inverse = false;
    int threshold = 0;

    public void run(String arg) {
        int nbima = WindowManager.getImageCount();
        if (nbima < 1) {
            IJ.showMessage((String)"No image opened !");
            return;
        }
        String[] namesStructure = new String[nbima];
        String[] namesMask = new String[nbima + 1];
        namesMask[0] = "Same";
        for (int i = 0; i < nbima; ++i) {
            namesStructure[i] = WindowManager.getImage((int)(i + 1)).getShortTitle();
            namesMask[i + 1] = WindowManager.getImage((int)(i + 1)).getShortTitle();
        }
        int struct = 0;
        int mask = 0;
        GenericDialog dia = new GenericDialog("EDT");
        dia.addMessage("This plugin will compute 3D Euclidean Distance Map with calibrated unit.\nIt will also normalise this distance map in each object to get the EVF inside each object.");
        dia.addChoice("Map", new String[]{"EDT", "EVF", "Both"}, "EDT");
        dia.addChoice("Image", namesStructure, namesStructure[struct]);
        dia.addChoice("Mask (for EVF)", namesMask, namesMask[mask]);
        dia.addNumericField("Threshold", (double)this.threshold, 0);
        dia.addCheckbox("Inverse", this.inverse);
        dia.showDialog();
        String map = dia.getNextChoice();
        struct = dia.getNextChoiceIndex();
        mask = dia.getNextChoiceIndex();
        this.threshold = (int)dia.getNextNumber();
        this.inverse = dia.getNextBoolean();
        if (dia.wasOKed()) {
            try {
                ImageHandler img = ImageHandler.wrap((ImagePlus)WindowManager.getImage((int)(struct + 1)));
                IJ.log((String)"Computing Distance Map (EDT) ...");
                ImageFloat r = EDT.run((ImageHandler)img, (float)this.threshold, (boolean)this.inverse, (int)0);
                if (r != null) {
                    r.setTitle("EDT_" + namesStructure[struct]);
                    if (map.compareTo("EVF") != 0) {
                        r.show("EDT");
                    }
                    if (map.compareTo("EDT") != 0) {
                        ImageFloat r2 = r.duplicate();
                        ImageByte imgMask = img.thresholdAboveExclusive((float)this.threshold);
                        if (mask > 0) {
                            imgMask = ImageHandler.wrap((ImagePlus)WindowManager.getImage((int)mask));
                        }
                        if (this.inverse && mask == 0) {
                            imgMask = imgMask.duplicate();
                            imgMask.invert();
                        }
                        IJ.log((String)"Normalizing Distance Map (EVF) ...");
                        r2 = (ImageFloat)EDT.normaliseLabel((ImageInt)((ImageInt)img), (ImageFloat)r2);
                        if (mask > 0) {
                            r2.intersectMask((ImageHandler)imgMask);
                        }
                        r2.show("EVF");
                    }
                }
            }
            catch (Exception ex) {
                Logger.getLogger(EDT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

