/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import ij.plugin.PlugIn;
import mcib3d.image3d.ImageHandler;

public class EVF_Radial
implements PlugIn {
    int nbEVF = 1;
    int nbSig = 0;
    double step = 0.01;
    boolean average = true;
    boolean density = false;
    private boolean saveValues = false;

    public void run(String arg) {
        if (WindowManager.getImageCount() < 2) {
            IJ.showMessage((String)"Needs two images, one EVF and one signal or labels");
            return;
        }
        if (this.dialog()) {
            ImagePlus plus = WindowManager.getImage((int)(this.nbSig + 1));
            String title = plus.getTitle();
            WindowManager.setTempCurrentImage((ImagePlus)plus);
            String dir = IJ.getDirectory((String)"image");
            String fileName = dir + title;
            IJ.log((String)("fileName : " + dir + " * " + title));
            ImageHandler evf = ImageHandler.wrap((ImagePlus)WindowManager.getImage((int)(this.nbEVF + 1)));
            ImageHandler raw = ImageHandler.wrap((ImagePlus)WindowManager.getImage((int)(this.nbSig + 1)));
            double[] sum = new double[(int)(1.0 / this.step)];
            double[] count = new double[(int)(1.0 / this.step)];
            double[] vol = new double[(int)(1.0 / this.step)];
            double[] idx = new double[(int)(1.0 / this.step)];
            for (int z = 0; z < evf.sizeZ; ++z) {
                for (int y = 0; y < evf.sizeY; ++y) {
                    for (int x = 0; x < evf.sizeX; ++x) {
                        float rawPix;
                        float evfPix = evf.getPixel(x, y, z);
                        if (!(evfPix > 0.0f)) continue;
                        int bin = (int)Math.floor((double)evfPix / this.step);
                        if (bin >= sum.length) {
                            bin = sum.length - 1;
                        }
                        if ((rawPix = raw.getPixel(x, y, z)) > 0.0f) {
                            int n = bin;
                            sum[n] = sum[n] + (double)rawPix;
                            int n2 = bin;
                            count[n2] = count[n2] + 1.0;
                        }
                        int n = bin;
                        vol[n] = vol[n] + 1.0;
                    }
                }
            }
            for (int i = 0; i < sum.length; ++i) {
                if (count[i] > 0.0) {
                    int n = i;
                    sum[n] = sum[n] / count[i];
                } else {
                    sum[i] = 0.0;
                }
                if (vol[i] > 0.0) {
                    int n = i;
                    count[n] = count[n] / vol[i];
                } else {
                    count[i] = 0.0;
                }
                idx[i] = (float)((double)i * this.step);
            }
            if (this.average) {
                Plot plot = new Plot("Average Intensity", "evf", "avg");
                plot.addPoints(idx, sum, 2);
                plot.show();
                if (this.saveValues) {
                    plot.getResultsTable().save(fileName + "-EVFLayers-avg.csv");
                }
            }
            if (this.density) {
                Plot plot1 = new Plot("Density", "evf", "density");
                plot1.addPoints(idx, count, 2);
                plot1.show();
                if (this.saveValues) {
                    plot1.getResultsTable().save(fileName + "-EVFLayers-den.csv");
                }
            }
            Plot plot2 = new Plot("Volume of Layers", "evf", "volume");
            plot2.addPoints(idx, vol, 2);
            plot2.show();
            if (this.saveValues) {
                plot2.getResultsTable().save(fileName + "-EVFLayers-vol.csv");
            }
        }
    }

    private boolean dialog() {
        int nbima = WindowManager.getImageCount();
        String[] names = new String[nbima];
        for (int i = 0; i < nbima; ++i) {
            names[i] = WindowManager.getImage((int)(i + 1)).getShortTitle();
        }
        GenericDialog dialog = new GenericDialog("EVF Layer Analysis");
        dialog.addNumericField("Step : ", this.step, 3);
        dialog.addChoice("EVF : ", names, names[this.nbEVF]);
        dialog.addChoice("Signal : ", names, names[this.nbSig]);
        String[] values = new String[]{"Average Intensity", "Density", "Both"};
        dialog.addChoice("Values : ", values, values[0]);
        dialog.addCheckbox("Save values as csv", this.saveValues);
        dialog.showDialog();
        this.step = dialog.getNextNumber();
        this.nbEVF = dialog.getNextChoiceIndex();
        this.nbSig = dialog.getNextChoiceIndex();
        int choice = dialog.getNextChoiceIndex();
        if (choice == 0) {
            this.average = true;
            this.density = false;
        } else if (choice == 1) {
            this.average = false;
            this.density = true;
        } else {
            this.average = true;
            this.density = true;
        }
        this.saveValues = dialog.getNextBoolean();
        return dialog.wasOKed();
    }
}

