/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.text.NumberFormat;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.ObjectCreator3D;
import mcib3d.geom.Objects3DPopulation;
import mcib3d.geom.Vector3D;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.ImageHandler;
import mcib3d.utils.ArrayUtil;

public class Ellipsoids_3D
implements PlugInFilter {
    ImagePlus imp;
    float rad;
    private boolean drawVectors = false;
    private final boolean drawOriented = false;

    public void run(ImageProcessor ip) {
        Calibration cal = this.imp.getCalibration();
        double resXY = 1.0;
        double resZ = 1.0;
        String unit = "pix";
        if (cal != null && cal.scaled()) {
            resXY = cal.pixelWidth;
            resZ = cal.pixelDepth;
            unit = cal.getUnits();
        }
        GenericDialog dialog = new GenericDialog("Ellipsoids options");
        dialog.addMessage("draw ellipsoid");
        dialog.addCheckbox("Draw_vectors", this.drawVectors);
        dialog.showDialog();
        this.drawVectors = dialog.getNextBoolean();
        if (dialog.wasCanceled()) {
            return;
        }
        ObjectCreator3D ellipsoid = new ObjectCreator3D(this.imp.getWidth(), this.imp.getHeight(), this.imp.getStackSize());
        ellipsoid.setResolution(resXY, resZ, unit);
        ObjectCreator3D vectors1 = new ObjectCreator3D(this.imp.getWidth(), this.imp.getHeight(), this.imp.getStackSize());
        vectors1.setResolution(resXY, resZ, unit);
        ObjectCreator3D vectors2 = new ObjectCreator3D(this.imp.getWidth(), this.imp.getHeight(), this.imp.getStackSize());
        vectors2.setResolution(resXY, resZ, unit);
        ObjectCreator3D vectors3 = new ObjectCreator3D(this.imp.getWidth(), this.imp.getHeight(), this.imp.getStackSize());
        vectors3.setResolution(resXY, resZ, unit);
        ObjectCreator3D oriC = new ObjectCreator3D(this.imp.getWidth(), this.imp.getHeight(), this.imp.getStackSize());
        oriC.setResolution(resXY, resZ, unit);
        ImageHandler imageInt = ImageHandler.wrap((ImagePlus)this.imp);
        Objects3DPopulation pop = new Objects3DPopulation(imageInt);
        ResultsTable rt = ResultsTable.getResultsTable() != null ? ResultsTable.getResultsTable() : new ResultsTable();
        int row = rt.getCounter();
        for (int ob = 0; ob < pop.getNbObjects(); ++ob) {
            double r1;
            IJ.log((String)("Processing obj " + ob));
            Object3D obj = pop.getObject(ob);
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(3);
            if (obj.getVolumePixels() <= 0) continue;
            IJ.log((String)("\nobj " + ob + "-" + obj.getValue() + " (2 is main axis)"));
            double[] axy = new double[3];
            double[] axz = new double[3];
            double[] ayz = new double[3];
            for (int i = 0; i < 3; ++i) {
                Vector3D V = obj.getVectorAxis(i);
                IJ.log((String)(ob + ": Vector " + i + " : " + V));
                IJ.log((String)(ob + ": Value  " + i + " : " + nf.format(obj.getValueAxis(i))));
                IJ.log((String)(ob + ": Value  sqrt " + i + " : " + nf.format(Math.sqrt(obj.getValueAxis(i)))));
                axy[i] = V.anglePlaneDegrees(0.0, 0.0, 1.0, 0.0);
                axz[i] = V.anglePlaneDegrees(0.0, 1.0, 0.0, 0.0);
                ayz[i] = V.anglePlaneDegrees(1.0, 0.0, 0.0, 0.0);
                IJ.log((String)("Angle " + i + " with plane XY " + axy[i]));
                IJ.log((String)("Angle " + i + " with plane XZ " + axz[i]));
                IJ.log((String)("Angle " + i + " with plane YZ " + ayz[i]));
            }
            Vector3D V = obj.getVectorAxis(2);
            Vector3D W = obj.getVectorAxis(1);
            Vector3D U = obj.getVectorAxis(0);
            double rad1 = r1 = obj.getRadiusMoments(2);
            double rad2 = Double.NaN;
            if (!Double.isNaN(obj.getMainElongation())) {
                rad2 = rad1 / obj.getMainElongation();
            }
            double rad3 = Double.NaN;
            if (!Double.isNaN(obj.getMedianElongation())) {
                rad3 = rad2 / obj.getMedianElongation();
            }
            if (!Double.isNaN(rad2) && !Double.isNaN(rad3)) {
                IJ.log((String)(ob + ": radii=" + nf.format(rad1) + " " + nf.format(rad2) + " " + nf.format(rad3)));
            } else {
                IJ.log((String)(ob + ": radii=" + nf.format(rad1) + " " + nf.format(rad2) + " NaN"));
            }
            IJ.log((String)("Max :" + r1));
            double d1 = obj.distPixelBorderUnit((double)((int)obj.getCenterX()), (double)((int)obj.getCenterY()), (double)((int)obj.getCenterZ()), obj.getVectorAxis(2));
            double d2 = obj.distPixelBorderUnit((double)((int)obj.getCenterX()), (double)((int)obj.getCenterY()), (double)((int)obj.getCenterZ()), obj.getVectorAxis(2).multiply(-1.0));
            IJ.log((String)("major from distance " + d1 + " " + d2));
            IJ.log((String)("Center : " + obj.getCenterX() + " " + obj.getCenterY() + " " + obj.getCenterZ()));
            int val = obj.getValue();
            ellipsoid.createEllipsoidAxesUnit(obj.getCenterX() * resXY, obj.getCenterY() * resXY, obj.getCenterZ() * resZ, rad1, rad2, rad3, (float)val, V, W, false);
            Vector3D Vec = obj.getCenterAsVectorUnit();
            Vector3D end = Vec.add(obj.getVectorAxis(2), 1.0, rad1);
            vectors1.createLineUnit(Vec, end, (float)val, 1);
            Vec = obj.getCenterAsVectorUnit();
            end = Vec.add(obj.getVectorAxis(1), 1.0, rad1);
            vectors2.createLineUnit(Vec, end, (float)val, 1);
            Vec = obj.getCenterAsVectorUnit();
            end = Vec.add(obj.getVectorAxis(0), 1.0, rad1);
            vectors3.createLineUnit(Vec, end, (float)val, 1);
            IJ.log((String)"Computing feret and poles");
            Voxel3D Feret1 = obj.getFeretVoxel1();
            Voxel3D Feret2 = obj.getFeretVoxel2();
            IJ.log((String)("Pole1 as Feret 1 : " + Feret1));
            IJ.log((String)("Pole2 as Feret 2 : " + Feret2));
            IJ.log((String)("Pole1 as Feret 1 (calibrated) : " + Feret1.getX() * resXY + " " + Feret1.getY() * resXY + " " + Feret1.getZ() * resZ));
            IJ.log((String)("Pole2 as Feret 2 (calibrated) : " + Feret2.getX() * resXY + " " + Feret2.getY() * resXY + " " + Feret2.getZ() * resZ));
            Object3DVoxels ell = new Object3DVoxels(ellipsoid.getImageHandler(), val);
            Voxel3D Ell1 = null;
            Voxel3D Ell2 = null;
            if (ell.isEmpty()) {
                IJ.log((String)"Cannot compute ellipsoid.");
            } else {
                Ell1 = ell.getFeretVoxel1();
                Ell2 = ell.getFeretVoxel2();
                IJ.log((String)("Pole1 as ellipsoid 1 : " + Ell1));
                IJ.log((String)("Pole2 as ellipsoid 2 : " + Ell2));
                IJ.log((String)("Pole1 as ellipsoid 1 (calibrated) : " + Ell1.getX() * resXY + " " + Ell1.getY() * resXY + " " + Ell1.getZ() * resZ));
                IJ.log((String)("Pole2 as ellipsoid 2 (calibrated) : " + Ell2.getX() * resXY + " " + Ell2.getY() * resXY + " " + Ell2.getZ() * resZ));
            }
            oriC.drawVoxels(obj.getBoundingOriented());
            ArrayUtil tab = new ArrayUtil(obj.getBoundingBox());
            IJ.log((String)("BB  : " + tab));
            IJ.log((String)"Volumes:");
            IJ.log((String)("obj:" + obj.getVolumeUnit() + " units"));
            IJ.log((String)("ell:" + obj.getVolumeEllipseUnit() + " unit"));
            IJ.log((String)("obj:" + obj.getVolumePixels() + " pixels"));
            IJ.log((String)("bb:" + obj.getVolumeBoundingBoxPixel() + " pixels"));
            IJ.log((String)("bbo:" + obj.getVolumeBoundingBoxOrientedPixel() + " pixels"));
            rt.incrementCounter();
            rt.setValue("Cx(pix)", row, obj.getCenterX());
            rt.setValue("Cy(pix)", row, obj.getCenterY());
            rt.setValue("Cz(pix)", row, obj.getCenterZ());
            rt.setValue("Vx0(pix)", row, U.getX());
            rt.setValue("Vy0(pix)", row, U.getY());
            rt.setValue("Vz0(pix)", row, U.getZ());
            rt.setValue("Vx1(pix)", row, W.getX());
            rt.setValue("Vy1(pix)", row, W.getY());
            rt.setValue("Vz1(pix)", row, W.getZ());
            rt.setValue("Vx2(pix)", row, V.getX());
            rt.setValue("Vy2(pix)", row, V.getY());
            rt.setValue("Vz2(pix)", row, V.getZ());
            rt.setValue("R1(unit)", row, rad1);
            rt.setValue("R2(unit)", row, rad2);
            rt.setValue("R3(unit)", row, rad3);
            rt.setValue("XY0(deg)", row, axy[0]);
            rt.setValue("XZ0(deg)", row, axz[0]);
            rt.setValue("YZ0(deg)", row, ayz[0]);
            rt.setValue("XY1(deg)", row, axy[1]);
            rt.setValue("XZ1(deg)", row, axz[1]);
            rt.setValue("YZ1(deg)", row, ayz[1]);
            rt.setValue("XY2(deg)", row, axy[2]);
            rt.setValue("XZ2(deg)", row, axz[2]);
            rt.setValue("YZ2(deg)", row, ayz[2]);
            rt.setValue("Vobj(pix)", row, (double)obj.getVolumePixels());
            rt.setValue("Vobj(unit)", row, obj.getVolumeUnit());
            rt.setValue("Vell(unit)", row, obj.getVolumeEllipseUnit());
            rt.setValue("RatioVobjVell", row, obj.getRatioEllipsoid());
            rt.setValue("Vbb(pix)", row, obj.getVolumeBoundingBoxPixel());
            rt.setValue("Vbbo(pix)", row, obj.getVolumeBoundingBoxOrientedPixel());
            rt.setValue("Feret1.X", row, Feret1.getX());
            rt.setValue("Feret1.Y", row, Feret1.getY());
            rt.setValue("Feret1.Z", row, Feret1.getZ());
            rt.setValue("Feret2.X", row, Feret2.getX());
            rt.setValue("Feret2.Y", row, Feret2.getY());
            rt.setValue("Feret2.Z", row, Feret2.getZ());
            if (Ell1 != null && Ell2 != null) {
                rt.setValue("Pole1.X", row, Ell1.getX());
                rt.setValue("Pole1.Y", row, Ell1.getY());
                rt.setValue("Pole1.Z", row, Ell1.getZ());
                rt.setValue("Pole2.X", row, Ell2.getX());
                rt.setValue("Pole2.Y", row, Ell2.getY());
                rt.setValue("Pole2.Z", row, Ell2.getZ());
            }
            ++row;
        }
        rt.show("Results");
        ImagePlus plus = new ImagePlus("Ellipsoids", ellipsoid.getStack());
        if (cal != null) {
            plus.setCalibration(cal);
        }
        plus.show();
        if (this.drawVectors) {
            ImagePlus plusV1 = new ImagePlus("Vectors1 (Max)", vectors1.getStack());
            ImagePlus plusV2 = new ImagePlus("Vectors2 (Middle)", vectors2.getStack());
            ImagePlus plusV3 = new ImagePlus("Vectors3 (Min)", vectors3.getStack());
            if (cal != null) {
                plusV1.setCalibration(cal);
                plusV2.setCalibration(cal);
                plusV3.setCalibration(cal);
            }
            plusV1.show();
            plusV2.show();
            plusV3.show();
        }
    }

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 141;
    }
}

