/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.Duplicator;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import java.awt.AWTEvent;
import java.awt.Checkbox;
import java.awt.Font;
import java.awt.TextField;
import java.util.Date;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.processing.FastFilters3D;
import mcib3d.utils.CheckInstall;
import mcib3d.utils.ThreadUtil;
import mcib_plugins.Filter3D.Filter3Dmax;
import mcib_plugins.Filter3D.Filter3DmaxLocal;
import mcib_plugins.Filter3D.Filter3Dmean;
import mcib_plugins.Filter3D.Filter3Dmin;

public class Fast_filters3D
implements PlugInFilter,
DialogListener {
    ImagePlus imp;
    private int nbcpus;
    private final String[] filters = new String[]{"Mean", "Median", "Minimum", "Maximum", "MaximumLocal", "TopHat", "OpenGray", "CloseGray", "Variance", "Sobel", "Adaptive"};
    private final String[] algos = new String[]{"Parallelized", "Isotropic"};
    private int filter;
    private float voisx = 2.0f;
    private float voisy = 2.0f;
    private float voisz = 2.0f;
    private boolean xy = true;
    private Calibration calibration;
    private double uvoisx = 0.0;
    private double uvoisy = 0.0;
    private double uvoisz = 0.0;
    private final boolean debug = false;
    private int algo = 0;

    public void run(ImageProcessor ip) {
        if (!CheckInstall.installComplete()) {
            IJ.log((String)"Not starting Filters 3D");
            return;
        }
        this.calibration = this.imp.getCalibration();
        ImagePlus extract = this.extractCurrentStack(this.imp);
        ImageStack stack = extract.getStack();
        int depth = stack.getBitDepth();
        if (this.Dialogue()) {
            if (Recorder.record) {
                Recorder.setCommand(null);
                Recorder.record((String)"run", (String)("3D Fast Filters\",\"filter=" + this.filters[this.filter] + " radius_x_pix=" + this.voisx + " radius_y_pix=" + this.voisy + " radius_z_pix=" + this.voisz + " Nb_cpus=" + this.nbcpus));
            }
            boolean ff = this.voisx == this.voisy && this.voisx == this.voisz && (this.filter == 0 || this.filter == 2 || this.filter == 3 || this.filter == 4 || this.filter == 5 || this.filter == 6 || this.filter == 7);
            Date t0 = new Date();
            if (ff && this.algo == 1) {
                this.FastFilter(extract, (int)this.voisx, this.filters[this.filter]);
            } else {
                ImageStack res = null;
                if (depth == 8 || depth == 16) {
                    res = FastFilters3D.filterIntImageStack((ImageStack)stack, (int)this.filter, (float)this.voisx, (float)this.voisy, (float)this.voisz, (int)this.nbcpus, (boolean)true);
                } else if (this.imp.getBitDepth() == 32) {
                    res = FastFilters3D.filterFloatImageStack((ImageStack)stack, (int)this.filter, (float)this.voisx, (float)this.voisy, (float)this.voisz, (int)this.nbcpus, (boolean)true);
                } else {
                    IJ.log((String)("Does not work with stack with bitDepth " + depth));
                }
                if (res != null) {
                    ImagePlus plus = new ImagePlus("3D_" + this.filters[this.filter], res);
                    plus.setCalibration(this.calibration);
                    plus.show();
                }
            }
            Date date = new Date();
        }
    }

    private void FastFilter(ImagePlus in_image_j, int radius, String selected_filter) {
        ImageStack instack = in_image_j.getStack();
        Duplicator dup = new Duplicator();
        ImagePlus img = dup.run(in_image_j);
        ImageStack orig = img.getStack();
        ImageShort out3d = new ImageShort("out3d", instack.getWidth(), instack.getHeight(), instack.getSize());
        ImageStack out_image = out3d.getImageStack();
        int rad = radius;
        int de = instack.getSize();
        AtomicInteger ai = new AtomicInteger(0);
        boolean n_cpus = true;
        int dec = (int)Math.ceil((double)de / 1.0);
        switch (selected_filter) {
            case "Mean": {
                Filter3Dmean mean = new Filter3Dmean(instack, out_image, rad);
                mean.filter();
                break;
            }
            case "Minimum": {
                Filter3Dmin min = new Filter3Dmin(instack, out_image, rad);
                min.filter();
                break;
            }
            case "Maximum": {
                Filter3Dmax max = new Filter3Dmax(instack, out_image, rad);
                max.filter();
                break;
            }
            case "MaximumLocal": {
                Filter3DmaxLocal max = new Filter3DmaxLocal(instack, out_image, rad);
                max.filter();
                break;
            }
            case "TopHat": {
                Filter3Dmin min = new Filter3Dmin(instack, out_image, rad);
                min.filter();
                ImageShort out3d2 = new ImageShort("out3d2", instack.getWidth(), instack.getHeight(), instack.getSize());
                ImageStack out_image2 = out3d2.getImageStack();
                Filter3Dmax max = new Filter3Dmax(out_image, out_image2, rad);
                max.filter();
                StackProcessor stackprocess = new StackProcessor(out_image2, null);
                stackprocess.copyBits(orig, 0, 0, 4);
                break;
            }
        }
        ImagePlus out_plus = new ImagePlus(this.filters[this.filter], out_image);
        out_plus.setCalibration(this.calibration);
        out_plus.show();
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        Vector fields = gd.getNumericFields();
        Vector fieldsb = gd.getCheckboxes();
        this.xy = ((Checkbox)fieldsb.elementAt(0)).getState();
        try {
            if (e != null && !gd.invalidNumber()) {
                switch (fields.indexOf(e.getSource())) {
                    case 0: {
                        double v0 = Double.valueOf(((TextField)fields.elementAt(0)).getText());
                        if (v0 == this.uvoisx) break;
                        ((TextField)fields.elementAt(1)).setText(Integer.toString((int)Math.round(v0 / this.calibration.pixelWidth)));
                        this.uvoisx = v0;
                        this.voisx = (int)Math.round(v0 / this.calibration.pixelWidth);
                        if (!this.xy) break;
                        this.uvoisy = this.uvoisx;
                        this.voisy = this.voisx;
                        ((TextField)fields.elementAt(2)).setText(String.valueOf(this.uvoisy));
                        ((TextField)fields.elementAt(3)).setText(Integer.toString(Math.round(this.voisy)));
                        break;
                    }
                    case 1: {
                        int v1 = Integer.valueOf(((TextField)fields.elementAt(1)).getText());
                        if ((float)v1 == this.voisx) break;
                        ((TextField)fields.elementAt(0)).setText(String.valueOf((double)v1 * this.calibration.pixelWidth));
                        this.voisx = v1;
                        this.uvoisx = (double)v1 * this.calibration.pixelWidth;
                        if (!this.xy) break;
                        this.uvoisy = this.uvoisx;
                        this.voisy = this.voisx;
                        ((TextField)fields.elementAt(2)).setText(String.valueOf(this.uvoisy));
                        ((TextField)fields.elementAt(3)).setText(Integer.toString(Math.round(this.voisy)));
                        break;
                    }
                    case 2: {
                        double v3 = Double.valueOf(((TextField)fields.elementAt(2)).getText());
                        if (v3 == this.uvoisy) break;
                        ((TextField)fields.elementAt(3)).setText(Integer.toString((int)Math.round(v3 / this.calibration.pixelHeight)));
                        this.uvoisy = v3;
                        this.voisy = (int)Math.round(v3 / this.calibration.pixelHeight);
                        if (!this.xy) break;
                        this.uvoisx = this.uvoisy;
                        this.voisx = this.voisy;
                        ((TextField)fields.elementAt(0)).setText(String.valueOf(this.uvoisx));
                        ((TextField)fields.elementAt(1)).setText(Integer.toString(Math.round(this.voisx)));
                        break;
                    }
                    case 3: {
                        int v2 = Integer.valueOf(((TextField)fields.elementAt(3)).getText());
                        if ((float)v2 == this.voisy) break;
                        ((TextField)fields.elementAt(2)).setText(String.valueOf((double)v2 * this.calibration.pixelHeight));
                        this.voisy = v2;
                        this.uvoisy = (double)v2 * this.calibration.pixelHeight;
                        if (!this.xy) break;
                        this.uvoisx = this.uvoisy;
                        this.voisx = this.voisy;
                        ((TextField)fields.elementAt(0)).setText(String.valueOf(this.uvoisx));
                        ((TextField)fields.elementAt(1)).setText(Integer.toString(Math.round(this.voisx)));
                        break;
                    }
                    case 4: {
                        double v4 = Double.valueOf(((TextField)fields.elementAt(4)).getText());
                        if (v4 == this.uvoisz) break;
                        ((TextField)fields.elementAt(5)).setText(Integer.toString((int)Math.round(v4 / this.calibration.pixelDepth)));
                        this.uvoisz = v4;
                        this.voisz = (int)Math.round(v4 / this.calibration.pixelDepth);
                        break;
                    }
                    case 5: {
                        int v5 = Integer.valueOf(((TextField)fields.elementAt(5)).getText());
                        if ((float)v5 == this.voisz) break;
                        ((TextField)fields.elementAt(4)).setText(String.valueOf((double)v5 * this.calibration.pixelDepth));
                        this.voisz = v5;
                        this.uvoisz = (double)v5 * this.calibration.pixelDepth;
                        break;
                    }
                }
            }
        }
        catch (NumberFormatException nfe) {
            IJ.log((String)nfe.getMessage());
        }
        return true;
    }

    private boolean Dialogue() {
        String unit = this.calibration.getUnits();
        GenericDialog gd = new GenericDialog("3D_Filter");
        gd.addChoice("Filter", this.filters, this.filters[0]);
        gd.addMessage("Kernel_X", new Font("Arial", 1, 12));
        gd.addNumericField("Radius_X_unit", (double)this.voisx * this.calibration.pixelWidth, 0, 8, unit);
        gd.addNumericField("Radius_X_pix", (double)this.voisx, 0, 8, "pix");
        gd.addMessage("Kernel_Y", new Font("Arial", 1, 12));
        gd.addNumericField("Radius_Y_unit", (double)this.voisy * this.calibration.pixelHeight, 0, 8, unit);
        gd.addNumericField("Radius_Y_pix", (double)this.voisy, 0, 8, "pix");
        gd.addCheckbox("Synchronize X-Y", this.xy);
        gd.addMessage("kernel_Z", new Font("Arial", 1, 12));
        gd.addNumericField("Radius_Z_unit", (double)this.voisz * this.calibration.pixelDepth, 0, 8, unit);
        gd.addNumericField("Radius_Z_pix", (double)this.voisz, 0, 8, "pix");
        gd.addMessage("Parallelization", new Font("Arial", 1, 12));
        gd.addChoice("Algorithm", this.algos, this.algos[this.algo]);
        gd.addSlider("Nb_cpus", 1.0, (double)ThreadUtil.getNbCpus(), (double)ThreadUtil.getNbCpus());
        if (!IJ.macroRunning()) {
            gd.addDialogListener((DialogListener)this);
        }
        gd.showDialog();
        this.filter = gd.getNextChoiceIndex();
        this.uvoisx = gd.getNextNumber();
        this.voisx = (int)gd.getNextNumber();
        this.uvoisy = gd.getNextNumber();
        this.voisy = (int)gd.getNextNumber();
        this.xy = gd.getNextBoolean();
        this.uvoisz = gd.getNextNumber();
        this.voisz = (int)gd.getNextNumber();
        this.algo = gd.getNextChoiceIndex();
        this.nbcpus = (int)gd.getNextNumber();
        return !gd.wasCanceled();
    }

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 13;
    }

    public void setRadiusXYPix(int rad) {
        this.voisx = this.voisy = (float)rad;
    }

    public void setRadiusZPix(int rad) {
        this.voisz = rad;
    }

    public void setFilter(int f) {
        this.filter = f;
    }

    public void setNbCpus(int nb) {
        this.nbcpus = nb > 0 ? nb : ThreadUtil.getNbCpus();
    }

    private ImagePlus extractCurrentStack(ImagePlus plus) {
        ImagePlus stack;
        int[] dims = plus.getDimensions();
        int channel = plus.getChannel();
        int frame = plus.getFrame();
        if (dims[2] > 1 || dims[4] > 1) {
            IJ.log((String)("Hyperstack found, extracting current channel " + channel + " and frame " + frame));
            Duplicator duplicator = new Duplicator();
            stack = duplicator.run(plus, channel, channel, 1, dims[3], frame, frame);
        } else {
            stack = plus.duplicate();
        }
        return stack;
    }
}

