/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins.Filter3D;

import ij.IJ;
import ij.ImageStack;
import ij.process.ImageProcessor;
import mcib_plugins.Filter3D.Kernel3D;

public class Filter3Ddefault {
    protected double initial_value = 0.0;
    private final int radius;
    private Kernel3D filter_kernel;
    private Kernel3D filter_kernel_left;
    private Kernel3D filter_kernel_right;
    private Kernel3D filter_kernel_top;
    private Kernel3D filter_kernel_bottom;
    private Kernel3D filter_kernel_front;
    private Kernel3D filter_kernel_back;
    private final int[] image_size = new int[]{100, 100, 100};
    private final ImageStack in_image;
    private final ImageStack out_image;

    public Filter3Ddefault(ImageStack in, ImageStack out, int r) {
        this.radius = r;
        this.out_image = out;
        this.in_image = in;
        this.image_size[0] = this.in_image.getWidth();
        this.image_size[1] = this.in_image.getHeight();
        this.image_size[2] = this.in_image.getSize();
    }

    public void filter() {
        this.filter_kernel = new Kernel3D(this.radius);
        this.filter_kernel.setSpherical();
        this.filter_kernel_left = new Kernel3D(this.radius);
        this.filter_kernel_left.setDifferenceKernel(0);
        this.filter_kernel_right = new Kernel3D(this.radius);
        this.filter_kernel_right.setDifferenceKernel(1);
        this.filter_kernel_top = new Kernel3D(this.radius);
        this.filter_kernel_top.setDifferenceKernel(2);
        this.filter_kernel_bottom = new Kernel3D(this.radius);
        this.filter_kernel_bottom.setDifferenceKernel(3);
        this.filter_kernel_front = new Kernel3D(this.radius);
        this.filter_kernel_front.setDifferenceKernel(4);
        this.filter_kernel_back = new Kernel3D(this.radius);
        this.filter_kernel_back.setDifferenceKernel(5);
        Voxel_value first = this.iterate_and_read(new int[]{0, 0, 0});
        this.out_image.setVoxel(0, 0, 0, this.post_process_voxel(first.value, first.voxel_count));
        Voxel_value the_voxel = new Voxel_value(this.initial_value, 0);
        Voxel_value previous_voxel = first;
        boolean do_first = true;
        for (int k = 0; k < this.image_size[2]; ++k) {
            double val;
            int i;
            int j;
            IJ.log((String)("processing z " + k));
            boolean move_slice_back = true;
            ImageProcessor ima_out = this.out_image.getProcessor(k + 1);
            if (k % 2 == 0) {
                for (j = 0; j < this.image_size[1]; ++j) {
                    boolean move_row_down = true;
                    if (j % 2 == 0) {
                        for (i = 0; i < this.image_size[0]; ++i) {
                            if (move_slice_back) {
                                if (do_first) {
                                    the_voxel = previous_voxel;
                                    do_first = false;
                                } else {
                                    the_voxel = this.process_next_voxel(i, j, k, previous_voxel, (byte)4);
                                }
                                move_slice_back = false;
                                move_row_down = false;
                            } else if (move_row_down) {
                                the_voxel = this.process_next_voxel(i, j, k, previous_voxel, (byte)2);
                                move_row_down = false;
                            } else {
                                the_voxel = this.process_next_voxel(i, j, k, previous_voxel, (byte)0);
                            }
                            val = this.post_process_voxel(the_voxel.value, the_voxel.voxel_count);
                            ima_out.putPixelValue(i, j, val);
                            previous_voxel = the_voxel;
                        }
                        continue;
                    }
                    for (i = this.image_size[0] - 1; i >= 0; --i) {
                        if (move_slice_back) {
                            the_voxel = this.process_next_voxel(i, j, k, previous_voxel, (byte)4);
                            move_slice_back = false;
                            move_row_down = false;
                        } else if (move_row_down) {
                            the_voxel = this.process_next_voxel(i, j, k, previous_voxel, (byte)2);
                            move_row_down = false;
                        } else {
                            the_voxel = this.process_next_voxel(i, j, k, previous_voxel, (byte)1);
                        }
                        val = this.post_process_voxel(the_voxel.value, the_voxel.voxel_count);
                        ima_out.putPixelValue(i, j, val);
                        previous_voxel = the_voxel;
                    }
                }
            } else {
                for (j = this.image_size[1] - 1; j >= 0; --j) {
                    boolean move_row_up = true;
                    if (j % 2 == 1) {
                        for (i = 0; i < this.image_size[0]; ++i) {
                            if (move_slice_back) {
                                the_voxel = this.process_next_voxel(i, j, k, previous_voxel, (byte)4);
                                move_slice_back = false;
                                move_row_up = false;
                            } else if (move_row_up) {
                                the_voxel = this.process_next_voxel(i, j, k, previous_voxel, (byte)3);
                                move_row_up = false;
                            } else {
                                the_voxel = this.process_next_voxel(i, j, k, previous_voxel, (byte)0);
                            }
                            val = this.post_process_voxel(the_voxel.value, the_voxel.voxel_count);
                            ima_out.putPixelValue(i, j, val);
                            previous_voxel = the_voxel;
                        }
                        continue;
                    }
                    for (i = this.image_size[0] - 1; i >= 0; --i) {
                        if (move_slice_back) {
                            the_voxel = this.process_next_voxel(i, j, k, previous_voxel, (byte)4);
                            move_slice_back = false;
                            move_row_up = false;
                        } else if (move_row_up) {
                            the_voxel = this.process_next_voxel(i, j, k, previous_voxel, (byte)3);
                            move_row_up = false;
                        } else {
                            the_voxel = this.process_next_voxel(i, j, k, previous_voxel, (byte)1);
                        }
                        val = this.post_process_voxel(the_voxel.value, the_voxel.voxel_count);
                        ima_out.putPixelValue(i, j, val);
                        previous_voxel = the_voxel;
                    }
                }
            }
            IJ.showStatus((String)("Processed " + k + "/" + this.image_size[2]));
        }
        IJ.showStatus((String)"Done");
    }

    private int clamp_min(int in) {
        if (in < 0) {
            return 0;
        }
        return in;
    }

    private int clamp_max(int in, int i) {
        if (this.image_size[i] < in) {
            return this.image_size[i];
        }
        return in;
    }

    private Voxel_value calculate_border_lr(int x, int y, int z, Kernel3D kernel, boolean debug) {
        Voxel_value out = new Voxel_value(this.initial_value, 0);
        int start_local_y = this.clamp_min(y - this.radius);
        int end_local_y = this.clamp_max(y + this.radius + 1, 1);
        for (int j = start_local_y; j < end_local_y; ++j) {
            int start_local_x = this.clamp_min(z - kernel.filter_mask_array[j - y + this.radius]);
            int end_local_x = this.clamp_max(z + kernel.filter_mask_array[j - y + this.radius] + 1, 2);
            for (int k = start_local_x; k < end_local_x; ++k) {
                int depth = kernel.difference_kernel_offset_matrix[k - z + this.radius][j - y + this.radius];
                if (x + this.radius < this.image_size[0]) {
                    out.value = this.process_voxel(out.value, this.in_image.getVoxel(x + depth, j, k));
                    ++out.voxel_count;
                    if (!debug || y != 6 || z != 0 || x != 10) continue;
                    this.out_image.setVoxel(x + depth, j, k, 0.0);
                    continue;
                }
                if (x + depth >= this.image_size[0]) continue;
                out.value = this.process_voxel(out.value, this.in_image.getVoxel(x + depth, j, k));
                ++out.voxel_count;
                if (!debug || y != 6 || z != 0 || x != 10) continue;
                this.out_image.setVoxel(x + depth, j, k, 0.0);
            }
        }
        return out;
    }

    private Voxel_value calculate_border_rl(int x, int y, int z, Kernel3D kernel, boolean debug) {
        Voxel_value out = new Voxel_value(this.initial_value, 0);
        int start_local_y = this.clamp_min(y - this.radius);
        int end_local_y = this.clamp_max(y + this.radius + 1, 1);
        for (int j = start_local_y; j < end_local_y; ++j) {
            int start_local_x = this.clamp_min(z - kernel.filter_mask_array[j - y + this.radius]);
            int end_local_x = this.clamp_max(z + kernel.filter_mask_array[j - y + this.radius] + 1, 2);
            for (int k = start_local_x; k < end_local_x; ++k) {
                int depth = kernel.difference_kernel_offset_matrix[k - z + this.radius][j - y + this.radius];
                if (x - this.radius >= 0) {
                    out.value = this.process_voxel(out.value, this.in_image.getVoxel(x + depth, j, k));
                    ++out.voxel_count;
                    if (!debug || y != 6 || z != 0 || x != 10) continue;
                    this.out_image.setVoxel(x + depth, j, k, 0.0);
                    continue;
                }
                if (x + depth < 0) continue;
                out.value = this.process_voxel(out.value, this.in_image.getVoxel(x + depth, j, k));
                ++out.voxel_count;
                if (!debug || y != 6 || z != 0 || x != 10) continue;
                this.out_image.setVoxel(x + depth, j, k, 0.0);
            }
        }
        return out;
    }

    private Voxel_value calculate_border_tb(int x, int y, int z, Kernel3D kernel, boolean debug) {
        Voxel_value out = new Voxel_value(this.initial_value, 0);
        int start_local_y = this.clamp_min(x - this.radius);
        int end_local_y = this.clamp_max(x + this.radius + 1, 0);
        for (int i = start_local_y; i < end_local_y; ++i) {
            int start_local_x = this.clamp_min(z - kernel.filter_mask_array[i - x + this.radius]);
            int end_local_x = this.clamp_max(z + kernel.filter_mask_array[i - x + this.radius] + 1, 2);
            for (int k = start_local_x; k < end_local_x; ++k) {
                int depth = kernel.difference_kernel_offset_matrix[k - z + this.radius][i - x + this.radius];
                if (y + this.radius < this.image_size[1]) {
                    out.value = this.process_voxel(out.value, this.in_image.getVoxel(i, y + depth, k));
                    ++out.voxel_count;
                    if (!debug || y != 1 || z != 0) continue;
                    System.out.println(out.value);
                    continue;
                }
                if (y + depth >= this.image_size[1]) continue;
                out.value = this.process_voxel(out.value, this.in_image.getVoxel(i, y + depth, k));
                ++out.voxel_count;
                if (!debug || y != 1 || z != 0) continue;
                System.out.println(out.value);
            }
        }
        return out;
    }

    private Voxel_value calculate_border_bt(int x, int y, int z, Kernel3D kernel, boolean debug) {
        Voxel_value out = new Voxel_value(this.initial_value, 0);
        int start_local_y = this.clamp_min(x - this.radius);
        int end_local_y = this.clamp_max(x + this.radius + 1, 0);
        for (int i = start_local_y; i < end_local_y; ++i) {
            int start_local_x = this.clamp_min(z - kernel.filter_mask_array[i - x + this.radius]);
            int end_local_x = this.clamp_max(z + kernel.filter_mask_array[i - x + this.radius] + 1, 2);
            for (int k = start_local_x; k < end_local_x; ++k) {
                int depth = kernel.difference_kernel_offset_matrix[k - z + this.radius][i - x + this.radius];
                if (y - this.radius >= 0) {
                    out.value = this.process_voxel(out.value, this.in_image.getVoxel(i, y + depth, k));
                    ++out.voxel_count;
                    if (!debug || y != 5 || z != 0) continue;
                    this.out_image.setVoxel(i, y + depth, k, 0.0);
                    continue;
                }
                if (y + depth < 0) continue;
                out.value = this.process_voxel(out.value, this.in_image.getVoxel(i, y + depth, k));
                ++out.voxel_count;
                if (!debug || y != 5 || z != 0) continue;
                this.out_image.setVoxel(i, y + depth, k, 0.0);
            }
        }
        return out;
    }

    private Voxel_value calculate_border_fb(int x, int y, int z, Kernel3D kernel, boolean debug) {
        Voxel_value out = new Voxel_value(this.initial_value, 0);
        int start_local_y = this.clamp_min(y - this.radius);
        int end_local_y = this.clamp_max(y + this.radius + 1, 1);
        for (int j = start_local_y; j < end_local_y; ++j) {
            int start_local_x = this.clamp_min(x - kernel.filter_mask_array[j - y + this.radius]);
            int end_local_x = this.clamp_max(x + kernel.filter_mask_array[j - y + this.radius] + 1, 0);
            for (int i = start_local_x; i < end_local_x; ++i) {
                int depth = kernel.difference_kernel_offset_matrix[i - x + this.radius][j - y + this.radius];
                if (z + this.radius < this.image_size[2]) {
                    out.value = this.process_voxel(out.value, this.in_image.getVoxel(i, j, z + depth));
                    ++out.voxel_count;
                    if (!debug || z != 1) continue;
                    this.out_image.setVoxel(i, j, z + depth, 0.0);
                    continue;
                }
                if (z + depth >= this.image_size[2]) continue;
                out.value = this.process_voxel(out.value, this.in_image.getVoxel(i, j, z + depth));
                ++out.voxel_count;
                if (!debug || z != 1) continue;
                this.out_image.setVoxel(i, j, z + depth, 0.0);
            }
        }
        return out;
    }

    private Voxel_value calculate_border_bf(int x, int y, int z, Kernel3D kernel, boolean debug) {
        Voxel_value out = new Voxel_value(this.initial_value, 0);
        int start_local_y = this.clamp_min(y - this.radius);
        int end_local_y = this.clamp_max(y + this.radius + 1, 1);
        for (int j = start_local_y; j < end_local_y; ++j) {
            int start_local_x = this.clamp_min(x - kernel.filter_mask_array[j - y + this.radius]);
            int end_local_x = this.clamp_max(x + kernel.filter_mask_array[j - y + this.radius] + 1, 0);
            for (int i = start_local_x; i < end_local_x; ++i) {
                int depth = kernel.difference_kernel_offset_matrix[i - x + this.radius][j - y + this.radius];
                if (z - this.radius >= 0) {
                    out.value = this.process_voxel(out.value, this.in_image.getVoxel(i, j, z + depth));
                    ++out.voxel_count;
                    if (!debug || z != 1) continue;
                    this.out_image.setVoxel(i, j, z + depth, 0.0);
                    continue;
                }
                if (z + depth < 0) continue;
                out.value = this.process_voxel(out.value, this.in_image.getVoxel(i, j, z + depth));
                ++out.voxel_count;
                if (!debug || z != 1) continue;
                this.out_image.setVoxel(i, j, z + depth, 0.0);
            }
        }
        return out;
    }

    protected Voxel_value iterate_and_read(int[] in) {
        int[] start_values = new int[3];
        int[] end_values = new int[3];
        for (int i = 0; i < 3; ++i) {
            start_values[i] = this.clamp_min(in[i] - this.radius);
            end_values[i] = this.clamp_max(in[i] + this.radius + 1, i);
        }
        double voxel = this.initial_value;
        int num_voxel = 0;
        for (int k = start_values[2]; k < end_values[2]; ++k) {
            for (int j = start_values[1]; j < end_values[1]; ++j) {
                for (int i = start_values[0]; i < end_values[0]; ++i) {
                    if (!this.filter_kernel.getValueAt(i - in[0], j - in[1], k - in[2])) continue;
                    voxel = this.process_voxel(voxel, this.in_image.getVoxel(i, j, k));
                    ++num_voxel;
                }
            }
        }
        return new Voxel_value(voxel, num_voxel);
    }

    protected Voxel_value iterate_and_add(int x, int y, int z, byte type) {
        Voxel_value out = new Voxel_value(this.initial_value, 0);
        switch (type) {
            case 0: {
                out = this.calculate_border_lr(x, y, z, this.filter_kernel_right, false);
                break;
            }
            case 1: {
                out = this.calculate_border_rl(x, y, z, this.filter_kernel_left, false);
                break;
            }
            case 2: {
                out = this.calculate_border_tb(x, y, z, this.filter_kernel_bottom, false);
                break;
            }
            case 3: {
                out = this.calculate_border_bt(x, y, z, this.filter_kernel_top, false);
                break;
            }
            case 4: {
                out = this.calculate_border_fb(x, y, z, this.filter_kernel_back, false);
            }
        }
        return out;
    }

    protected Voxel_value iterate_and_subtract(int x, int y, int z, byte type) {
        Voxel_value out = new Voxel_value(this.initial_value, 0);
        switch (type) {
            case 0: {
                out = this.calculate_border_rl(x - 1, y, z, this.filter_kernel_left, false);
                break;
            }
            case 1: {
                out = this.calculate_border_lr(x + 1, y, z, this.filter_kernel_right, false);
                break;
            }
            case 2: {
                out = this.calculate_border_bt(x, y - 1, z, this.filter_kernel_top, false);
                break;
            }
            case 3: {
                out = this.calculate_border_tb(x, y + 1, z, this.filter_kernel_bottom, false);
                break;
            }
            case 4: {
                out = this.calculate_border_bf(x, y, z - 1, this.filter_kernel_front, false);
            }
        }
        return out;
    }

    protected Voxel_value process_next_voxel(int x, int y, int z, Voxel_value prev_voxel, byte type) {
        Voxel_value out = new Voxel_value(prev_voxel.value, prev_voxel.voxel_count);
        Voxel_value to_add = this.iterate_and_add(x, y, z, type);
        Voxel_value to_subtract = this.iterate_and_subtract(x, y, z, type);
        out.value = out.value - to_subtract.value + to_add.value;
        out.voxel_count = out.voxel_count - to_subtract.voxel_count + to_add.voxel_count;
        return out;
    }

    protected double process_voxel(double temp_value, double operand) {
        return temp_value + operand;
    }

    protected double post_process_voxel(double temp_value, double operand) {
        if (operand != 0.0) {
            return temp_value / operand;
        }
        return 0.0;
    }

    protected double getVoxel(int i, int j, int k) {
        return this.in_image.getVoxel(i, j, k);
    }

    protected class Voxel_value {
        public double value;
        public int voxel_count;

        Voxel_value(double v, int v_c) {
            this.value = v;
            this.voxel_count = v_c;
        }
    }
}

