/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins.Filter3D;

import java.util.Arrays;

public class Kernel3D {
    public static final byte LEFT = 0;
    public static final byte RIGHT = 1;
    public static final byte TOP = 2;
    public static final byte BOTTOM = 3;
    public static final byte FRONT = 4;
    public static final byte BACK = 5;
    public int filter_size;
    public int[][] difference_kernel_offset_matrix;
    public int[] filter_mask_array;
    private int[][][] kernel;
    private final int radius;

    public Kernel3D(int radius) {
        this.radius = radius;
        this.filter_size = 2 * radius + 1;
        this.fill(0);
        this.fillMatrix(radius + 1);
    }

    public boolean getValueAt(int filter_x, int filter_y, int filter_z) {
        return this.kernel[filter_x + this.radius][filter_y + this.radius][filter_z + this.radius] == 1;
    }

    public void fill(int value) {
        this.kernel = new int[this.filter_size][this.filter_size][this.filter_size];
        for (int k = 0; k < this.filter_size; ++k) {
            for (int j = 0; j < this.filter_size; ++j) {
                for (int i = 0; i < this.filter_size; ++i) {
                    this.kernel[i][j][k] = value;
                }
            }
        }
    }

    public void fillMatrix(int value) {
        this.difference_kernel_offset_matrix = new int[this.filter_size][this.filter_size];
        for (int j = 0; j < this.filter_size; ++j) {
            for (int i = 0; i < this.filter_size; ++i) {
                this.difference_kernel_offset_matrix[i][j] = value;
            }
        }
    }

    public void setSpherical() {
        for (int k = 0; k < this.filter_size; ++k) {
            for (int j = 0; j < this.filter_size; ++j) {
                for (int i = 0; i < this.filter_size; ++i) {
                    if (!(Math.pow((double)i + 0.5 - ((double)this.radius + 0.5), 2.0) + Math.pow((double)j + 0.5 - ((double)this.radius + 0.5), 2.0) + Math.pow((double)k + 0.5 - ((double)this.radius + 0.5), 2.0) <= Math.pow(this.radius, 2.0))) continue;
                    this.kernel[i][j][k] = 1;
                }
            }
        }
    }

    public void setDifferenceKernel(int direction) {
        int j;
        int i;
        Kernel3D temp_sphere = new Kernel3D(this.radius);
        temp_sphere.setSpherical();
        switch (direction) {
            case 0: {
                int i2;
                int j2;
                int k;
                for (k = 0; k < this.filter_size; ++k) {
                    block9: for (j2 = 0; j2 < this.filter_size; ++j2) {
                        for (i2 = 0; i2 < this.filter_size; ++i2) {
                            if (temp_sphere.kernel[i2][j2][k] != 1) continue;
                            this.kernel[i2][j2][k] = 1;
                            this.difference_kernel_offset_matrix[j2][k] = i2 - this.radius;
                            continue block9;
                        }
                    }
                }
                break;
            }
            case 1: {
                int i2;
                int j2;
                int k;
                for (k = 0; k < this.filter_size; ++k) {
                    block12: for (j2 = 0; j2 < this.filter_size; ++j2) {
                        for (i2 = this.filter_size - 1; i2 >= 0; --i2) {
                            if (temp_sphere.kernel[i2][j2][k] != 1) continue;
                            this.kernel[i2][j2][k] = 1;
                            this.difference_kernel_offset_matrix[j2][k] = i2 - this.radius;
                            continue block12;
                        }
                    }
                }
                break;
            }
            case 2: {
                int j3;
                int k;
                for (k = 0; k < this.filter_size; ++k) {
                    block15: for (i = 0; i < this.filter_size; ++i) {
                        for (j3 = 0; j3 < this.filter_size; ++j3) {
                            if (temp_sphere.kernel[i][j3][k] != 1) continue;
                            this.kernel[i][j3][k] = 1;
                            this.difference_kernel_offset_matrix[i][k] = j3 - this.radius;
                            continue block15;
                        }
                    }
                }
                break;
            }
            case 3: {
                int j3;
                int k;
                for (k = 0; k < this.filter_size; ++k) {
                    block18: for (i = 0; i < this.filter_size; ++i) {
                        for (j3 = this.filter_size - 1; j3 >= 0; --j3) {
                            if (temp_sphere.kernel[i][j3][k] != 1) continue;
                            this.kernel[i][j3][k] = 1;
                            this.difference_kernel_offset_matrix[i][k] = j3 - this.radius;
                            continue block18;
                        }
                    }
                }
                break;
            }
            case 4: {
                int k;
                for (j = 0; j < this.filter_size; ++j) {
                    block21: for (i = 0; i < this.filter_size; ++i) {
                        for (k = 0; k < this.filter_size; ++k) {
                            if (temp_sphere.kernel[i][j][k] != 1) continue;
                            this.kernel[i][j][k] = 1;
                            this.difference_kernel_offset_matrix[i][j] = k - this.radius;
                            continue block21;
                        }
                    }
                }
                break;
            }
            case 5: {
                int k;
                for (j = 0; j < this.filter_size; ++j) {
                    block24: for (i = 0; i < this.filter_size; ++i) {
                        for (k = this.filter_size - 1; k >= 0; --k) {
                            if (temp_sphere.kernel[i][j][k] != 1) continue;
                            this.kernel[i][j][k] = 1;
                            this.difference_kernel_offset_matrix[i][j] = k - this.radius;
                            continue block24;
                        }
                    }
                }
                break;
            }
        }
        this.filter_mask_array = new int[this.filter_size];
        Arrays.fill(this.filter_mask_array, -1);
        block26: for (j = 0; j < this.filter_size; ++j) {
            for (i = 0; i < this.filter_size; ++i) {
                if (this.difference_kernel_offset_matrix[i][j] == this.radius + 1) continue;
                this.filter_mask_array[j] = this.radius - i;
                continue block26;
            }
        }
    }

    public void debug_show_kernel(int depth) {
        System.out.println("Kernel at row " + (depth %= this.filter_size));
        for (int j = 0; j < this.filter_size; ++j) {
            for (int i = 0; i < this.filter_size; ++i) {
                System.out.print(this.kernel[i][j][depth] + " ");
            }
            System.out.println();
        }
    }

    public void debug_show_offset_matrix() {
        System.out.println("Offset matrix:");
        for (int j = 0; j < this.filter_size; ++j) {
            for (int i = 0; i < this.filter_size; ++i) {
                System.out.print(this.difference_kernel_offset_matrix[i][j] + " ");
            }
            System.out.println();
        }
    }

    public void debug_show_filter_mask_array() {
        System.out.println("Filter mask array:");
        for (int i = 0; i < this.filter_size; ++i) {
            System.out.print(this.filter_mask_array[i] + " ");
        }
        System.out.println();
    }
}

