/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import mcib3d.geom2.Objects3DIntPopulation;
import mcib3d.geom2.measurements.MeasureObject;
import mcib3d.image3d.ImageHandler;

public class FilterObjects_
implements PlugInFilter {
    private ImagePlus imp;
    private double minValue = Prefs.get((String)"FilterObjects_minValue.double", (double)0.0);
    private double maxValue = Prefs.get((String)"FilterObjects_maxValue.double", (double)1000.0);
    private boolean keep = false;
    private String measure = "Volume(pix)";

    public int setup(String s, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 13;
    }

    public void run(ImageProcessor imageProcessor) {
        if (this.dialog()) {
            Prefs.set((String)"FilterObjects_minValue.double", (double)this.minValue);
            Prefs.set((String)"FilterObjects_maxValue.double", (double)this.maxValue);
            ImageHandler imageHandler = ImageHandler.wrap((ImagePlus)this.imp);
            Objects3DIntPopulation population = new Objects3DIntPopulation(imageHandler);
            Objects3DIntPopulation population1 = new Objects3DIntPopulation();
            population.getObjects3DInt().forEach(obj -> {
                double value = new MeasureObject(obj).measure(this.measure);
                if (this.keep) {
                    if (value >= this.minValue && value <= this.maxValue) {
                        population1.addObject(obj);
                    }
                } else if (value < this.minValue || value > this.maxValue) {
                    population1.addObject(obj);
                }
            });
            ImageHandler filtered = imageHandler.createSameDimensions();
            population1.drawInImage(filtered);
            filtered.show(imageHandler.getTitle() + "_filtered");
        }
    }

    private boolean dialog() {
        String[] measures = (String[])new MeasureObject().listMeasures().stream().sorted(String::compareTo).toArray(String[]::new);
        GenericDialog dia = new GenericDialog("Filter Objects");
        dia.addChoice("Descriptor", measures, this.measure);
        dia.addNumericField("Min value", this.minValue);
        dia.addNumericField("Max value", this.maxValue);
        dia.addCheckbox("Keep ? (else discard)", this.keep);
        dia.showDialog();
        this.measure = dia.getNextChoice();
        this.minValue = dia.getNextNumber();
        this.maxValue = dia.getNextNumber();
        this.keep = dia.getNextBoolean();
        return dia.wasOKed();
    }
}

