/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ij.process.StackProcessor;
import java.awt.AWTEvent;
import java.awt.Checkbox;
import java.awt.Font;
import java.awt.TextField;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import mcib_plugins.Fast_filters3D;

public class Filters3d_jni
implements PlugInFilter,
DialogListener {
    static int count = 0;
    static boolean jni_available = false;
    ImagePlus imp;
    String[] filters = new String[]{"Mean", "Median", "Minimum", "Maximum", "MaximumLocal", "TopHat", "Variance"};
    int filter;
    int voisx = 2;
    int voisy = 2;
    int voisz = 2;
    boolean xy = true;
    Calibration calibration;
    double uvoisx = 0.0;
    double uvoisy = 0.0;
    double uvoisz = 0.0;

    private native byte[][] jniMean3D(byte[][] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private native byte[][] jniTopHat3D(byte[][] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private native short[][] jniTopHat3D_16(short[][] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private native short[][] jniMean3D_16(short[][] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private native byte[][] jniMedian3D(byte[][] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private native short[][] jniMedian3D_16(short[][] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private native byte[][] jniMinimum3D(byte[][] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private native short[][] jniMinimum3D_16(short[][] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private native byte[][] jniMaximum3D(byte[][] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private native byte[][] jniMaximumLocal3D(byte[][] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private native short[][] jniMaximum3D_16(short[][] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private native short[][] jniMaximumLocal3D_16(short[][] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public void run(ImageProcessor ip) {
        this.calibration = this.imp.getCalibration();
        if (this.Dialogue()) {
            if (Recorder.record) {
                Recorder.setCommand(null);
                Recorder.record((String)"run", (String)("3D JNI Filters\",\"filter=" + this.filters[this.filter] + " radius_x_pix=" + this.voisx + " radius_y_pix=" + this.voisy + " radius_z_pix=" + this.voisz));
                IJ.log((String)("Performing 3D filter " + this.filters[this.filter] + " " + this.voisx + "x" + this.voisy + "x" + this.voisz));
            }
            Date t0 = new Date();
            ImageStack stack = this.imp.getStack();
            int s = stack.getSize();
            int w = stack.getWidth();
            int h = stack.getHeight();
            if (jni_available) {
                ImageStack resstack;
                Object tabstack;
                IJ.log((String)"Using JNI");
                if (stack.getProcessor(1) instanceof ByteProcessor) {
                    tabstack = new byte[s][w * h];
                    for (int i = 1; i <= s; ++i) {
                        System.arraycopy(stack.getPixels(i), 0, tabstack[i - 1], 0, w * h);
                    }
                    byte[][] res = null;
                    if (this.filter == 0) {
                        res = this.jniMean3D((byte[][])tabstack, w, h, s, this.voisx, this.voisy, this.voisz);
                    } else if (this.filter == 1) {
                        res = this.jniMedian3D((byte[][])tabstack, w, h, s, this.voisx, this.voisy, this.voisz);
                    } else if (this.filter == 2) {
                        res = this.jniMinimum3D((byte[][])tabstack, w, h, s, this.voisx, this.voisy, this.voisz);
                    } else if (this.filter == 3) {
                        res = this.jniMaximum3D((byte[][])tabstack, w, h, s, this.voisx, this.voisy, this.voisz);
                    } else if (this.filter == 4) {
                        res = this.jniMaximumLocal3D((byte[][])tabstack, w, h, s, this.voisx, this.voisy, this.voisz);
                    } else if (this.filter == 5) {
                        res = this.jniTopHat3D((byte[][])tabstack, w, h, s, this.voisx, this.voisy, this.voisz);
                    }
                    resstack = new ImageStack(w, h);
                    for (int i = 0; i < s; ++i) {
                        resstack.addSlice("", (Object)res[i]);
                    }
                    if (this.filter == 5) {
                        StackProcessor stackprocess = new StackProcessor(stack, null);
                        stackprocess.copyBits(resstack, 0, 0, 4);
                        this.imp.updateAndDraw();
                    } else {
                        ImagePlus plus = new ImagePlus("3D_" + this.filters[this.filter], resstack);
                        plus.setCalibration(this.calibration);
                        plus.show();
                    }
                    tabstack = null;
                    System.gc();
                }
                if (stack.getProcessor(1) instanceof ShortProcessor) {
                    tabstack = new short[s][w * h];
                    for (int i = 1; i <= s; ++i) {
                        System.arraycopy(stack.getPixels(i), 0, tabstack[i - 1], 0, w * h);
                    }
                    short[][] res = null;
                    if (this.filter == 0) {
                        res = this.jniMean3D_16((short[][])tabstack, w, h, s, this.voisx, this.voisy, this.voisz);
                    } else if (this.filter == 1) {
                        res = this.jniMedian3D_16((short[][])tabstack, w, h, s, this.voisx, this.voisy, this.voisz);
                    } else if (this.filter == 2) {
                        res = this.jniMinimum3D_16((short[][])tabstack, w, h, s, this.voisx, this.voisy, this.voisz);
                    } else if (this.filter == 3) {
                        res = this.jniMaximum3D_16((short[][])tabstack, w, h, s, this.voisx, this.voisy, this.voisz);
                    } else if (this.filter == 4) {
                        res = this.jniMaximumLocal3D_16((short[][])tabstack, w, h, s, this.voisx, this.voisy, this.voisz);
                    } else if (this.filter == 5) {
                        res = this.jniTopHat3D_16((short[][])tabstack, w, h, s, this.voisx, this.voisy, this.voisz);
                    }
                    resstack = new ImageStack(w, h);
                    for (int i = 0; i < s; ++i) {
                        resstack.addSlice("", (Object)res[i]);
                    }
                    if (this.filter == 5) {
                        StackProcessor stackprocess = new StackProcessor(stack, null);
                        stackprocess.copyBits(resstack, 0, 0, 4);
                        this.imp.updateAndDraw();
                    } else {
                        ImagePlus plus = new ImagePlus("3D_" + this.filters[this.filter], resstack);
                        plus.setCalibration(this.calibration);
                        plus.show();
                    }
                    tabstack = null;
                    res = null;
                    System.gc();
                }
            }
            Date t1 = new Date();
            IJ.log((String)("time : " + (t1.getTime() - t0.getTime()) + " ms"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        Vector fields = gd.getNumericFields();
        Vector fieldsb = gd.getCheckboxes();
        this.xy = ((Checkbox)fieldsb.elementAt(0)).getState();
        NumberFormat nf = NumberFormat.getInstance(Locale.ENGLISH);
        nf.setMaximumFractionDigits(3);
        try {
            if (e != null && !gd.invalidNumber()) {
                switch (fields.indexOf(e.getSource())) {
                    case 0: {
                        double v0 = Double.valueOf(((TextField)fields.elementAt(0)).getText());
                        if (v0 == this.uvoisx) break;
                        ((TextField)fields.elementAt(1)).setText(Integer.toString((int)Math.round(v0 / this.calibration.pixelWidth)));
                        this.uvoisx = v0;
                        this.voisx = (int)Math.round(v0 / this.calibration.pixelWidth);
                        if (!this.xy) break;
                        this.uvoisy = this.uvoisx;
                        this.voisy = this.voisx;
                        ((TextField)fields.elementAt(2)).setText(nf.format(this.uvoisy));
                        ((TextField)fields.elementAt(3)).setText(Integer.toString(Math.round(this.voisy)));
                        break;
                    }
                    case 1: {
                        int v1 = Integer.valueOf(((TextField)fields.elementAt(1)).getText());
                        if (v1 == this.voisx) break;
                        ((TextField)fields.elementAt(0)).setText(nf.format((double)v1 * this.calibration.pixelWidth));
                        this.voisx = v1;
                        this.uvoisx = (double)v1 * this.calibration.pixelWidth;
                        if (!this.xy) break;
                        this.uvoisy = this.uvoisx;
                        this.voisy = this.voisx;
                        ((TextField)fields.elementAt(2)).setText(nf.format(this.uvoisy));
                        ((TextField)fields.elementAt(3)).setText(Integer.toString(Math.round(this.voisy)));
                        break;
                    }
                    case 2: {
                        double v3 = Double.valueOf(((TextField)fields.elementAt(2)).getText());
                        if (v3 == this.uvoisy) break;
                        ((TextField)fields.elementAt(3)).setText(Integer.toString((int)Math.round(v3 / this.calibration.pixelHeight)));
                        this.uvoisy = v3;
                        this.voisy = (int)Math.round(v3 / this.calibration.pixelHeight);
                        if (!this.xy) break;
                        this.uvoisx = this.uvoisy;
                        this.voisx = this.voisy;
                        ((TextField)fields.elementAt(0)).setText(nf.format(this.uvoisx));
                        ((TextField)fields.elementAt(1)).setText(Integer.toString(Math.round(this.voisx)));
                        break;
                    }
                    case 3: {
                        int v2 = Integer.valueOf(((TextField)fields.elementAt(3)).getText());
                        if (v2 == this.voisy) break;
                        ((TextField)fields.elementAt(2)).setText(nf.format((double)v2 * this.calibration.pixelHeight));
                        this.voisy = v2;
                        this.uvoisy = (double)v2 * this.calibration.pixelHeight;
                        if (!this.xy) break;
                        this.uvoisx = this.uvoisy;
                        this.voisx = this.voisy;
                        ((TextField)fields.elementAt(0)).setText(nf.format(this.uvoisx));
                        ((TextField)fields.elementAt(1)).setText(Integer.toString(Math.round(this.voisx)));
                        break;
                    }
                    case 4: {
                        double v4 = Double.valueOf(((TextField)fields.elementAt(4)).getText());
                        if (v4 == this.uvoisz) break;
                        ((TextField)fields.elementAt(5)).setText(Integer.toString((int)Math.round(v4 / this.calibration.pixelDepth)));
                        this.uvoisz = v4;
                        this.voisz = (int)Math.round(v4 / this.calibration.pixelDepth);
                        break;
                    }
                    case 5: {
                        int v5 = Integer.valueOf(((TextField)fields.elementAt(5)).getText());
                        if (v5 == this.voisz) break;
                        ((TextField)fields.elementAt(4)).setText(nf.format((double)v5 * this.calibration.pixelDepth));
                        this.voisz = v5;
                        this.uvoisz = (double)v5 * this.calibration.pixelDepth;
                        break;
                    }
                }
            }
            if (gd.invalidNumber()) return true;
        }
        catch (NumberFormatException nfe) {
            IJ.log((String)nfe.getMessage());
        }
        return true;
    }

    private boolean Dialogue() {
        String unit = this.calibration.getUnits();
        GenericDialog gd = new GenericDialog("3D_Filter");
        gd.addChoice("Filter", this.filters, this.filters[0]);
        gd.addMessage("Kernel_X", new Font("Arial", 1, 12));
        gd.addNumericField("Radius_X_unit", (double)this.voisx * this.calibration.pixelWidth, 0, 8, unit);
        gd.addNumericField("Radius_X_pix", (double)this.voisx, 0, 8, "pix");
        gd.addMessage("Kernel_Y", new Font("Arial", 1, 12));
        gd.addNumericField("Radius_Y_unit", (double)this.voisy * this.calibration.pixelHeight, 0, 8, unit);
        gd.addNumericField("Radius_Y_pix", (double)this.voisy, 0, 8, "pix");
        gd.addCheckbox("Synchronize X-Y", this.xy);
        gd.addMessage("kernel_Z", new Font("Arial", 1, 12));
        gd.addNumericField("Radius_Z_unit", (double)this.voisz * this.calibration.pixelDepth, 0, 8, unit);
        gd.addNumericField("Radius_Z_pix", (double)this.voisz, 0, 8, "pix");
        gd.addDialogListener((DialogListener)this);
        gd.showDialog();
        this.filter = gd.getNextChoiceIndex();
        this.uvoisx = gd.getNextNumber();
        this.voisx = (int)gd.getNextNumber();
        this.uvoisy = gd.getNextNumber();
        this.voisy = (int)gd.getNextNumber();
        this.xy = gd.getNextBoolean();
        this.uvoisz = gd.getNextNumber();
        this.voisz = (int)gd.getNextNumber();
        if (count == 0) {
            String lib = "";
            String bits = "";
            String ext = "";
            if (IJ.isLinux()) {
                ext = "so";
            } else if (IJ.isWindows()) {
                ext = "dll";
            } else if (IJ.isMacOSX()) {
                ext = "jnilib";
            }
            bits = IJ.is64Bit() ? "64" : "32";
            lib = "libfilter3d" + bits + "." + ext;
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("jni/" + lib);
            try {
                File fi = new File(IJ.getDirectory((String)"plugins") + lib);
                if (fi.exists()) {
                    IJ.log((String)("Library " + lib + " already exists, delete it for update"));
                } else {
                    int len;
                    FileOutputStream os = new FileOutputStream(fi);
                    byte[] buf = new byte[1024];
                    while ((len = is.read(buf)) > 0) {
                        ((OutputStream)os).write(buf, 0, len);
                    }
                    is.close();
                    ((OutputStream)os).close();
                    IJ.log((String)(lib + " copied to " + fi.getAbsolutePath()));
                }
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(Fast_filters3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(Fast_filters3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                System.load(IJ.getDirectory((String)"plugins") + lib);
                jni_available = true;
            }
            catch (UnsatisfiedLinkError ex) {
                Logger.getLogger(Fast_filters3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (SecurityException e) {
                IJ.log((String)("PB : " + e));
            }
        }
        ++count;
        return !gd.wasCanceled();
    }

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 5;
    }
}

