/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import mcib3d.geom2.Object3DComputation;
import mcib3d.geom2.Object3DInt;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageLabeller;
import mcib3d.image3d.ImageShort;

public class Hysteresis_Thresholding
implements PlugInFilter {
    ImagePlus plus;
    private int markers = 0;

    public int setup(String arg, ImagePlus imp) {
        this.plus = imp;
        return 13;
    }

    public void run(ImageProcessor ip) {
        int nbima = WindowManager.getImageCount();
        String[] names = new String[nbima + 1];
        names[0] = "None";
        for (int i = 1; i <= nbima; ++i) {
            names[i] = WindowManager.getImage((int)i).getShortTitle();
        }
        GenericDialog gd = new GenericDialog("Hysteresis Thresholding");
        gd.addMessage("Image to segment : " + this.plus.getTitle());
        gd.addMessage("Only objects containing markers pixel will be detected.\nIf none all objects are detected.");
        gd.addChoice("Seeds", names, names[this.markers]);
        gd.addNumericField("High Threshold:", 128.0, 1);
        gd.addNumericField("Low Threshold:", 50.0, 1);
        gd.addCheckbox("Show multi-threshold", false);
        gd.addCheckbox(" Labelling", true);
        gd.showDialog();
        if (gd.wasOKed()) {
            this.markers = gd.getNextChoiceIndex();
            double high = gd.getNextNumber();
            double low = gd.getNextNumber();
            boolean show = gd.getNextBoolean();
            boolean label = gd.getNextBoolean();
            Instant t0 = Instant.now();
            ImagePlus hyst = this.hysteresis(this.plus, low, high, show, label);
            Instant t1 = Instant.now();
            hyst.setDisplayRange(0.0, 255.0);
            hyst.show();
            IJ.log((String)("Hysteresis took " + Duration.between(t0, t1)));
        }
    }

    public ImagePlus hysteresis(ImagePlus image, double lowval, double highval, boolean show, boolean label) {
        int HIGH = 255;
        int LOW = 128;
        ImageHandler img = ImageHandler.wrap((ImagePlus)image);
        ImageByte multi = new ImageByte(image.getTitle() + "_Multi", img.sizeX, img.sizeY, img.sizeZ);
        for (int z = 0; z < img.sizeZ; ++z) {
            for (int xy = 0; xy < img.sizeXY; ++xy) {
                if ((double)img.getPixel(xy, z) > highval) {
                    multi.setPixel(xy, z, HIGH);
                    continue;
                }
                if (!((double)img.getPixel(xy, z) > lowval)) continue;
                multi.setPixel(xy, z, LOW);
            }
        }
        if (show) {
            multi.show();
        }
        ImageByte thresholded = multi.thresholdAboveInclusive((float)LOW);
        ImageLabeller labeller = new ImageLabeller();
        List objects = labeller.getObjects3D((ImageHandler)thresholded);
        Object hyst = label ? new ImageShort("HystLabel_" + image.getTitle(), multi.sizeX, multi.sizeY, multi.sizeZ) : new ImageByte("HystBin_" + image.getTitle(), multi.sizeX, multi.sizeY, multi.sizeZ);
        hyst.setVoxelSize(img);
        ImageHandler marker0 = null;
        if (this.markers > 0) {
            marker0 = ImageHandler.wrap((ImagePlus)WindowManager.getImage((int)this.markers));
        }
        ImageHandler marker = marker0;
        AtomicInteger val = new AtomicInteger(1);
        objects.stream().filter(obj -> new Object3DComputation(obj).hasOneVoxelValueRange((ImageHandler)multi, (float)HIGH, (float)HIGH)).filter(obj -> {
            if (marker == null) {
                return true;
            }
            return new Object3DComputation(obj).hasOneVoxelValueAboveStrict(marker, 0.0f);
        }).forEach(arg_0 -> Hysteresis_Thresholding.lambda$hysteresis$2(label, (ImageHandler)hyst, val, arg_0));
        return hyst.getImagePlus();
    }

    private static /* synthetic */ void lambda$hysteresis$2(boolean label, ImageHandler hyst, AtomicInteger val, Object3DInt obj) {
        if (label) {
            obj.drawObject(hyst, (float)val.getAndIncrement());
        } else {
            obj.drawObject(hyst, 255.0f);
        }
    }
}

