/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import mcib3d.geom.interactions.InteractionsComputeContours;
import mcib3d.geom.interactions.InteractionsComputeDamLines;
import mcib3d.geom.interactions.InteractionsComputeDilate;
import mcib3d.geom.interactions.InteractionsList;
import mcib3d.image3d.ImageHandler;

public class Interactions_
implements PlugIn {
    boolean methodLINE = true;
    boolean methodDILATE = false;
    boolean methodTOUCH = false;
    float radxy = 1.0f;
    float radz = 1.0f;

    public void run(String s) {
        ImagePlus plus = WindowManager.getCurrentImage();
        if (plus == null) {
            IJ.error((String)"Open a labelled image to compute interactions");
            return;
        }
        ImageHandler image = ImageHandler.wrap((ImagePlus)plus);
        if (this.dialog()) {
            InteractionsList list;
            if (this.methodDILATE) {
                list = new InteractionsComputeDilate(this.radxy, this.radxy, this.radz).compute(image);
                list.getResultsTableOnlyColoc().show("InteractionsDilate");
            }
            if (this.methodLINE) {
                list = new InteractionsComputeDamLines().compute(image);
                list.getResultsTableOnlyColoc().show("InteractionsLines");
            }
            if (this.methodTOUCH) {
                list = new InteractionsComputeContours().compute(image);
                list.getResultsTableOnlyColoc().show("InteractionsTouch");
            }
        }
    }

    boolean dialog() {
        GenericDialog dialog = new GenericDialog("Interactions");
        dialog.addMessage("Objects are separated by black lines");
        dialog.addCheckbox("Lines", this.methodLINE);
        dialog.addMessage("Objects are touching");
        dialog.addCheckbox("Touching", this.methodTOUCH);
        dialog.addMessage("Objects are separated by empty space");
        dialog.addCheckbox("Dilation", this.methodDILATE);
        dialog.addNumericField("radius_DilateXY", (double)this.radxy, 2);
        dialog.addNumericField("radius_DilateZ", (double)this.radz, 2);
        dialog.showDialog();
        this.methodLINE = dialog.getNextBoolean();
        this.methodTOUCH = dialog.getNextBoolean();
        this.methodDILATE = dialog.getNextBoolean();
        this.radxy = (float)dialog.getNextNumber();
        this.radz = (float)dialog.getNextNumber();
        return dialog.wasOKed();
    }
}

