/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij3d.Content;
import ij3d.Image3DUniverse;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import mcib3d.geom.ObjectCreator3D;
import mcib3d.image3d.ImageHandler;
import mcib3d.utils.ArrayUtil;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Point3f;

public class Line3D_
implements PlugIn {
    public void run(String arg) {
        Image3DUniverse universe;
        boolean viewer3d;
        int tx = 512;
        int ty = 512;
        int tz = 512;
        int x0 = tx / 2;
        int y0 = ty / 2;
        int z0 = tz / 2;
        int x1 = tx;
        int y1 = ty / 2;
        int z1 = tz / 2;
        double rad = 1.0;
        double resXY = 1.0;
        double resZ = 1.0;
        String unit = "pix";
        ArrayList Viewers3D = Image3DUniverse.universes;
        if (Viewers3D.size() > 0) {
            viewer3d = true;
            universe = (Image3DUniverse)Viewers3D.get(0);
        } else {
            viewer3d = false;
            universe = null;
        }
        boolean profile = false;
        ImagePlus plus = WindowManager.getCurrentImage();
        String title = plus != null ? plus.getShortTitle() : "*None*";
        Calibration cal = null;
        ImageStack stack = null;
        if (WindowManager.getWindowCount() > 0) {
            profile = true;
            stack = plus.getStack();
            tx = stack.getWidth();
            ty = stack.getHeight();
            tz = stack.getSize();
            x0 = tx / 2;
            y0 = ty / 2;
            z0 = tz / 2;
            x1 = tx;
            y1 = ty / 2;
            z1 = tz / 2;
            cal = WindowManager.getImage((int)WindowManager.getIDList()[0]).getCalibration();
            if (cal != null && cal.scaled()) {
                resXY = cal.getX(1.0);
                resZ = cal.getZ(1.0);
                unit = cal.getUnits();
            }
        }
        String[] displays = new String[]{"New stack", "Overwrite", "None"};
        int display = 0;
        boolean arrow = true;
        GenericDialog gd = new GenericDialog("Line_3D");
        int w = 10;
        gd.addMessage("Image: " + title, new Font("Arial", 1, 12));
        gd.addNumericField("Size_X", (double)tx, 0, w, "pixel");
        gd.addNumericField("Size_Y", (double)ty, 0, w, "pixel");
        gd.addNumericField("Size_Z", (double)tz, 0, w, "pixel");
        gd.addMessage("Start Coordinate", new Font("Arial", 1, 12));
        gd.addNumericField("x0", (double)x0, 0, w, "pixel");
        gd.addNumericField("y0", (double)y0, 0, w, "pixel");
        gd.addNumericField("z0", (double)z0, 0, w, "pixel");
        gd.addMessage("End Coordinate", new Font("Arial", 1, 12));
        gd.addNumericField("x1", (double)x1, 0, w, "pixel");
        gd.addNumericField("y1", (double)y1, 0, w, "pixel");
        gd.addNumericField("z1", (double)z1, 0, w, "pixel");
        gd.addMessage("Display", new Font("Arial", 1, 12));
        gd.addCheckbox("Mark ends", arrow);
        gd.addCheckbox("Plot profile", profile);
        gd.addNumericField("thickness", rad, 3, w, "pixel");
        gd.addNumericField("Value", 255.0, 0);
        gd.addChoice("Display", displays, displays[display]);
        gd.addCheckbox("3D_viewer", viewer3d);
        gd.showDialog();
        if (gd.wasOKed()) {
            ObjectCreator3D obj;
            tx = (int)gd.getNextNumber();
            ty = (int)gd.getNextNumber();
            tz = (int)gd.getNextNumber();
            x0 = (int)gd.getNextNumber();
            y0 = (int)gd.getNextNumber();
            z0 = (int)gd.getNextNumber();
            x1 = (int)gd.getNextNumber();
            y1 = (int)gd.getNextNumber();
            z1 = (int)gd.getNextNumber();
            arrow = gd.getNextBoolean();
            profile = gd.getNextBoolean();
            rad = gd.getNextNumber();
            int val = (int)gd.getNextNumber();
            display = gd.getNextChoiceIndex();
            viewer3d = gd.getNextBoolean();
            int r = (int)rad;
            if (profile) {
                ImageHandler ima3d = ImageHandler.wrap((ImageStack)stack);
                double[] line3d = ima3d.extractLine(x0, y0, z0, x1, y1, z1, false);
                ArrayUtil lineutil = new ArrayUtil(line3d);
                lineutil.getPlot().show();
            }
            if (display == 0) {
                obj = new ObjectCreator3D(tx, ty, tz);
                obj.setResolution(resXY, resZ, unit);
                obj.createLine(x0, y0, z0, x1, y1, z1, (float)val, r);
                if (arrow) {
                    obj.createEllipsoid(x0, y0, z0, (double)(2 * r), (double)(2 * r), (double)(2 * r), (float)val, false);
                    obj.createEllipsoid(x1, y1, z1, (double)(2 * r), (double)(2 * r), (double)(2 * r), (float)val, false);
                }
                ImagePlus plusLine = new ImagePlus("Line3D", obj.getStack());
                plusLine.setCalibration(cal);
                plusLine.show("3D Profile of " + title);
            } else if (display == 1) {
                if (stack == null) {
                    IJ.log((String)"No Stack !");
                } else {
                    obj = new ObjectCreator3D(stack);
                    obj.createLine(x0, y0, z0, x1, y1, z1, (float)val, r);
                    plus.updateAndDraw();
                }
            }
            if (viewer3d) {
                float rxy = (float)resXY;
                float rz = (float)resZ;
                Point3f p1 = new Point3f((float)x0 * rxy, (float)y0 * rxy, (float)z0 * rz);
                Point3f p2 = new Point3f((float)x1 * rxy, (float)y1 * rxy, (float)z1 * rz);
                ArrayList<Point3f> line = new ArrayList<Point3f>();
                line.add(p1);
                line.add(p2);
                if (universe == null) {
                    universe = new Image3DUniverse(512, 512);
                    universe.show();
                }
                int l = 1;
                while (universe.contains("line" + l)) {
                    ++l;
                }
                Color foreground = Toolbar.getForegroundColor();
                Content cline = universe.addLineMesh(line, new Color3f((float)foreground.getRed() / 255.0f, (float)foreground.getGreen() / 255.0f, (float)foreground.getBlue() / 255.0f), "line" + l, true);
                cline.setVisible(true);
                l = 1;
                while (universe.contains("point" + l)) {
                    ++l;
                }
                Content cpoints = universe.addPointMesh(line, new Color3f((float)foreground.getRed() / 255.0f, (float)foreground.getGreen() / 255.0f, (float)foreground.getBlue() / 255.0f), 8.0f, "point" + l);
                cpoints.setVisible(true);
            }
        }
    }
}

