/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins.Manager3D;

import ij.ImagePlus;
import ij.Prefs;
import ij.gui.Roi;
import ij.plugin.filter.ThresholdToSelection;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import mcib3d.geom.ObjectCreator3D;
import mcib3d.geom.Point3D;
import mcib3d.geom2.BoundingBox;
import mcib3d.geom2.Object3DInt;
import mcib3d.geom2.Object3DIntLabelImage;
import mcib3d.geom2.measurements.MeasureCentroid;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageHandler;
import mcib_plugins.Manager3D.Rois3D;

public class Create3DRoi {
    public static final int ROI_CONTOUR = 0;
    public static final int ROI_BB = 1;
    public static final int ROI_CENTROID = 2;
    public static final int ROI_SPHERE = 3;

    public static Rois3D computeRois(Object3DInt object3DInt) {
        return Create3DRoi.computeRois(object3DInt, (int)Prefs.get((String)"RoiManager3D-Options_roi.double", (double)0.0));
    }

    public static Rois3D computeRois(Object3DInt object3DInt, int roi) {
        ImageHandler labelImageCrop = new Object3DIntLabelImage(object3DInt).getCroppedLabelImage(255.0f);
        int offX = labelImageCrop.offsetX;
        int offY = labelImageCrop.offsetY;
        int offZ = labelImageCrop.offsetZ;
        ObjectCreator3D creator3DCrop = new ObjectCreator3D(labelImageCrop);
        switch (roi) {
            case 0: {
                break;
            }
            case 3: {
                labelImageCrop.fill(0.0);
                Point3D point3D = new MeasureCentroid(object3DInt).getCentroidAsPoint();
                double rad = Prefs.get((String)"RoiManager3D-V3-Options_radiusRoi.double", (double)2.0);
                double radius = Math.max(1.0, rad);
                radius = Math.min(radius, 50.0);
                creator3DCrop.createEllipsoid(point3D.getRoundX() - offX, point3D.getRoundY() - offY, point3D.getRoundZ() - offZ, radius, radius, radius, 255.0f, false);
                break;
            }
            case 1: {
                labelImageCrop.fill(0.0);
                BoundingBox box = object3DInt.getBoundingBox();
                for (int z = box.zmin; z <= box.zmax; ++z) {
                    creator3DCrop.createBrick((int)Math.round(0.5 * (double)(box.xmin + box.xmax) - (double)offX), (int)Math.round(0.5 * (double)(box.ymin + box.ymax) - (double)offY), (int)Math.round(0.5 * (double)(box.zmin + box.zmax) - (double)offZ), 0.5 * (double)(box.xmax - box.xmin), 0.5 * (double)(box.ymax - box.ymin), 0.5 * (double)(box.zmax - box.zmin), 255.0f);
                }
                break;
            }
            case 2: {
                labelImageCrop.fill(0.0);
                Point3D centre2 = new MeasureCentroid(object3DInt).getCentroidAsPoint();
                creator3DCrop.createPixel(centre2.getRoundX() - offX, centre2.getRoundY() - offY, centre2.getRoundZ() - offZ, 255);
            }
        }
        Rois3D arrayRoi = new Rois3D(offZ, labelImageCrop.sizeZ + offZ);
        ImageByte binaryCrop = labelImageCrop.thresholdAboveExclusive(0.0f);
        for (int zz = 0; zz < labelImageCrop.sizeZ; ++zz) {
            ByteProcessor mask = new ByteProcessor(binaryCrop.sizeX, binaryCrop.sizeY, (byte[])binaryCrop.getArray1D(zz));
            mask.setThreshold(1.0, 255.0, 2);
            ImagePlus maskPlus = new ImagePlus("mask " + zz, (ImageProcessor)mask);
            ThresholdToSelection tts = new ThresholdToSelection();
            tts.setup("", maskPlus);
            tts.run((ImageProcessor)mask);
            Roi roiTmp = maskPlus.getRoi();
            if (roiTmp != null) {
                roiTmp.setLocation(roiTmp.getXBase() + (double)offX, roiTmp.getYBase() + (double)offY);
            }
            arrayRoi.setRoi(roiTmp, zz + offZ);
        }
        return arrayRoi;
    }

    public Roi[] computeRois(JList listUI, ImagePlus imp) {
        Object3DInt obj;
        if (imp == null) {
            return null;
        }
        DefaultListModel model = (DefaultListModel)listUI.getModel();
        int zmin = imp.getNSlices() + 1;
        int zmax = -1;
        int[] indexes = listUI.getSelectedIndices();
        boolean allIndices = indexes.length == 0;
        int nb = allIndices ? model.getSize() : indexes.length;
        for (int i = 0; i < nb; ++i) {
            obj = allIndices ? (Object3DInt)model.elementAt(i) : (Object3DInt)model.getElementAt(indexes[i]);
            BoundingBox box = obj.getBoundingBox();
            if (box.zmin < zmin) {
                zmin = box.zmin;
            }
            if (box.zmax <= zmax) continue;
            zmax = box.zmax;
        }
        ImageByte label = new ImageByte("rois", imp.getWidth(), imp.getHeight(), imp.getNSlices());
        label.fill(0.0);
        ObjectCreator3D creator3D = new ObjectCreator3D((ImageHandler)label);
        int roi = (int)Prefs.get((String)"RoiManager3D-Options_roi.double", (double)0.0);
        block6: for (int index : indexes) {
            obj = (Object3DInt)model.getElementAt(index);
            switch (roi) {
                case 0: {
                    obj.drawObject(creator3D.getImageHandler(), 255.0f);
                    continue block6;
                }
                case 1: {
                    Point3D point3D = new MeasureCentroid(obj).getCentroidAsPoint();
                    creator3D.createEllipsoid(point3D.getRoundX(), point3D.getRoundY(), point3D.getRoundZ(), 2.0, 2.0, 1.0, 255.0f, false);
                    continue block6;
                }
                case 3: {
                    BoundingBox box = obj.getBoundingBox();
                    for (int z = box.zmin; z <= box.zmax; ++z) {
                        creator3D.createBrick((int)Math.round(0.5 * (double)(box.xmin + box.xmax)), (int)Math.round(0.5 * (double)(box.ymin + box.ymax)), (int)Math.round(0.5 * (double)(box.zmin + box.zmax)), 0.5 * (double)(box.xmax - box.xmin), 0.5 * (double)(box.ymax - box.ymin), 0.5 * (double)(box.zmax - box.zmin), 255.0f);
                    }
                    continue block6;
                }
                default: {
                    Point3D centre2 = new MeasureCentroid(obj).getCentroidAsPoint();
                    creator3D.createPixel(centre2.getRoundX(), centre2.getRoundY(), centre2.getRoundZ(), 255);
                }
            }
        }
        Roi[] arrayRois = new Roi[imp.getNSlices()];
        for (int zz = zmin; zz <= zmax; ++zz) {
            ByteProcessor mask = new ByteProcessor(imp.getWidth(), imp.getHeight(), (byte[])label.getArray1D(zz));
            mask.setThreshold(1.0, 255.0, 2);
            ImagePlus maskPlus = new ImagePlus("mask " + zz, (ImageProcessor)mask);
            ThresholdToSelection tts = new ThresholdToSelection();
            tts.setup("", maskPlus);
            tts.run((ImageProcessor)mask);
            arrayRois[zz] = maskPlus.getRoi();
        }
        return arrayRois;
    }
}

