/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins.Manager3D;

import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import java.util.LinkedList;
import java.util.List;
import mcib3d.geom2.Object3DInt;
import mcib3d.geom2.Objects3DIntPopulation;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageShort;

public class ExportToImage {
    public List<ImageHandler> exportSelected(List<Object3DInt> selectedObjects) {
        LinkedList<ImageHandler> imagesExport = new LinkedList<ImageHandler>();
        boolean a32 = Prefs.get((String)"RoiManager3D-V3-Options_seg32Export.boolean", (boolean)false);
        boolean currentSize = Prefs.get((String)"RoiManager3D-V3-Options_currentSize.boolean", (boolean)false);
        boolean types = Prefs.get((String)"RoiManager3D-V3-Options_typesExport.boolean", (boolean)false);
        if (types) {
            for (int t = 1; t <= 9; ++t) {
                int type = t;
                Objects3DIntPopulation populationType = new Objects3DIntPopulation();
                selectedObjects.stream().filter(obj -> obj.getType() == type).forEach(arg_0 -> ((Objects3DIntPopulation)populationType).addObject(arg_0));
                if (Prefs.get((String)"RoiManager3D-V3-Options_resetLabels.boolean", (boolean)true)) {
                    populationType.resetLabels();
                }
                if (populationType.getNbObjects() <= 0) continue;
                ImageHandler exportImage = this.drawPopulation(populationType, a32, currentSize);
                exportImage.setTitle("ExportType" + t);
                exportImage.setScale(populationType.getVoxelSizeXY(), populationType.getVoxelSizeZ(), "unit");
                imagesExport.add(exportImage);
            }
        } else {
            Objects3DIntPopulation population = new Objects3DIntPopulation();
            selectedObjects.forEach(arg_0 -> ((Objects3DIntPopulation)population).addObject(arg_0));
            if (Prefs.get((String)"RoiManager3D-V3-Options_resetLabels.boolean", (boolean)true)) {
                population.resetLabels();
            }
            ImageHandler exportImage = this.drawPopulation(population, a32, currentSize);
            exportImage.setTitle("ExportAll");
            exportImage.setScale(population.getVoxelSizeXY(), population.getVoxelSizeZ(), "unit");
            imagesExport.add(exportImage);
        }
        return imagesExport;
    }

    private ImageHandler drawPopulation(Objects3DIntPopulation population, boolean a32, boolean currentSize) {
        ImagePlus plus;
        if (currentSize && (plus = WindowManager.getCurrentImage()) != null) {
            Object handler = a32 ? new ImageFloat("export", plus.getWidth(), plus.getHeight(), plus.getNSlices()) : new ImageShort("export", plus.getWidth(), plus.getHeight(), plus.getNSlices());
            population.drawInImage((ImageHandler)handler);
            return handler;
        }
        return population.drawImage();
    }
}

