/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins.Manager3D;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Toolbar;
import ij3d.Content;
import ij3d.ContentCreator;
import ij3d.Image3DUniverse;
import ij3d.ImageCanvas3D;
import ij3d.ImageJ_3D_Viewer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import mcib3d.geom2.Object3DInt;
import mcib3d.geom2.Object3DIntLabelImage;
import mcib3d.geom2.Objects3DIntPopulation;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageShort;
import org.scijava.vecmath.Color3f;

public class Fill3DViewer {
    private Image3DUniverse universe;

    public Fill3DViewer() {
        this.getUniverse();
    }

    private void add3DViewer(Object3DInt obj, String name, Color col) {
        Color3f col3f = new Color3f((float)col.getRed() / 255.0f, (float)col.getGreen() / 255.0f, (float)col.getBlue() / 255.0f);
        if (obj.size() > 0.0) {
            if (!this.universe.contains(name)) {
                ImageHandler labelImage = new Object3DIntLabelImage(obj).getLabelImage(1.0f);
                ImageByte imageByte = ((ImageShort)labelImage).convertToByte(false);
                ImagePlus imagePlus = imageByte.getImagePlus();
                Content c = ContentCreator.createContent((String)name, (ImagePlus)imagePlus, (int)2, (int)1, (int)0, (Color3f)col3f, (int)0, (boolean[])new boolean[]{true, true, true});
                this.universe.addContentLater(c);
                c.setLocked(true);
            } else {
                System.out.println("Recoloring obj " + name);
                Content surface = this.universe.getContent(name);
                surface.setColor(col3f);
            }
        }
    }

    private void getUniverse() {
        System.out.println("Getting universes");
        IJ.log((String)ImageJ_3D_Viewer.getJava3DVersion());
        ArrayList Viewers3D = Image3DUniverse.universes;
        System.out.println("Universes opened " + Viewers3D.size());
        if (!Viewers3D.isEmpty()) {
            this.universe = (Image3DUniverse)Viewers3D.get(0);
        } else {
            this.universe = new Image3DUniverse(512, 512);
            IJ.wait((int)100);
        }
        System.out.println("Universe " + this.universe + " " + this.universe.allContentsString());
    }

    public void fill3DViewer(Object3DInt object3DInt) {
        Color color = Toolbar.getForegroundColor();
        Color3f col3f = new Color3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
        this.fill3DViewer(object3DInt, col3f);
    }

    public void fill3DViewerMacro(Object3DInt object3DInt) {
        int intColor = (int)IJ.getImage().getProcessor().getForegroundValue();
        Color color = new Color(intColor);
        System.out.println("Color " + color + " " + intColor);
        Color3f col3f = new Color3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
        this.fill3DViewer(object3DInt, col3f);
    }

    public void fill3DViewer(Object3DInt object3DInt, Color3f col3f) {
        if (this.universe == null || this.universe.getWindow() == null || this.universe.getCanvas() == null) {
            this.universe = new Image3DUniverse();
            this.universe.show();
        }
        ImageHandler labels = new Object3DIntLabelImage(object3DInt).getLabelImage(255.0f);
        ImagePlus imagePlus = labels.thresholdAboveExclusive(0.0f).getImagePlus();
        Content c = ContentCreator.createContent((String)("obj-" + object3DInt.getLabel() + "-" + object3DInt.getType()), (ImagePlus)imagePlus, (int)2, (int)1, (int)0, (Color3f)col3f, (int)0, (boolean[])new boolean[]{true, true, true});
        this.universe.addContentLater(c);
        c.setLocked(true);
        ImageCanvas3D canvas = (ImageCanvas3D)this.universe.getCanvas();
        canvas.render();
    }

    public void fill3DViewer(List<Object3DInt> object3DInts) {
        Color color = Toolbar.getForegroundColor();
        Color3f col3f = new Color3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
        if (this.universe == null || this.universe.getWindow() == null || this.universe.getCanvas() == null) {
            this.universe = new Image3DUniverse();
            this.universe.show();
        }
        Objects3DIntPopulation population = new Objects3DIntPopulation();
        object3DInts.forEach(arg_0 -> ((Objects3DIntPopulation)population).addObject(arg_0));
        ImageHandler labels = population.drawImage();
        ImageByte binary = labels.thresholdAboveExclusive(0.0f);
        ImagePlus imagePlus = binary.getImagePlus();
        Content c = ContentCreator.createContent((String)("pop-" + (int)(Math.random() * 1000.0)), (ImagePlus)imagePlus, (int)2, (int)1, (int)0, (Color3f)col3f, (int)0, (boolean[])new boolean[]{true, true, true});
        this.universe.addContentLater(c);
        c.setLocked(true);
        ImageCanvas3D canvas = (ImageCanvas3D)this.universe.getCanvas();
        canvas.render();
    }
}

