/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins.Manager3D;

import ij.Prefs;
import ij.gui.Roi;
import java.util.List;
import java.util.stream.Collectors;
import mcib3d.geom.Point3D;
import mcib3d.geom2.Object3DInt;
import mcib3d.geom2.Objects3DIntPopulation;
import mcib3d.geom2.Objects3DIntPopulationComputation;
import mcib3d.geom2.measurements.MeasureCentroid;
import mcib3d.image3d.ImageHandler;

public class ImportImage {
    ImageHandler image;

    public ImportImage(ImageHandler image) {
        this.image = image;
    }

    public Objects3DIntPopulation importImage() {
        Roi roi;
        Objects3DIntPopulation population = new Objects3DIntPopulation(this.image);
        double minSize = Prefs.get((String)"RoiManager3D-V3-Options_MinSegment.double", (double)0.0);
        double maxSize = Prefs.get((String)"RoiManager3D-V3-Options_MaxSegment.double", (double)Double.MAX_VALUE);
        if (maxSize == -1.0) {
            maxSize = Double.MAX_VALUE;
        }
        double maxSize1 = maxSize;
        boolean touchXY = Prefs.get((String)"RoiManager3D-V3-Options_excludeXY.boolean", (boolean)false);
        boolean touchZ = Prefs.get((String)"RoiManager3D-V3-Options_excludeZ.boolean", (boolean)false);
        if (touchXY || touchZ) {
            population = new Objects3DIntPopulationComputation(population).getExcludeBorders(this.image, touchZ);
        }
        if (minSize > 0.0 || maxSize < Double.MAX_VALUE) {
            population = new Objects3DIntPopulationComputation(population).getFilterSize(minSize, maxSize);
        }
        if (Prefs.get((String)"RoiManager3D-V3-Options_useRoi.boolean", (boolean)false) && (roi = this.image.getImagePlus().getRoi()) != null) {
            System.out.println("Import using roi " + roi);
            List toKeep = population.getObjects3DInt().stream().filter(obj -> {
                Point3D centroid = new MeasureCentroid(obj).getCentroidAsPoint();
                return roi.contains(centroid.getRoundX(), centroid.getRoundY());
            }).collect(Collectors.toList());
            population = new Objects3DIntPopulation();
            for (Object3DInt object3DInt : toKeep) {
                population.addObject(object3DInt);
            }
        }
        return population;
    }
}

