/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins.Manager3D;

import ij.Prefs;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class ImportOptions
extends JFrame {
    private JTextField minField;
    private JTextField maxField;
    private JPanel contentPanel;
    private JButton OKButton;
    private JButton cancelButton;
    private JCheckBox excludeEdgesXY;
    private JCheckBox excludeEdgeZ;
    private JCheckBox useRoiCheckBox;
    private JCheckBox a32BitSegmentationCheckBox;

    public ImportOptions() throws HeadlessException {
        this.$$$setupUI$$$();
        this.setTitle("Segmentation Options");
        this.setContentPane(this.contentPanel);
        this.minField.setText("" + Prefs.get((String)"RoiManager3D-V3-Options_MinSegment.double", (double)0.0));
        this.minField.setToolTipText("Minimum size of objects, in number of pixels");
        this.maxField.setText("" + Prefs.get((String)"RoiManager3D-V3-Options_MaxSegment.double", (double)-1.0));
        this.maxField.setToolTipText("Maximum size of objects, in number of pixels. -1 for no limit.");
        this.excludeEdgesXY.setSelected(Prefs.get((String)"RoiManager3D-V3-Options_excludeXY.boolean", (boolean)false));
        this.excludeEdgesXY.setToolTipText("Exclude objects touching X or Y edges");
        this.excludeEdgeZ.setSelected(Prefs.get((String)"RoiManager3D-V3-Options_excludeZ.boolean", (boolean)false));
        this.excludeEdgeZ.setToolTipText("Exclude objects touching Z edges");
        this.useRoiCheckBox.setSelected(Prefs.get((String)"RoiManager3D-V3-Options_useRoi.boolean", (boolean)false));
        this.OKButton.addActionListener(actionEvent -> {
            Prefs.set((String)"RoiManager3D-V3-Options_MinSegment.double", (double)Double.parseDouble(this.minField.getText()));
            Prefs.set((String)"RoiManager3D-V3-Options_MaxSegment.double", (double)Double.parseDouble(this.maxField.getText()));
            Prefs.set((String)"RoiManager3D-V3-Options_excludeXY.boolean", (boolean)this.excludeEdgesXY.isSelected());
            Prefs.set((String)"RoiManager3D-V3-Options_excludeZ.boolean", (boolean)this.excludeEdgeZ.isSelected());
            Prefs.set((String)"RoiManager3D-V3-Options_useRoi.boolean", (boolean)this.useRoiCheckBox.isSelected());
            this.dispose();
        });
        this.cancelButton.addActionListener(actionEvent -> this.dispose());
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            throw new RuntimeException(e);
        }
        ImportOptions dialog = new ImportOptions();
        dialog.pack();
        dialog.setSize(400, 300);
        dialog.setVisible(true);
    }

    private void $$$setupUI$$$() {
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new GridBagLayout());
        this.contentPanel.setMinimumSize(new Dimension(600, 300));
        this.contentPanel.setPreferredSize(new Dimension(600, 300));
        JLabel label1 = new JLabel();
        label1.setText("Object Size");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        this.contentPanel.add((Component)label1, gbc);
        JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.contentPanel.add((Component)spacer1, gbc);
        JLabel label2 = new JLabel();
        label2.setText("Minimum size");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        this.contentPanel.add((Component)label2, gbc);
        JLabel label3 = new JLabel();
        label3.setText("Maximum Size");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        this.contentPanel.add((Component)label3, gbc);
        this.minField = new JTextField();
        this.minField.setMinimumSize(new Dimension(128, 30));
        this.minField.setPreferredSize(new Dimension(128, 30));
        this.minField.setText("0");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.contentPanel.add((Component)this.minField, gbc);
        this.maxField = new JTextField();
        this.maxField.setMinimumSize(new Dimension(128, 30));
        this.maxField.setPreferredSize(new Dimension(128, 30));
        this.maxField.setText("-1");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.contentPanel.add((Component)this.maxField, gbc);
        JLabel label4 = new JLabel();
        label4.setText("Options");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 17;
        this.contentPanel.add((Component)label4, gbc);
        JSeparator separator1 = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.fill = 1;
        this.contentPanel.add((Component)separator1, gbc);
        this.OKButton = new JButton();
        this.OKButton.setMaximumSize(new Dimension(30, 30));
        this.OKButton.setMinimumSize(new Dimension(30, 30));
        this.OKButton.setPreferredSize(new Dimension(30, 30));
        this.OKButton.setText("OK");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.fill = 2;
        this.contentPanel.add((Component)this.OKButton, gbc);
        this.cancelButton = new JButton();
        this.cancelButton.setMaximumSize(new Dimension(30, 30));
        this.cancelButton.setMinimumSize(new Dimension(30, 30));
        this.cancelButton.setPreferredSize(new Dimension(30, 30));
        this.cancelButton.setText("Cancel");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 8;
        gbc.fill = 2;
        this.contentPanel.add((Component)this.cancelButton, gbc);
        JPanel spacer2 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.gridwidth = 3;
        gbc.fill = 3;
        this.contentPanel.add((Component)spacer2, gbc);
        JPanel spacer3 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 8;
        gbc.fill = 2;
        this.contentPanel.add((Component)spacer3, gbc);
        this.excludeEdgesXY = new JCheckBox();
        this.excludeEdgesXY.setText("excludeEdgeXY");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.anchor = 17;
        this.contentPanel.add((Component)this.excludeEdgesXY, gbc);
        this.excludeEdgeZ = new JCheckBox();
        this.excludeEdgeZ.setText("excludeEdgeZ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.anchor = 17;
        this.contentPanel.add((Component)this.excludeEdgeZ, gbc);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPanel;
    }
}

