/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins.Manager3D;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.macro.ExtensionDescriptor;
import ij.macro.Functions;
import ij.macro.MacroExtension;
import ij.plugin.PlugIn;
import java.awt.Color;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import mcib3d.geom2.Object3DInt;
import mcib3d.geom2.Objects3DIntPopulation;
import mcib3d.geom2.measurements.Measure2Colocalisation;
import mcib3d.geom2.measurements.Measure2Distance;
import mcib3d.geom2.measurements.MeasureObject;
import mcib3d.image3d.ImageHandler;
import mcib_plugins.Manager3D.Fill3DStack;
import mcib_plugins.Manager3D.Fill3DViewer;
import org.scijava.vecmath.Color3f;

public class MacroManager3D
implements MacroExtension,
PlugIn {
    private static final Fill3DViewer viewer3D = new Fill3DViewer();
    private static MacroManager3D macroManager3D = null;
    private static Map<Integer, Object3DInt> object3DIntMap = null;

    public String handleExtension(String command, Object[] args) {
        switch (command) {
            case "Manager3DV4_ImportImage": {
                this.importImage();
                break;
            }
            case "Manager3DV4_MeasureList": {
                this.listMeasure();
                break;
            }
            case "Manager3DV4_GetClass": {
                this.getType(args);
                break;
            }
            case "Manager3DV4_SetClass": {
                this.setType(args);
                break;
            }
            case "Manager3DV4_Measure": {
                this.measure(args);
                break;
            }
            case "Manager3DV4_MeasureIntensity": {
                this.measureIntensity(args);
                break;
            }
            case "Manager3DV4_3DViewer": {
                this.viewer3D(args);
                break;
            }
            case "Manager3DV4_3DFill": {
                this.fill3D(args);
                break;
            }
            case "Manager3DV4_DistanceList": {
                this.listDistances();
                break;
            }
            case "Manager3DV4_NbObjects": {
                this.nbObjects(args);
                break;
            }
            case "Manager3DV4_Distance2": {
                this.distance3D(args);
                break;
            }
            case "Manager3DV4_ColocList": {
                this.listColocs();
                break;
            }
            case "Manager3DV4_Coloc2": {
                this.coloc3D(args);
            }
        }
        return null;
    }

    private void listColocs() {
        IJ.log((String)"---------- Colocalisation -----------");
        String[] names = new Measure2Colocalisation(new Object3DInt(), new Object3DInt()).getNamesMeasurement();
        Arrays.stream(names).sorted().forEach(IJ::log);
    }

    private void coloc3D(Object[] args) {
        Double D = (Double)args[0];
        int a = D.intValue();
        D = (Double)args[1];
        int b = D.intValue();
        String mes = (String)args[2];
        ((Double[])args[3])[0] = new Measure2Colocalisation(object3DIntMap.get(a), object3DIntMap.get(b)).getValueMeasurement(mes);
    }

    private void fill3D(Object[] args) {
        Double D = (Double)args[0];
        int a = D.intValue();
        D = (Double)args[1];
        int r = D.intValue();
        D = (Double)args[2];
        int g = D.intValue();
        D = (Double)args[3];
        int b = D.intValue();
        Color col = new Color((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
        new Fill3DStack().fill3D(object3DIntMap.get(a), col);
    }

    private void nbObjects(Object[] args) {
        ((Double[])args[0])[0] = object3DIntMap.size();
    }

    private void importImage() {
        Objects3DIntPopulation population = new Objects3DIntPopulation(ImageHandler.wrap((ImagePlus)WindowManager.getCurrentImage()));
        object3DIntMap = new HashMap<Integer, Object3DInt>();
        AtomicInteger ai = new AtomicInteger(0);
        population.getObjects3DInt().forEach(object3DInt -> object3DIntMap.put(ai.getAndIncrement(), (Object3DInt)object3DInt));
    }

    private void listMeasure() {
        IJ.log((String)"---------- Measure Geometry -----------");
        new MeasureObject().listMeasures().stream().sorted().forEach(IJ::log);
        IJ.log((String)"---------- Measure Intensity -----------");
        new MeasureObject().listMeasuresIntensity().stream().sorted().forEach(IJ::log);
    }

    private void getType(Object[] args) {
        Double D = (Double)args[0];
        int a = D.intValue();
        ((Double[])args[1])[0] = object3DIntMap.get(a).getType();
    }

    private void setType(Object[] args) {
        Double D = (Double)args[0];
        int a = D.intValue();
        D = (Double)args[1];
        int b = D.intValue();
        object3DIntMap.get(a).setType(b);
    }

    private void measure(Object[] args) {
        Double D = (Double)args[0];
        int a = D.intValue();
        String S = (String)args[1];
        ((Double[])args[2])[0] = new MeasureObject(object3DIntMap.get(a)).measure(S);
    }

    private void measureIntensity(Object[] args) {
        Double D = (Double)args[0];
        int a = D.intValue();
        String S = (String)args[1];
        ((Double[])args[2])[0] = new MeasureObject(object3DIntMap.get(a)).measureIntensity(S, ImageHandler.wrap((ImagePlus)WindowManager.getCurrentImage()));
    }

    private void viewer3D(Object[] args) {
        Double D = (Double)args[0];
        int a = D.intValue();
        D = (Double)args[1];
        int r = D.intValue();
        D = (Double)args[2];
        int g = D.intValue();
        D = (Double)args[3];
        int b = D.intValue();
        Color3f col3f = new Color3f((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
        viewer3D.fill3DViewer(object3DIntMap.get(a), col3f);
    }

    private void distance3D(Object[] args) {
        Double D = (Double)args[0];
        int a = D.intValue();
        D = (Double)args[1];
        int b = D.intValue();
        String mes = (String)args[2];
        ((Double[])args[3])[0] = new Measure2Distance(object3DIntMap.get(a), object3DIntMap.get(b)).getValueMeasurement(mes);
    }

    private void listDistances() {
        IJ.log((String)"---------- Distances -----------");
        String[] names = new Measure2Distance(new Object3DInt(), new Object3DInt()).getNamesMeasurement();
        Arrays.stream(names).sorted().forEach(IJ::log);
    }

    public ExtensionDescriptor[] getExtensionFunctions() {
        int[] argGetType = new int[]{2, 18};
        int[] argSetType = new int[]{2, 2};
        int[] argMeasure = new int[]{2, 1, 18};
        int[] argViewer = new int[]{2, 2, 2, 2};
        int[] argNb = new int[]{18};
        int[] argDist = new int[]{2, 2, 1, 18};
        ExtensionDescriptor[] extensions = new ExtensionDescriptor[]{ExtensionDescriptor.newDescriptor((String)"Manager3DV4_ImportImage", (MacroExtension)this), ExtensionDescriptor.newDescriptor((String)"Manager3DV4_MeasureList", (MacroExtension)this), ExtensionDescriptor.newDescriptor((String)"Manager3DV4_GetClass", (MacroExtension)this, (int[])argGetType), ExtensionDescriptor.newDescriptor((String)"Manager3DV4_SetClass", (MacroExtension)this, (int[])argSetType), ExtensionDescriptor.newDescriptor((String)"Manager3DV4_Measure", (MacroExtension)this, (int[])argMeasure), ExtensionDescriptor.newDescriptor((String)"Manager3DV4_MeasureIntensity", (MacroExtension)this, (int[])argMeasure), ExtensionDescriptor.newDescriptor((String)"Manager3DV4_3DViewer", (MacroExtension)this, (int[])argViewer), ExtensionDescriptor.newDescriptor((String)"Manager3DV4_3DFill", (MacroExtension)this, (int[])argViewer), ExtensionDescriptor.newDescriptor((String)"Manager3DV4_NbObjects", (MacroExtension)this, (int[])argNb), ExtensionDescriptor.newDescriptor((String)"Manager3DV4_DistanceList", (MacroExtension)this), ExtensionDescriptor.newDescriptor((String)"Manager3DV4_Distance2", (MacroExtension)this, (int[])argDist), ExtensionDescriptor.newDescriptor((String)"Manager3DV4_ColocList", (MacroExtension)this), ExtensionDescriptor.newDescriptor((String)"Manager3DV4_Coloc2", (MacroExtension)this, (int[])argDist)};
        return extensions;
    }

    public void run(String s) {
        if (IJ.macroRunning()) {
            Functions.registerExtensions((MacroExtension)this);
            if (macroManager3D == null) {
                macroManager3D = new MacroManager3D();
            }
        } else {
            IJ.log((String)"Implementing 3D Manager macros.");
            IJ.open((String)(IJ.getDirectory((String)"plugins") + File.separator + "mcib3d-suite" + File.separator + "MacroV4.ijm"));
        }
    }
}

