/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins.Manager3D;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import mcib3d.geom2.Object3DInt;
import mcib3d.geom2.Objects3DIntPopulation;
import mcib3d.geom2.measurements.Measure2Colocalisation;
import mcib_plugins.Manager3D.ResultsFrame;

public class Manager3DColoc {
    public static ResultsFrame coloc3D(List<Object3DInt> object3DListA, List<Object3DInt> object3DListB) {
        if (object3DListA == null || object3DListB == null) {
            return null;
        }
        Objects3DIntPopulation populationA = new Objects3DIntPopulation();
        object3DListA.forEach(arg_0 -> ((Objects3DIntPopulation)populationA).addObject(arg_0));
        Objects3DIntPopulation populationB = new Objects3DIntPopulation();
        object3DListB.forEach(arg_0 -> ((Objects3DIntPopulation)populationB).addObject(arg_0));
        ArrayList<String> headings = new ArrayList<String>();
        headings.add("Nb");
        headings.add("Name");
        headings.add("Label");
        headings.add("Type");
        headings.add("O1");
        headings.add("N1");
        headings.add("T1");
        headings.add("V1");
        headings.add("P1");
        HashMap map = new HashMap();
        AtomicInteger ai = new AtomicInteger(0);
        AtomicInteger maxObj = new AtomicInteger(0);
        object3DListA.forEach(objA -> {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(ai.get() + 1);
            list.add(objA.getName());
            list.add(Float.valueOf(objA.getLabel()));
            list.add(objA.getType());
            list.add(0);
            list.add("NA");
            list.add(0);
            list.add(0);
            list.add(0);
            String[] colocs = Manager3DColoc.getColoc(objA, object3DListB);
            if (colocs.length > 0) {
                list.set(4, Float.valueOf(Float.parseFloat(colocs[0])));
                list.set(5, colocs[1]);
                list.set(6, Integer.parseInt(colocs[2]));
                list.set(7, Double.parseDouble(colocs[3]));
                list.set(8, 100.0 * Double.parseDouble(colocs[3]) / objA.size());
                if (colocs.length > 4) {
                    maxObj.set(Math.max(colocs.length / 4, maxObj.get()));
                    for (int i = 4; i < colocs.length; i += 4) {
                        list.add(Float.valueOf(Float.parseFloat(colocs[i])));
                        list.add(colocs[i]);
                        list.add(Integer.parseInt(colocs[2]));
                        list.add(Double.parseDouble(colocs[3]));
                        list.add(100.0 * Double.parseDouble(colocs[3]) / objA.size());
                    }
                }
            }
            map.put(objA, list);
            ai.incrementAndGet();
        });
        for (int i = 2; i <= maxObj.get(); ++i) {
            headings.add("O" + i);
            headings.add("N" + i);
            headings.add("T" + i);
            headings.add("V" + i);
            headings.add("P" + i);
        }
        Object[][] data = new Object[object3DListA.size()][headings.size()];
        for (int i = 0; i < object3DListA.size(); ++i) {
            Object3DInt objA2 = object3DListA.get(i);
            for (int j = 0; j < headings.size(); ++j) {
                Integer val = 0;
                if (j < ((List)map.get(objA2)).size()) {
                    val = ((List)map.get(objA2)).get(j);
                }
                data[i][j] = val;
            }
        }
        ResultsFrame tableResultsMeasure = new ResultsFrame("3D Coloc", headings.toArray(new String[0]), data, 1);
        tableResultsMeasure.setObjectsList(object3DListA);
        return tableResultsMeasure;
    }

    private static String[] getColoc(Object3DInt obj, List<Object3DInt> object3DList) {
        ArrayList values = new ArrayList();
        object3DList.forEach(obj2 -> {
            Measure2Colocalisation colocalisation = new Measure2Colocalisation(obj, obj2);
            double volume = colocalisation.getValue("ColocVolume");
            double pc = colocalisation.getValue("ColocRatio");
            if (volume > 0.0 && obj != obj2) {
                values.add(String.valueOf((double)obj2.getLabel()));
                values.add(obj2.getName());
                values.add(String.valueOf(obj2.getType()));
                values.add(String.valueOf(volume));
            }
        });
        return values.toArray(new String[0]);
    }
}

