/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins.Manager3D;

import ij.Prefs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mcib3d.geom2.Object3DInt;
import mcib3d.geom2.Objects3DIntPopulation;
import mcib3d.geom2.measurementsPopulation.MeasurePopulationDistance;
import mcib_plugins.Manager3D.DistancesOptions;
import mcib_plugins.Manager3D.ResultsFrame;

public class Manager3DDistances {
    public static ResultsFrame distances3D(List<Object3DInt> object3DListA, List<Object3DInt> object3DListB, double distMax) {
        if (object3DListA == null || object3DListB == null) {
            return null;
        }
        Objects3DIntPopulation populationA = new Objects3DIntPopulation();
        object3DListA.forEach(arg_0 -> ((Objects3DIntPopulation)populationA).addObject(arg_0));
        Objects3DIntPopulation populationB = new Objects3DIntPopulation();
        object3DListB.forEach(arg_0 -> ((Objects3DIntPopulation)populationB).addObject(arg_0));
        String distMethod = DistancesOptions.distMethods[(int)Prefs.get((String)"RoiManager3D-V3-Options_DistMethod.int", (double)0.0)];
        MeasurePopulationDistance populationDistance = new MeasurePopulationDistance(populationA, populationB, distMax, distMethod);
        ArrayList<String> headings = new ArrayList<String>();
        headings.add("Nb");
        headings.add("Name");
        headings.add("Label");
        headings.add("Type");
        HashMap map = new HashMap();
        int maxObj = 1;
        int c = 1;
        for (Object3DInt objA : object3DListA) {
            ArrayList<Object> list = new ArrayList<Object>();
            double[] distCC = populationDistance.getValuesObject1Sorted(objA.getLabel(), true);
            maxObj = Math.max(maxObj, distCC.length / 3);
            list.add(c++);
            list.add(objA.getName());
            list.add(Float.valueOf(objA.getLabel()));
            list.add(objA.getType());
            for (int i = 0; i < distCC.length; i += 3) {
                Object3DInt objB = populationB.getObjectByLabel((float)distCC[i + 1]);
                list.add(Float.valueOf(objB.getLabel()));
                list.add(objB.getName());
                list.add(objB.getType());
                list.add(distCC[i + 2]);
            }
            map.put(objA, list);
        }
        for (int i = 1; i <= maxObj; ++i) {
            headings.add("O" + i);
            headings.add("N" + i);
            headings.add("T" + i);
            headings.add("D" + i);
        }
        Object[][] data = new Object[object3DListA.size()][headings.size()];
        for (int i = 0; i < object3DListA.size(); ++i) {
            Object3DInt objA = object3DListA.get(i);
            for (int j = 0; j < headings.size(); ++j) {
                Integer val = 0;
                if (j < ((List)map.get(objA)).size()) {
                    val = ((List)map.get(objA)).get(j);
                }
                data[i][j] = val;
            }
        }
        ResultsFrame tableResultsMeasure = new ResultsFrame("3D Distances", headings.toArray(new String[0]), data, 1);
        tableResultsMeasure.setObjectsList(object3DListA);
        return tableResultsMeasure;
    }
}

