/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins.Manager3D;

import ij.Prefs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import mcib3d.geom2.Object3DInt;
import mcib3d.geom2.measurements.MeasureCentroid;
import mcib3d.geom2.measurements.MeasureCompactness;
import mcib3d.geom2.measurements.MeasureDistancesCenter;
import mcib3d.geom2.measurements.MeasureEllipsoid;
import mcib3d.geom2.measurements.MeasureFeret;
import mcib3d.geom2.measurements.MeasureIntensity;
import mcib3d.geom2.measurements.MeasureIntensityHist;
import mcib3d.geom2.measurements.MeasureObject;
import mcib3d.geom2.measurements.MeasureSurface;
import mcib3d.geom2.measurements.MeasureVolume;
import mcib3d.image3d.ImageHandler;
import mcib_plugins.Manager3D.ResultsFrame;

public class Manager3DMeasurements {
    public static ResultsFrame measurements3D(List<Object3DInt> object3DList) {
        if (object3DList == null) {
            return null;
        }
        ArrayList<String> headings = new ArrayList<String>();
        headings.add("Nb");
        headings.add("Name");
        headings.add("Label");
        headings.add("Type");
        ArrayList headingsMeasure = new ArrayList();
        if (Prefs.get((String)"RoiManager3D-V3-Options_centroid.boolean", (boolean)false)) {
            Collections.addAll(headingsMeasure, new MeasureCentroid().getNamesMeasurement());
        }
        if (Prefs.get((String)"RoiManager3D-V3-Options_volume.boolean", (boolean)true)) {
            Collections.addAll(headingsMeasure, new MeasureVolume().getNamesMeasurement());
        }
        if (Prefs.get((String)"RoiManager3D-V3-Options_surface.boolean", (boolean)false)) {
            Collections.addAll(headingsMeasure, new MeasureSurface().getNamesMeasurement());
        }
        if (Prefs.get((String)"RoiManager3D-V3-Options_compactness.boolean", (boolean)false)) {
            Collections.addAll(headingsMeasure, new MeasureCompactness().getNamesMeasurement());
        }
        if (Prefs.get((String)"RoiManager3D-V3-Options_feret.boolean", (boolean)false)) {
            Collections.addAll(headingsMeasure, new MeasureFeret().getNamesMeasurement());
        }
        if (Prefs.get((String)"RoiManager3D-V3-Options_ellipse.boolean", (boolean)false)) {
            Collections.addAll(headingsMeasure, new MeasureEllipsoid().getNamesMeasurement());
        }
        if (Prefs.get((String)"RoiManager3D-V3-Options_dist2Surf.boolean", (boolean)false)) {
            Collections.addAll(headingsMeasure, new MeasureDistancesCenter().getNamesMeasurement());
        }
        List<String> finalHeadings = headingsMeasure.stream().filter(h -> !h.equalsIgnoreCase("labelobj")).collect(Collectors.toList());
        Object[][] data = new Object[object3DList.size()][headings.size() + finalHeadings.size()];
        int i = 0;
        while (i < object3DList.size()) {
            Object3DInt obj = object3DList.get(i);
            data[i][0] = i;
            data[i][1] = obj.getName();
            data[i][2] = Float.valueOf(obj.getLabel());
            data[i][3] = obj.getType();
            MeasureObject measureObject = new MeasureObject(obj);
            int ii = i++;
            AtomicInteger ai = new AtomicInteger(4);
            AtomicInteger aim = new AtomicInteger(0);
            Double[] measurements = measureObject.measureList(finalHeadings.toArray(new String[0]));
            finalHeadings.forEach(h -> {
                data[ii][ai.getAndIncrement()] = measurements[aim.getAndIncrement()];
            });
        }
        String[] heads = new String[headings.size() + finalHeadings.size()];
        headings.addAll(finalHeadings);
        heads = headings.toArray(heads);
        ResultsFrame tableResultsMeasure = new ResultsFrame("3D Measure", heads, data, 1);
        tableResultsMeasure.setObjectsList(object3DList);
        return tableResultsMeasure;
    }

    public static ResultsFrame quantif3D(List<Object3DInt> object3DList, ImageHandler ima) {
        ArrayList<String> headings = new ArrayList<String>();
        headings.add("Nb");
        headings.add("Name");
        headings.add("Label");
        headings.add("Type");
        ArrayList headingsMeasure = new ArrayList();
        if (Prefs.get((String)"RoiManager3D-V3-Options_Intensity.boolean", (boolean)true)) {
            Collections.addAll(headingsMeasure, new MeasureIntensity().getNamesMeasurement());
        }
        if (Prefs.get((String)"RoiManager3D-V3-Options_Intensity-hist.boolean", (boolean)true)) {
            Collections.addAll(headingsMeasure, new MeasureIntensityHist().getNamesMeasurement());
        }
        List<String> finalHeadings = headingsMeasure.stream().filter(h -> !h.equalsIgnoreCase("labelobj")).collect(Collectors.toList());
        Object[][] data = new Object[object3DList.size()][headings.size() + finalHeadings.size()];
        int i = 0;
        while (i < object3DList.size()) {
            Object3DInt obj = object3DList.get(i);
            data[i][0] = i;
            data[i][1] = obj.getName();
            data[i][2] = Float.valueOf(obj.getLabel());
            data[i][3] = obj.getType();
            int ii = i++;
            AtomicInteger ai = new AtomicInteger(4);
            MeasureObject measureObject = new MeasureObject(obj);
            finalHeadings.forEach(h -> {
                data[ii][ai.getAndIncrement()] = measureObject.measureIntensity(h, ima);
            });
        }
        String[] heads = new String[headings.size() + finalHeadings.size()];
        headings.addAll(finalHeadings);
        heads = headings.toArray(heads);
        return new ResultsFrame("3D Quantif", heads, data, 1);
    }
}

