/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins.Manager3D;

import ij.IJ;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import mcib3d.geom2.Object3DInt;
import mcib_plugins.Manager3D.ResultsTableModel;
import mcib_plugins.Manager3D.RoiManager3D_3;

public class ResultsFrame
extends JFrame
implements ActionListener {
    public static final int OBJECT_NO = 0;
    public static final int OBJECT_1 = 1;
    public static final int OBJECTS_2 = 2;
    private final String[] columnNames;
    private final Object[][] data;
    private RoiManager3D_3 manager;
    private ResultsTableModel model;
    private JTable tableResults;
    private int type = 0;
    private List<Object3DInt> listObjects;

    public ResultsFrame(String title, String[] columnNames, Object[][] data, RoiManager3D_3 manager, int type) throws HeadlessException {
        super(title);
        this.setDefaultCloseOperation(2);
        this.columnNames = columnNames;
        this.data = data;
        this.manager = manager;
        this.type = type;
        this.createGUI();
    }

    public ResultsFrame(String title, String[] columnNames, Object[][] data, int type) throws HeadlessException {
        super(title);
        this.setDefaultCloseOperation(2);
        this.columnNames = columnNames;
        this.data = data;
        this.type = type;
        this.createGUI();
    }

    public void setObjectsList(List<Object3DInt> list) {
        this.listObjects = list;
    }

    private void createGUI() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Menu");
        JMenuItem itemSave = new JMenuItem("Save");
        itemSave.addActionListener(this);
        menu.add(itemSave);
        JMenuItem itemSaveSel = new JMenuItem("Save Selection");
        itemSaveSel.addActionListener(this);
        menu.add(itemSaveSel);
        if (this.type != 0) {
            menu.add(new JSeparator());
        }
        if (this.type == 1) {
            JMenuItem itemList = new JMenuItem("Show Objects");
            itemList.addActionListener(this);
            menu.add(itemList);
        }
        if (this.type == 2) {
            JMenuItem itemList1 = new JMenuItem("Show Objects 1");
            itemList1.addActionListener(this);
            menu.add(itemList1);
            JMenuItem itemList2 = new JMenuItem("Show Objects 2");
            itemList2.addActionListener(this);
            menu.add(itemList2);
            JMenuItem itemList12 = new JMenuItem("Show Objects Pairs");
            itemList12.addActionListener(this);
            menu.add(itemList12);
        }
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
    }

    public void setManager(RoiManager3D_3 manager) {
        this.manager = manager;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equalsIgnoreCase("save")) {
            JFileChooser fd = new JFileChooser();
            int userSelection = fd.showSaveDialog(this);
            if (userSelection == 0) {
                File file = fd.getSelectedFile();
                this.model.writeData(file.getAbsolutePath());
            }
        } else if (ae.getActionCommand().equalsIgnoreCase("save selection")) {
            int[] rows = this.tableResults.getSelectedRows();
            int[] sels = new int[rows.length];
            int c = 0;
            for (int i : rows) {
                sels[c++] = this.tableResults.convertRowIndexToModel(i);
            }
            JFileChooser fd = new JFileChooser();
            int userSelection = fd.showSaveDialog(this);
            if (userSelection == 0) {
                File file = fd.getSelectedFile();
                this.model.writeDataSelected(file.getAbsolutePath(), sels);
            }
        } else if (ae.getActionCommand().equalsIgnoreCase("show objects")) {
            int[] sels = this.tableResults.getSelectedRows();
            int[] rows = new int[sels.length];
            IJ.log((String)("Showing " + sels.length + " selected objects "));
            int c = 0;
            for (int i : sels) {
                int row = this.tableResults.convertRowIndexToModel(i);
                rows[c++] = Integer.parseInt(this.model.getValueAt(row, 0).toString()) - 1;
                System.out.println("Selecting object " + this.listObjects.get(row).getName());
            }
            this.manager.selectByNumbers(rows);
        } else if (ae.getActionCommand().equalsIgnoreCase("show objects 1")) {
            int[] sels = this.tableResults.getSelectedRows();
            int[] rows = new int[sels.length];
            int c = 0;
            for (int i : sels) {
                int row = this.tableResults.convertRowIndexToModel(i);
                rows[c++] = Integer.parseInt(this.model.getValueAt(row, 1).toString()) - 1;
            }
            this.manager.selectByNumbers(rows);
        } else if (ae.getActionCommand().equalsIgnoreCase("show objects 2")) {
            int[] sels = this.tableResults.getSelectedRows();
            int[] rows = new int[sels.length];
            int c = 0;
            for (int i : sels) {
                int row = this.tableResults.convertRowIndexToModel(i);
                rows[c++] = Integer.parseInt(this.model.getValueAt(row, 2).toString()) - 1;
            }
            this.manager.selectByNumbers(rows);
        } else if (ae.getActionCommand().equalsIgnoreCase("show objects pairs")) {
            int[] sels = this.tableResults.getSelectedRows();
            int[] rows = new int[2 * sels.length];
            int c = 0;
            for (int i : sels) {
                int row = this.tableResults.convertRowIndexToModel(i);
                rows[c++] = Integer.parseInt(this.model.getValueAt(row, 1).toString()) - 1;
                rows[c++] = Integer.parseInt(this.model.getValueAt(row, 2).toString()) - 1;
            }
            this.manager.selectByNumbers(rows);
        }
    }

    public void showFrame() {
        JPanel tableResultsMeasure = new JPanel(new GridLayout(1, 0));
        tableResultsMeasure.setOpaque(true);
        this.model = new ResultsTableModel(this.columnNames, this.data);
        this.tableResults = new JTable(this.model);
        this.tableResults.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.tableResults.setFillsViewportHeight(true);
        this.tableResults.setAutoCreateRowSorter(true);
        this.tableResults.setAutoResizeMode(0);
        JScrollPane scrollPane = new JScrollPane(this.tableResults);
        tableResultsMeasure.add(scrollPane);
        this.setContentPane(tableResultsMeasure);
        this.pack();
        this.setVisible(true);
    }

    public ResultsTableModel getModel() {
        return this.model;
    }
}

