/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins.Manager3D;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;

public class ResultsTableModel
extends AbstractTableModel {
    private final String[] columnNames;
    private final Object[][] data;
    private final String delimiter = ",";

    public ResultsTableModel(String[] columnNames, Object[][] data) {
        this.columnNames = columnNames;
        this.data = data;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.data[row][col] = value;
    }

    public boolean writeData(String fileName) {
        String name = fileName;
        if (!name.contains(".")) {
            name = name.concat(".csv");
        }
        try {
            BufferedWriter buf = new BufferedWriter(new FileWriter(name));
            int numRows = this.getRowCount();
            int numCols = this.getColumnCount();
            for (String col : this.columnNames) {
                buf.write(col + ",");
            }
            buf.write("\n");
            for (int i = 0; i < numRows; ++i) {
                for (int j = 0; j < numCols; ++j) {
                    buf.write(this.data[i][j] + ",");
                }
                buf.write("\n");
            }
            buf.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ResultsTableModel.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        catch (IOException ex) {
            Logger.getLogger(ResultsTableModel.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        return true;
    }

    public void writeDataSelected(String fileName, int[] rows) {
        String name = fileName;
        if (!name.contains(".")) {
            name = name.concat(".csv");
        }
        try {
            BufferedWriter buf = new BufferedWriter(new FileWriter(name));
            for (String col : this.columnNames) {
                buf.write(col + ",");
            }
            buf.write("\n");
            int numCols = this.getColumnCount();
            for (int i : rows) {
                for (int j = 0; j < numCols; ++j) {
                    buf.write(this.data[i][j] + ",");
                }
                buf.write("\n");
            }
            buf.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ResultsTableModel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ResultsTableModel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

