/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins.Manager3D;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.gui.YesNoCancelDialog;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.plugin.Duplicator;
import ij.plugin.PlugIn;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import mcib3d.geom2.Object3DComputation;
import mcib3d.geom2.Object3DInt;
import mcib3d.geom2.Object3DIntLabelImage;
import mcib3d.geom2.Objects3DIntPopulation;
import mcib3d.image3d.ImageHandler;
import mcib3d.utils.AboutMCIB;
import mcib_plugins.Manager3D.ColocOptions;
import mcib_plugins.Manager3D.Create3DRoi;
import mcib_plugins.Manager3D.DistancesOptions;
import mcib_plugins.Manager3D.ExportOptions;
import mcib_plugins.Manager3D.ExportToImage;
import mcib_plugins.Manager3D.Fill3DStack;
import mcib_plugins.Manager3D.Fill3DViewer;
import mcib_plugins.Manager3D.GeometryOptions;
import mcib_plugins.Manager3D.ImportImage;
import mcib_plugins.Manager3D.ImportOptions;
import mcib_plugins.Manager3D.IntensityOptions;
import mcib_plugins.Manager3D.Manager3DColoc;
import mcib_plugins.Manager3D.Manager3DDistances;
import mcib_plugins.Manager3D.Manager3DMeasurements;
import mcib_plugins.Manager3D.ObjectCellRenderer;
import mcib_plugins.Manager3D.ResultsFrame;
import mcib_plugins.Manager3D.RoiOptions;
import mcib_plugins.Manager3D.Rois3D;

public class RoiManager3D_3
extends JFrame
implements PlugIn,
AdjustmentListener,
MouseWheelListener {
    private static int nbImport = 0;
    private final Map<Object3DInt, Rois3D> objectRoi = new HashMap<Object3DInt, Rois3D>();
    protected DefaultListModel<Object3DInt> modelListObjects = new DefaultListModel();
    Fill3DViewer fill3DViewer = new Fill3DViewer();
    private JPanel contentPane;
    private JList listUI;
    private JButton importButton1;
    private JLabel labelSelect;
    private JButton deleteButton;
    private JButton renameButton;
    private JButton splitButton;
    private JButton mergeButton;
    private JButton intensityButton;
    private JButton geometryButton;
    private JButton distancesButton;
    private JButton selectNoneButton;
    private JButton selectAllButton;
    private JButton colocalisationButton;
    private JButton a3DViewerButton;
    private JButton fillStackButton;
    private JButton updateRoiButton;
    private JRadioButton liveRoiRadioButton;
    private JButton loadButton;
    private JButton saveButton;
    private JLabel LabelNbObjects;
    private JButton exportButton;
    private JButton resetLabelsButton;
    private JButton fixObjectsButton;
    private JTextField textFieldLabelObj;
    private JSpinner spinnerType;
    private ResultsFrame tableResultsMeasure;
    private ResultsFrame tableResultsQuantif;
    private boolean liveRoi = false;
    private ImagePlus currentImage = null;

    public RoiManager3D_3() {
        this.$$$setupUI$$$();
        this.setContentPane(this.contentPane);
        TitledBorder border = BorderFactory.createTitledBorder("3D MANAGER " + AboutMCIB.getVERSION());
        this.contentPane.setBorder(border);
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        TitledBorder title = BorderFactory.createTitledBorder(loweredetched, "3D Manager " + AboutMCIB.getVERSION());
        title.setTitleJustification(1);
        this.contentPane.setBorder(title);
        this.listUI.setModel(this.modelListObjects);
        this.listUI.setCellRenderer(new ObjectCellRenderer());
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(0, 0, 9, 1);
        this.spinnerType.setModel(spinnerModel);
        this.listUI.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                String key = String.valueOf(ke.getKeyChar());
                if (!(key.equalsIgnoreCase("0") || key.equalsIgnoreCase("1") || key.equalsIgnoreCase("2") || key.equalsIgnoreCase("3") || key.equalsIgnoreCase("4") || key.equalsIgnoreCase("5") || key.equalsIgnoreCase("6") || key.equalsIgnoreCase("7") || key.equalsIgnoreCase("8") || key.equalsIgnoreCase("9"))) {
                    return;
                }
                for (Object3DInt object3DInt : RoiManager3D_3.this.getSelectedObjects3DList()) {
                    object3DInt.setType(Integer.parseInt(key));
                }
                RoiManager3D_3.this.listUI.updateUI();
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RoiManager3D_3.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(e -> this.onCancel(), KeyStroke.getKeyStroke(27, 0), 1);
        this.importButton1.addActionListener(actionEvent -> {
            Objects3DIntPopulation population1 = new ImportImage(ImageHandler.wrap((ImagePlus)this.getImageAsStack())).importImage();
            this.addPopulation(population1);
        });
        this.importButton1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (SwingUtilities.isRightMouseButton(e)) {
                    ImportOptions dialog = new ImportOptions();
                    dialog.pack();
                    dialog.setSize(400, 300);
                    dialog.setVisible(true);
                }
            }
        });
        this.loadButton.addActionListener(actionEvent -> this.load());
        this.saveButton.addActionListener(actionEvent -> this.save());
        this.listUI.addListSelectionListener(listSelectionEvent -> {
            this.LabelNbObjects.setText("Nb objects: " + this.modelListObjects.size() + ", selected: " + this.listUI.getSelectedIndices().length);
            this.updateRoi();
        });
        this.renameButton.addActionListener(actionEvent -> this.rename(null));
        this.deleteButton.addActionListener(actionEvent -> this.delete());
        this.mergeButton.addActionListener(actionEvent -> this.merge());
        this.geometryButton.addActionListener(actionEvent -> this.measure3D());
        this.geometryButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (SwingUtilities.isRightMouseButton(e)) {
                    GeometryOptions dialog = new GeometryOptions();
                    dialog.pack();
                    dialog.setVisible(true);
                }
            }
        });
        this.intensityButton.addActionListener(actionEvent -> this.intensity3D());
        this.intensityButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (SwingUtilities.isRightMouseButton(e)) {
                    IntensityOptions dialog = new IntensityOptions();
                    dialog.pack();
                    dialog.setVisible(true);
                }
            }
        });
        this.selectAllButton.addActionListener(e -> this.selectAll());
        this.selectNoneButton.addActionListener(e -> this.listUI.clearSelection());
        this.liveRoiRadioButton.addActionListener(e -> {
            this.liveRoi = this.liveRoiRadioButton.isSelected();
            if (this.liveRoi) {
                this.registerActiveImage();
            } else {
                ImagePlus plus = this.getCurrentImage();
                Overlay overlay = plus.getOverlay();
                if (overlay != null) {
                    overlay.clear();
                }
                plus.updateAndDraw();
            }
        });
        this.updateRoiButton.addActionListener(e -> {
            IJ.log((String)"Computing roi started ...");
            this.updateRoiButton.setEnabled(false);
            for (int i = 0; i < this.modelListObjects.size(); ++i) {
                Object3DInt obj = this.modelListObjects.getElementAt(i);
                IJ.log((String)("\\Update: computing roi " + i + "   "));
                Rois3D rois = Create3DRoi.computeRois(obj);
                this.objectRoi.put(obj, rois);
            }
            IJ.log((String)"Computing roi finished");
            this.updateRoiButton.setEnabled(true);
        });
        this.updateRoiButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (SwingUtilities.isRightMouseButton(e)) {
                    RoiOptions dialog = new RoiOptions();
                    dialog.pack();
                    dialog.setSize(400, 300);
                    dialog.setVisible(true);
                }
            }
        });
        this.a3DViewerButton.addActionListener(actionEvent -> this.fill3DViewer.fill3DViewer(this.getSelectedObjects3DList()));
        this.fillStackButton.addActionListener(actionEvent -> new Fill3DStack().fill3DStack(this.getSelectedObjects3DList()));
        this.distancesButton.addActionListener(actionEvent -> this.distances());
        this.distancesButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (SwingUtilities.isRightMouseButton(e)) {
                    System.out.println("Distances option");
                    DistancesOptions dialog = new DistancesOptions();
                    dialog.pack();
                    dialog.setVisible(true);
                }
            }
        });
        this.exportButton.addActionListener(e -> new ExportToImage().exportSelected(this.getSelectedObjects3DList()).forEach(ima -> ima.show()));
        this.exportButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (SwingUtilities.isRightMouseButton(e)) {
                    ExportOptions dialog = new ExportOptions();
                    dialog.pack();
                    dialog.setSize(400, 300);
                    dialog.setVisible(true);
                }
            }
        });
        this.resetLabelsButton.addActionListener(e -> {
            AtomicReference<Float> labelObject = new AtomicReference<Float>(Float.valueOf(0.0f));
            this.getSelectedObjects3DList().forEach(obj -> {
                float oldLabel = obj.getLabel();
                float label = ((Float)labelObject.updateAndGet(f -> Float.valueOf(f.floatValue() + 1.0f))).floatValue();
                obj.setLabel(label);
                if (obj.getName().endsWith("-" + oldLabel)) {
                    obj.setName(obj.getName().replace("-" + oldLabel, "-" + obj.getLabel()));
                }
                this.listUI.updateUI();
            });
        });
        this.fixObjectsButton.addActionListener(e -> {
            float maxLabel = this.getMaxLabel();
            AtomicReference<Float> label = new AtomicReference<Float>(Float.valueOf(maxLabel + 1.0f));
            this.getSelectedObjects3DList().forEach(obj -> {
                List connexList = new Object3DComputation(obj).getConnexComponents();
                if (connexList.size() > 1) {
                    this.modelListObjects.removeElement(obj);
                    for (Object3DInt object3DInt : connexList) {
                        object3DInt.setLabel(((Float)label.getAndUpdate(L -> Float.valueOf(L.floatValue() + 1.0f))).floatValue());
                        object3DInt.setName(obj.getName() + "-" + object3DInt.getLabel());
                        this.modelListObjects.addElement(object3DInt);
                    }
                }
            });
            this.listUI.updateUI();
        });
        this.colocalisationButton.addActionListener(e -> this.coloc3D());
        this.colocalisationButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (SwingUtilities.isRightMouseButton(e)) {
                    ColocOptions dialog = new ColocOptions();
                    dialog.pack();
                    dialog.setSize(400, 300);
                    dialog.setVisible(true);
                }
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                e.getWindow().dispose();
                RoiManager3D_3.super.dispose();
                nbImport = 0;
                System.out.println("RoiManager3D closed!");
            }
        });
        this.textFieldLabelObj.addActionListener(actionEvent -> {
            float labelObj = Float.parseFloat(this.textFieldLabelObj.getText().trim());
            this.selectByLabel(labelObj);
        });
    }

    public static void main(String[] args) throws UnsupportedLookAndFeelException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            throw new RuntimeException(e);
        }
        RoiManager3D_3 dialog = new RoiManager3D_3();
        dialog.pack();
        dialog.setVisible(true);
    }

    private boolean distances() {
        double distMax = 50.0;
        if (Prefs.get((String)"RoiManager3D-V3-Options_DistChoice.int", (double)0.0) == 0.0) {
            List<Object3DInt> object3DInts = this.getSelectedObjects3DList();
            this.tableResultsMeasure = Manager3DDistances.distances3D(object3DInts, object3DInts, distMax);
        } else {
            int typeA = (int)Prefs.get((String)"RoiManager3D-V3-Options_DistA.int", (double)1.0);
            List<Object3DInt> objectsA = this.getSelectedType(typeA);
            int typeB = (int)Prefs.get((String)"RoiManager3D-V3-Options_DistB.int", (double)2.0);
            List<Object3DInt> objectsB = this.getSelectedType(typeB);
            this.tableResultsMeasure = Manager3DDistances.distances3D(objectsA, objectsB, distMax);
        }
        if (this.tableResultsMeasure == null) {
            return false;
        }
        this.tableResultsMeasure.setManager(this);
        this.tableResultsMeasure.showFrame();
        return true;
    }

    private ImagePlus getCurrentImage() {
        return WindowManager.getCurrentImage();
    }

    private float getMaxLabel() {
        float maxLabel = 0.0f;
        for (int i = 0; i < this.modelListObjects.size(); ++i) {
            float label = this.modelListObjects.get(i).getLabel();
            if (!(label > maxLabel)) continue;
            maxLabel = label;
        }
        return maxLabel;
    }

    private ImagePlus getImageAsStack() {
        ImagePlus imp = this.getCurrentImage();
        if (imp == null) {
            return null;
        }
        if (imp.isHyperStack()) {
            int channel = imp.getChannel();
            int frame = imp.getFrame();
            IJ.log((String)("Duplicating HyperStack : C-" + channel + " T-" + frame));
            Roi roi = imp.getRoi();
            imp.killRoi();
            Duplicator duplicator = new Duplicator();
            ImagePlus duplicate = duplicator.run(imp, channel, channel, 1, imp.getNSlices(), frame, frame);
            duplicate.setRoi(roi);
            return duplicate;
        }
        return imp;
    }

    private boolean intensity3D() {
        this.tableResultsQuantif = Manager3DMeasurements.quantif3D(this.getSelectedObjects3DList(), ImageHandler.wrap((ImagePlus)this.getImageAsStack()));
        this.tableResultsQuantif.setManager(this);
        this.tableResultsQuantif.showFrame();
        return true;
    }

    private boolean measure3D() {
        this.tableResultsMeasure = Manager3DMeasurements.measurements3D(this.getSelectedObjects3DList());
        if (this.tableResultsMeasure == null) {
            return false;
        }
        this.tableResultsMeasure.setManager(this);
        this.tableResultsMeasure.showFrame();
        return true;
    }

    private boolean coloc3D() {
        if (Prefs.get((String)"RoiManager3D-V3-Options_ColocChoice.int", (double)0.0) == 0.0) {
            List<Object3DInt> object3DInts = this.getSelectedObjects3DList();
            this.tableResultsMeasure = Manager3DColoc.coloc3D(object3DInts, object3DInts);
        } else {
            int typeA = (int)Prefs.get((String)"RoiManager3D-V3-Options_ColocA.int", (double)1.0);
            List<Object3DInt> objectsA = this.getSelectedType(typeA);
            int typeB = (int)Prefs.get((String)"RoiManager3D-V3-Options_ColocB.int", (double)1.0);
            List<Object3DInt> objectsB = this.getSelectedType(typeB);
            this.tableResultsMeasure = Manager3DColoc.coloc3D(objectsA, objectsB);
        }
        if (this.tableResultsMeasure == null) {
            return false;
        }
        this.tableResultsMeasure.setManager(this);
        this.tableResultsMeasure.showFrame();
        return true;
    }

    public void selectAll() {
        int type = Integer.parseInt(this.spinnerType.getValue().toString());
        if (type == 0) {
            this.listUI.setSelectionInterval(0, this.modelListObjects.getSize() - 1);
        } else {
            ArrayList<Integer> typeObjs = new ArrayList<Integer>();
            for (int i = 0; i < this.modelListObjects.size(); ++i) {
                if (this.modelListObjects.get(i).getType() != type) continue;
                typeObjs.add(i);
            }
            int[] select = new int[typeObjs.size()];
            for (int i = 0; i < typeObjs.size(); ++i) {
                select[i] = (Integer)typeObjs.get(i);
            }
            this.selectByNumbers(select);
        }
    }

    public void deselect() {
        int type = (Integer)this.spinnerType.getValue();
        if (type == 0) {
            this.listUI.clearSelection();
        } else {
            ArrayList<Integer> typeObjs = new ArrayList<Integer>();
            int[] selected = this.listUI.getSelectedIndices();
            for (int i = 0; i < selected.length; ++i) {
                if (this.modelListObjects.get(selected[i]).getType() == type) continue;
                typeObjs.add(i);
            }
            int[] select = new int[typeObjs.size()];
            for (int i = 0; i < typeObjs.size(); ++i) {
                select[i] = (Integer)typeObjs.get(i);
            }
            this.selectByNumbers(select);
        }
    }

    public void selectByNumbers(int[] se) {
        this.listUI.clearSelection();
        for (int i : se) {
            this.listUI.addSelectionInterval(i, i);
        }
        this.listUI.updateUI();
    }

    public void selectByLabel(float label) {
        int type = (Integer)this.spinnerType.getValue();
        for (int i = 0; i < this.modelListObjects.size(); ++i) {
            Object3DInt object3DInt = this.modelListObjects.get(i);
            if (type == 0) {
                if (object3DInt.getLabel() != label) continue;
                if (this.listUI.isSelectedIndex(i)) {
                    this.listUI.removeSelectionInterval(i, i);
                    continue;
                }
                this.listUI.addSelectionInterval(i, i);
                continue;
            }
            if (object3DInt.getLabel() != label || object3DInt.getType() != type) continue;
            if (this.listUI.isSelectedIndex(i)) {
                this.listUI.removeSelectionInterval(i, i);
                continue;
            }
            this.listUI.addSelectionInterval(i, i);
        }
        this.listUI.updateUI();
    }

    private List<Object3DInt> getSelectedObjects3DList() {
        ArrayList<Object3DInt> object3DS = new ArrayList<Object3DInt>();
        int[] indexes = this.listUI.getSelectedIndices();
        if (indexes.length == 0) {
            for (Object o : this.modelListObjects.toArray()) {
                object3DS.add((Object3DInt)o);
            }
            return object3DS;
        }
        for (int index : indexes) {
            object3DS.add(this.modelListObjects.getElementAt(index));
        }
        return object3DS;
    }

    private List<Object3DInt> getSelectedType(int type) {
        return this.getSelectedObjects3DList().stream().filter(o -> o.getType() == type).collect(Collectors.toList());
    }

    private void save() {
        SaveDialog op = new SaveDialog("Save RoiSet3D", "population-3droi", ".zip");
        Objects3DIntPopulation popSave = new Objects3DIntPopulation();
        Arrays.stream(this.listUI.getSelectedIndices()).forEach(ind -> popSave.addObject(this.modelListObjects.getElementAt(ind)));
        popSave.saveObjects(op.getDirectory() + op.getFileName());
        popSave.getObjects3DInt().forEach(arg_0 -> ((Objects3DIntPopulation)popSave).removeObject(arg_0));
    }

    private void load() {
        OpenDialog op = new OpenDialog("Open RoiSet3D", "");
        Objects3DIntPopulation population1 = new Objects3DIntPopulation();
        this.loadButton.setEnabled(false);
        this.loadButton.setText("Loading");
        Thread thread = new Thread(() -> {
            population1.loadObjects(op.getDirectory() + op.getFileName());
            this.addPopulation(population1);
            SwingUtilities.invokeLater(() -> {
                this.listUI.updateUI();
                this.loadButton.setEnabled(true);
                this.loadButton.setText("Load");
            });
        });
        thread.start();
    }

    private void addPopulation(Objects3DIntPopulation population1) {
        IJ.log((String)("Adding " + population1.getNbObjects() + " objects for import/load " + ++nbImport));
        population1.getObjects3DInt().stream().sorted(Comparator.comparing(Object3DInt::getLabel)).forEach(o -> {
            o.setType(nbImport);
            this.modelListObjects.addElement((Object3DInt)o);
        });
        this.listUI.updateUI();
        this.LabelNbObjects.setText("Nb objects: " + this.modelListObjects.size() + ", selected: " + this.listUI.getSelectedIndices().length);
    }

    private boolean rename(String name2) {
        int[] indices = this.listUI.getSelectedIndices();
        if (name2 == null) {
            name2 = IJ.getString((String)"New name", (String)"Name");
        }
        if (indices.length == 1) {
            this.modelListObjects.getElementAt(indices[0]).setName(name2);
        } else {
            int c = 1;
            for (int i : indices) {
                this.modelListObjects.getElementAt(i).setName(name2 + c);
                ++c;
            }
        }
        this.listUI.updateUI();
        return true;
    }

    private boolean delete() {
        int count = this.modelListObjects.getSize();
        if (count == 0) {
            return false;
        }
        int[] index = this.listUI.getSelectedIndices();
        if (index.length == 0 || index.length == this.listUI.getModel().getSize()) {
            YesNoCancelDialog d;
            String msg = "Remove all objects ?";
            if (!(IJ.macroRunning() || IJ.isMacro() || !(d = new YesNoCancelDialog((Frame)this, "Manager3D", msg)).cancelPressed() && d.yesPressed())) {
                return false;
            }
            this.modelListObjects.removeAllElements();
            this.LabelNbObjects.setText("Nb objects: " + this.modelListObjects.size() + ", selected: " + this.listUI.getSelectedIndices().length);
            this.listUI.updateUI();
            return true;
        }
        for (int i = index.length - 1; i >= 0; --i) {
            this.modelListObjects.removeElementAt(index[i]);
        }
        this.LabelNbObjects.setText("Nb objects: " + this.modelListObjects.size() + ", selected: " + this.listUI.getSelectedIndices().length);
        this.listUI.updateUI();
        return true;
    }

    private boolean merge() {
        int[] indexes = this.listUI.getSelectedIndices();
        int le = indexes.length;
        Object3DInt obj0 = this.modelListObjects.getElementAt(indexes[0]);
        LinkedList<Object3DInt> others = new LinkedList<Object3DInt>();
        for (int i = 1; i < le; ++i) {
            others.add(this.modelListObjects.getElementAt(indexes[i]));
        }
        ImageHandler label = new Object3DIntLabelImage(obj0).getLabelImage(1.0f);
        for (Object3DInt other : others) {
            other.drawObject(label, 1.0f);
        }
        Object3DInt union = new Object3DInt(label);
        union.setLabel(obj0.getLabel());
        union.setName("Merged-" + union.getLabel());
        for (int i = le - 1; i >= 0; --i) {
            this.modelListObjects.removeElementAt(indexes[i]);
        }
        this.modelListObjects.addElement(union);
        this.listUI.updateUI();
        this.LabelNbObjects.setText("Nb objects: " + this.modelListObjects.size() + ", selected: " + this.listUI.getSelectedIndices().length);
        return true;
    }

    private int[] getAllIndices() {
        int count = this.modelListObjects.getSize();
        int[] indexes = new int[count];
        for (int i = 0; i < count; ++i) {
            indexes[i] = i;
        }
        return indexes;
    }

    private void onCancel() {
        if (this.liveRoi) {
            this.getCurrentImage().setHideOverlay(true);
        }
        this.dispose();
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new GridBagLayout());
        this.contentPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "3D Manager", 2, 2, null, new Color(-14998597)));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.contentPane.add((Component)panel1, gbc);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel1.add((Component)panel2, gbc);
        this.deleteButton = new JButton();
        this.deleteButton.setText("Delete");
        this.deleteButton.setToolTipText("Delete selected objects");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel2.add((Component)this.deleteButton, gbc);
        this.renameButton = new JButton();
        this.renameButton.setText("Rename");
        this.renameButton.setToolTipText("Rename selected objects");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel2.add((Component)this.renameButton, gbc);
        this.intensityButton = new JButton();
        this.intensityButton.setText("Intensity");
        this.intensityButton.setToolTipText("Current image intensity measurements of selected objects");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 10;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel2.add((Component)this.intensityButton, gbc);
        this.selectNoneButton = new JButton();
        this.selectNoneButton.setText("Select None");
        this.selectNoneButton.setToolTipText("Clear selection");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 15;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel2.add((Component)this.selectNoneButton, gbc);
        this.selectAllButton = new JButton();
        this.selectAllButton.setText("Select All");
        this.selectAllButton.setToolTipText("Select all objects");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 15;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel2.add((Component)this.selectAllButton, gbc);
        JSeparator separator1 = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel2.add((Component)separator1, gbc);
        JSeparator separator2 = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel2.add((Component)separator2, gbc);
        JSeparator separator3 = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 13;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel2.add((Component)separator3, gbc);
        this.mergeButton = new JButton();
        this.mergeButton.setText("Merge");
        this.mergeButton.setToolTipText("Merge selected objects");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel2.add((Component)this.mergeButton, gbc);
        this.geometryButton = new JButton();
        this.geometryButton.setText("Geometry");
        this.geometryButton.setToolTipText("Geometry measurements of selected objects");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 10;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel2.add((Component)this.geometryButton, gbc);
        this.distancesButton = new JButton();
        this.distancesButton.setText("Distances");
        this.distancesButton.setToolTipText("Not implemented yet");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 11;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel2.add((Component)this.distancesButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 11;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.colocalisationButton = new JButton();
        this.colocalisationButton.setText("Colocalisation");
        this.colocalisationButton.setToolTipText("Will compute colocalisation between pairs of selected objects");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 12;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel2.add((Component)this.colocalisationButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 12;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.a3DViewerButton = new JButton();
        this.a3DViewerButton.setText("3D Viewer");
        this.a3DViewerButton.setToolTipText("Fill 3D Viewer with selected objects using current pipette color");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 16;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel2.add((Component)this.a3DViewerButton, gbc);
        this.fillStackButton = new JButton();
        this.fillStackButton.setText("Fill Stack");
        this.fillStackButton.setToolTipText("Fill current image with selected objects using current color in pipette");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 16;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel2.add((Component)this.fillStackButton, gbc);
        JLabel label1 = new JLabel();
        label1.setText("Segment + Import");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        panel2.add((Component)label1, gbc);
        JLabel label2 = new JLabel();
        label2.setText("Edit");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        panel2.add((Component)label2, gbc);
        JLabel label3 = new JLabel();
        label3.setText("Measure");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 9;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        panel2.add((Component)label3, gbc);
        JLabel label4 = new JLabel();
        label4.setText("Select + Draw");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 14;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        panel2.add((Component)label4, gbc);
        this.updateRoiButton = new JButton();
        this.updateRoiButton.setText("Compute Roi");
        this.updateRoiButton.setToolTipText("Compute Rois for all objects  (can take some time, but need to do only once)");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 17;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel2.add((Component)this.updateRoiButton, gbc);
        this.liveRoiRadioButton = new JRadioButton();
        this.liveRoiRadioButton.setText("Live Roi");
        this.liveRoiRadioButton.setToolTipText("Display selected objects on current image (on/off to update on new image)");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 17;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        panel2.add((Component)this.liveRoiRadioButton, gbc);
        this.loadButton = new JButton();
        this.loadButton.setText("Load");
        this.loadButton.setToolTipText("Load a previously saved 3DRoi file");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel2.add((Component)this.loadButton, gbc);
        this.saveButton = new JButton();
        this.saveButton.setText("Save");
        this.saveButton.setToolTipText("Save selection as 3DRoi file");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel2.add((Component)this.saveButton, gbc);
        this.importButton1 = new JButton();
        this.importButton1.setText("Import");
        this.importButton1.setToolTipText("Get objects from current labelled image");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel2.add((Component)this.importButton1, gbc);
        this.exportButton = new JButton();
        this.exportButton.setText("Export");
        this.exportButton.setToolTipText("Export selected objects to a labelled image");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 2;
        panel2.add((Component)this.exportButton, gbc);
        this.splitButton = new JButton();
        this.splitButton.setText("Split");
        this.splitButton.setToolTipText("Not implemented yet");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel2.add((Component)this.splitButton, gbc);
        this.resetLabelsButton = new JButton();
        this.resetLabelsButton.setText("Reset Labels");
        this.resetLabelsButton.setToolTipText("Reset labels of selected objects 1,2,3 ...");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.fill = 2;
        panel2.add((Component)this.resetLabelsButton, gbc);
        this.fixObjectsButton = new JButton();
        this.fixObjectsButton.setText("Fix objects");
        this.fixObjectsButton.setToolTipText("Detect non-connex objects and split them");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.fill = 2;
        panel2.add((Component)this.fixObjectsButton, gbc);
        this.LabelNbObjects = new JLabel();
        this.LabelNbObjects.setText("Nb objects:0 , selected:0");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        panel1.add((Component)this.LabelNbObjects, gbc);
        JScrollPane scrollPane1 = new JScrollPane();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        panel1.add((Component)scrollPane1, gbc);
        this.listUI = new JList();
        scrollPane1.setViewportView(this.listUI);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    public void run(String s) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            throw new RuntimeException(e);
        }
        RoiManager3D_3 manager3D = new RoiManager3D_3();
        manager3D.pack();
        manager3D.setVisible(true);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.updateRoi();
    }

    public void updateRoi() {
        if (!this.liveRoi) {
            return;
        }
        ImagePlus plus = this.getCurrentImage();
        this.registerActiveImage();
        if (plus == null) {
            return;
        }
        int z = plus.getZ() - 1;
        plus.killRoi();
        Overlay overlay = plus.getOverlay();
        if (overlay == null) {
            overlay = new Overlay();
        }
        overlay.clear();
        for (int i : this.listUI.getSelectedIndices()) {
            Rois3D rois = this.objectRoi.get(this.modelListObjects.getElementAt(i));
            Roi roi = rois.getRoi(z);
            if (roi == null) continue;
            overlay.add(roi);
        }
        plus.setOverlay(overlay);
        plus.setHideOverlay(false);
        plus.updateAndDraw();
    }

    private void registerActiveImage() {
        ImagePlus activeImage = WindowManager.getCurrentImage();
        if (activeImage != null && activeImage.getProcessor() != null && activeImage.getImageStackSize() > 1) {
            if (this.currentImage != null && this.currentImage.getWindow() != null && this.currentImage != activeImage) {
                this.currentImage.killRoi();
                this.currentImage.updateAndDraw();
                this.currentImage = null;
            }
            if (this.currentImage != activeImage) {
                this.addScrollListener(activeImage, this, this);
                this.currentImage = activeImage;
            }
        }
    }

    private void addScrollListener(ImagePlus img, AdjustmentListener al, MouseWheelListener ml) {
        for (Component c : img.getWindow().getComponents()) {
            if (c instanceof Scrollbar) {
                ((Scrollbar)c).addAdjustmentListener(al);
                continue;
            }
            if (!(c instanceof Container)) continue;
            for (Component c2 : ((Container)c).getComponents()) {
                if (!(c2 instanceof Scrollbar)) continue;
                ((Scrollbar)c2).addAdjustmentListener(al);
            }
        }
        img.getWindow().addMouseWheelListener(ml);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.updateRoi();
    }
}

