/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins.Manager3D;

import ij.Prefs;
import mcib3d.geom2.Objects3DIntPopulation;
import mcib3d.geom2.Objects3DIntPopulationComputation;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageLabeller;

public class SegmentImage {
    ImageHandler image;

    public SegmentImage(ImageHandler image) {
        this.image = image;
    }

    public ImageHandler getLabelled() {
        ImageFloat seg;
        double min = Prefs.get((String)"RoiManager3D-V3-Options_MinSegment.double", (double)0.0);
        double max = Prefs.get((String)"RoiManager3D-V3-Options_MaxSegment.double", (double)-1.0);
        boolean excludeXY = Prefs.get((String)"RoiManager3D-V3-Options_excludeXY.boolean", (boolean)false);
        boolean excludeZ = Prefs.get((String)"RoiManager3D-V3-Options_excludeZ.boolean", (boolean)false);
        boolean seg32 = Prefs.get((String)"RoiManager3D-V3-Options_seg32.boolean", (boolean)false);
        if (max == -1.0) {
            max = Double.MAX_VALUE;
        }
        ImageLabeller labeller = new ImageLabeller(min, max);
        Object object = seg = seg32 ? labeller.getLabelsFloat(this.image) : labeller.getLabels(this.image);
        if (excludeXY || excludeZ) {
            Objects3DIntPopulation pop = new Objects3DIntPopulation((ImageHandler)seg);
            pop = new Objects3DIntPopulationComputation(pop).getExcludeBorders(this.image, excludeZ);
            ImageHandler draw = seg.createSameDimensions();
            pop.drawInImage(draw);
            return draw;
        }
        return seg;
    }
}

