/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.measure.ResultsTable;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.processing.MaximaFinder;

public class MaximaFinder3D_
implements PlugInFilter {
    ImagePlus plus;
    float minThreshold = 0.0f;
    float noise = 100.0f;
    float rxy = 1.5f;
    float rz = 1.5f;

    public int setup(String arg, ImagePlus imp) {
        this.plus = imp;
        return 13;
    }

    public void run(ImageProcessor ip) {
        if (this.dialog()) {
            ImageHandler img = ImageHandler.wrap((ImagePlus)this.plus);
            IJ.log((String)("Removing peaks below " + this.minThreshold));
            ImageHandler thresholded = img.duplicate();
            thresholded.thresholdCut(this.minThreshold, false, true);
            MaximaFinder maximaFinder = new MaximaFinder(thresholded, this.noise);
            maximaFinder.setRadii(this.rxy, this.rz);
            maximaFinder.getImagePeaks().show();
            ArrayList list = maximaFinder.getListPeaks();
            ResultsTable rt = ResultsTable.getResultsTable();
            if (rt == null) {
                rt = new ResultsTable();
            }
            rt.reset();
            for (Voxel3D V : list) {
                rt.incrementCounter();
                rt.addValue("X", V.getX());
                rt.addValue("Y", V.getY());
                rt.addValue("Z", V.getZ());
                rt.addValue("V", V.getValue());
            }
            rt.show("Results");
        }
    }

    private boolean dialog() {
        this.minThreshold = (float)Prefs.get((String)"mcib3d.maximafinder.minthreshold.double", (double)this.minThreshold);
        this.rxy = (float)Prefs.get((String)"mcib3d.maximafinder.radxy.double", (double)this.rxy);
        this.rz = (float)Prefs.get((String)"mcib3d.maximafinder.radz.double", (double)this.rz);
        this.noise = (float)Prefs.get((String)"mcib3d.maximafinder.noise.double", (double)this.noise);
        GenericDialog dia = new GenericDialog("Maxima Finder");
        dia.addNumericField("Minimmum Threshold", (double)this.minThreshold, 2);
        dia.addNumericField("RadiusXY", (double)this.rxy, 2, 5, "pixel");
        dia.addNumericField("RadiusZ", (double)this.rz, 2, 5, "pixel");
        dia.addNumericField("Noise", (double)this.noise, 2);
        dia.showDialog();
        this.minThreshold = (float)dia.getNextNumber();
        this.rxy = (float)dia.getNextNumber();
        this.rz = (float)dia.getNextNumber();
        this.noise = (float)dia.getNextNumber();
        Prefs.set((String)"mcib3d.maximafinder.minthreshold.double", (double)this.minThreshold);
        Prefs.set((String)"mcib3d.maximafinder.radxy.double", (double)this.rxy);
        Prefs.set((String)"mcib3d.maximafinder.radz.double", (double)this.rz);
        Prefs.set((String)"mcib3d.maximafinder.noise.double", (double)this.noise);
        return dia.wasOKed();
    }
}

