/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import mcib3d.geom.MereoAnalysisOld;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Objects3DPopulation;

public class Mereo_3D
implements PlugIn {
    public void run(String arg) {
        int nbima = WindowManager.getImageCount();
        if (nbima < 1) {
            IJ.error((String)"Needs at least one labelled image");
            return;
        }
        String[] namesA = new String[nbima];
        String[] namesB = new String[nbima];
        for (int i = 0; i < nbima; ++i) {
            namesA[i] = WindowManager.getImage((int)(i + 1)).getShortTitle();
            namesB[i] = WindowManager.getImage((int)(i + 1)).getShortTitle();
        }
        int idxA = 0;
        int idxB = nbima > 1 ? 1 : 0;
        float radXY = 1.0f;
        float radZ = 1.0f;
        GenericDialog dia = new GenericDialog("MereoTopology3D");
        dia.addChoice("Image_A", namesA, namesA[idxA]);
        dia.addChoice("Image_B", namesB, namesB[idxB]);
        dia.addNumericField("RadiusXY", (double)radXY, 1);
        dia.addNumericField("RadiusZ", (double)radZ, 1);
        dia.addCheckbox("Compute_regularity", false);
        dia.showDialog();
        if (dia.wasOKed()) {
            Object3DVoxels vox;
            idxA = dia.getNextChoiceIndex();
            idxB = dia.getNextChoiceIndex();
            radXY = (float)dia.getNextNumber();
            radZ = (float)dia.getNextNumber();
            boolean regularity = dia.getNextBoolean();
            ImagePlus plusA = WindowManager.getImage((int)(idxA + 1));
            ImagePlus plusB = WindowManager.getImage((int)(idxB + 1));
            Objects3DPopulation popA = new Objects3DPopulation(plusA);
            Objects3DPopulation popB = new Objects3DPopulation(plusB);
            for (int ia = 0; ia < popA.getNbObjects(); ++ia) {
                vox = (Object3DVoxels)popA.getObject(ia);
                if (vox.isConnex()) continue;
                IJ.log((String)("WARNING Object A" + ia + " : " + popA.getObject(ia) + " is not connex"));
            }
            for (int ib = 0; ib < popB.getNbObjects(); ++ib) {
                vox = (Object3DVoxels)popB.getObject(ib);
                if (vox.isConnex()) continue;
                IJ.log((String)("WARNING Object B" + ib + " : " + popB.getObject(ib) + " is not connex"));
            }
            MereoAnalysisOld mereo = new MereoAnalysisOld(popA, popB);
            mereo.setRadX(radXY);
            mereo.setRadY(radXY);
            mereo.setRadZ(radZ);
            mereo.computeFastRelationships();
            IJ.log((String)"MEREOTOPOLOGY RESULTS (DC if not specified)");
            IJ.log((String)mereo.getResults(true));
            ResultsTable rt = mereo.getResultsTable(true, true);
            rt.show("Mereo");
            IJ.log((String)"");
            if (regularity) {
                for (int ia = 0; ia < popA.getNbObjects(); ++ia) {
                    IJ.log((String)("Object A" + ia + " : " + popA.getObject(ia)));
                    this.unchangedMorpho(popA.getObject(ia), radXY, radXY, radZ);
                }
                IJ.log((String)"");
                for (int ib = 0; ib < popB.getNbObjects(); ++ib) {
                    IJ.log((String)("Object B" + ib + " : " + popB.getObject(ib)));
                    this.unchangedMorpho(popB.getObject(ib), radXY, radXY, radZ);
                }
            }
            IJ.log((String)"Finished");
        }
    }

    private void unchangedMorpho(Object3D object, float rx, float ry, float rz) {
        Object3DVoxels objectClosed = object.getClosedObject(rz, ry, rz);
        if (objectClosed.getVolumePixels() == object.getVolumePixels()) {
            IJ.log((String)("No change after closing radii " + rx + " " + ry + " " + rz));
        } else {
            IJ.log((String)("Change after closing radii " + rx + " " + ry + " " + rz + " of " + (objectClosed.getVolumePixels() - object.getVolumePixels()) + " voxels over " + object.getVolumePixels()));
        }
        Object3DVoxels objectOpened = object.getOpenedObject(rz, ry, rz);
        if (objectOpened.getVolumePixels() == object.getVolumePixels()) {
            IJ.log((String)("No change after opening radii " + rx + " " + ry + " " + rz));
        } else {
            IJ.log((String)("Change after opening radii " + rx + " " + ry + " " + rz + " of " + (object.getVolumePixels() - objectOpened.getVolumePixels()) + " voxels over " + object.getVolumePixels()));
        }
    }
}

