/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.ResultsTable;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.util.concurrent.atomic.AtomicInteger;
import mcib3d.geom2.Objects3DIntPopulation;
import mcib3d.geom2.measurements.MeasureNumbering;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImagePlus_Utils;

public class Numbering_
implements PlugInFilter {
    ImagePlus myPlus;
    int imaMain;
    int imaSignal;

    public int setup(String arg, ImagePlus imp) {
        return 5;
    }

    public void run(ImageProcessor ip) {
        if (this.Dialogue()) {
            this.myPlus = WindowManager.getImage((int)this.imaMain);
            int channel = this.myPlus.getChannel();
            int frame = this.myPlus.getFrame();
            String title = this.myPlus.getTitle();
            ImageHandler img = ImageHandler.wrap((ImagePlus)ImagePlus_Utils.extractCurrentStack((ImagePlus)this.myPlus));
            this.myPlus = WindowManager.getImage((int)this.imaSignal);
            ImageHandler spots = ImageHandler.wrap((ImagePlus)ImagePlus_Utils.extractCurrentStack((ImagePlus)this.myPlus));
            ResultsTable rt = ResultsTable.getResultsTable();
            if (rt == null) {
                rt = new ResultsTable();
            }
            rt.reset();
            int r0 = rt.getCounter();
            ResultsTable rt2 = rt;
            Objects3DIntPopulation pop = new Objects3DIntPopulation(img);
            AtomicInteger row = new AtomicInteger(r0);
            pop.getObjects3DInt().forEach(O -> {
                MeasureNumbering numbering = new MeasureNumbering(O, spots);
                rt2.incrementCounter();
                rt2.setValue("Value", row.get(), (double)O.getLabel());
                rt2.setValue("NbObjects", row.get(), numbering.getValueMeasurement("NumberObj").doubleValue());
                rt2.setValue("VolObjects", row.get(), numbering.getValueMeasurement("NumberObjVol").doubleValue());
                rt2.setValue("PercObjects", row.get(), numbering.getValueMeasurement("NumberObjVolPerc").doubleValue());
                rt2.setValue("Channel", row.get(), (double)channel);
                rt2.setValue("Frame", row.get(), (double)frame);
                rt2.setValue("Label", row.get(), title);
                row.getAndIncrement();
            });
            rt.sort("Value");
            rt.show("Numbering");
        }
    }

    private boolean Dialogue() {
        int nbima = WindowManager.getImageCount();
        String[] names = new String[nbima];
        for (int i = 0; i < nbima; ++i) {
            names[i] = WindowManager.getImage((int)(i + 1)).getShortTitle();
        }
        this.imaMain = 0;
        this.imaSignal = nbima > 1 ? nbima - 1 : 0;
        GenericDialog dia = new GenericDialog("Objects numbering");
        dia.addChoice("Main objects(containing)", names, names[this.imaMain]);
        dia.addChoice("Counted objects inside", names, names[this.imaSignal]);
        dia.showDialog();
        this.imaMain = dia.getNextChoiceIndex() + 1;
        this.imaSignal = dia.getNextChoiceIndex() + 1;
        return dia.wasOKed();
    }
}

