/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.measure.ResultsTable;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.util.List;
import mcib3d.geom.RDAR;
import mcib3d.geom2.Object3DInt;
import mcib3d.geom2.Objects3DIntPopulation;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageShort;

public class RDAR_
implements PlugInFilter {
    ResultsTable rt;
    boolean display = false;
    private ImagePlus imagePlus;
    private int minVolume = 100;

    public int setup(String arg, ImagePlus imp) {
        this.imagePlus = imp;
        return 13;
    }

    public void run(ImageProcessor ip) {
        if (this.dialog()) {
            ImageHandler imageInt = ImageHandler.wrap((ImagePlus)this.imagePlus);
            Objects3DIntPopulation objects3DPopulation = new Objects3DIntPopulation(imageInt);
            ImageShort drawIn = null;
            ImageShort drawOut = null;
            ImageShort drawEll = null;
            if (this.display) {
                if (this.imagePlus.getBitDepth() == 8 || this.imagePlus.getBitDepth() == 16) {
                    drawIn = new ImageShort("Parts inside", this.imagePlus.getWidth(), this.imagePlus.getHeight(), this.imagePlus.getImageStackSize());
                    drawOut = new ImageShort("Parts outside", this.imagePlus.getWidth(), this.imagePlus.getHeight(), this.imagePlus.getImageStackSize());
                    drawEll = new ImageShort("Ellipsoid", this.imagePlus.getWidth(), this.imagePlus.getHeight(), this.imagePlus.getImageStackSize());
                } else if (this.imagePlus.getBitDepth() == 32) {
                    drawIn = new ImageFloat("Parts inside", this.imagePlus.getWidth(), this.imagePlus.getHeight(), this.imagePlus.getImageStackSize());
                    drawOut = new ImageFloat("Parts outside", this.imagePlus.getWidth(), this.imagePlus.getHeight(), this.imagePlus.getImageStackSize());
                    drawEll = new ImageFloat("Ellipsoid", this.imagePlus.getWidth(), this.imagePlus.getHeight(), this.imagePlus.getImageStackSize());
                }
                drawIn.setScale(imageInt);
                drawOut.setScale(imageInt);
                drawEll.setScale(imageInt);
            }
            this.rt = ResultsTable.getResultsTable();
            if (this.rt == null) {
                this.rt = new ResultsTable();
            }
            this.rt.reset();
            for (Object3DInt object3D : objects3DPopulation.getObjects3DInt()) {
                this.processObject(object3D, (ImageHandler)drawIn, (ImageHandler)drawOut, (ImageHandler)drawEll);
            }
            this.rt.show("Results");
            if (this.display) {
                drawIn.show("Parts_In");
                drawOut.show("Parts_Out");
                drawEll.show("Ellipsoid");
            }
        }
    }

    private void processObject(Object3DInt object3D, ImageHandler drawIn, ImageHandler drawOut, ImageHandler drawEll) {
        IJ.log((String)("Analysing object " + object3D.getLabel()));
        this.rt.incrementCounter();
        RDAR rdar = new RDAR(object3D);
        this.rt.addValue("Value", (double)object3D.getLabel());
        this.rt.addValue("NbIn", (double)rdar.getPartsInNumber(this.minVolume));
        this.rt.addValue("NbOut", (double)rdar.getPartsOutNumber(this.minVolume));
        List list = rdar.getPartsIn(this.minVolume);
        int vol = 0;
        if (list != null) {
            for (Object3DInt object3DVoxels : list) {
                vol = (int)((double)vol + object3DVoxels.size());
            }
        }
        this.rt.addValue("volIn", (double)vol);
        list = rdar.getPartsOut(this.minVolume);
        vol = 0;
        if (list != null) {
            for (Object3DInt object3DVoxels : list) {
                vol = (int)((double)vol + object3DVoxels.size());
            }
        }
        this.rt.addValue("volOut", (double)vol);
        if (this.display) {
            float color = object3D.getLabel();
            rdar.getEllipsoid().drawObject(drawEll, color);
            if (rdar.getPartsIn(this.minVolume) != null) {
                for (Object3DInt part : rdar.getPartsIn(this.minVolume)) {
                    part.drawObject(drawIn, color);
                }
            }
            color = object3D.getLabel();
            if (rdar.getPartsOut(this.minVolume) != null) {
                for (Object3DInt part : rdar.getPartsOut(this.minVolume)) {
                    part.drawObject(drawOut, color);
                }
            }
        }
    }

    private boolean dialog() {
        GenericDialog genericDialog = new GenericDialog("RDAR");
        genericDialog.addNumericField("Min volume parts", (double)this.minVolume, 1, 10, "pix");
        genericDialog.addCheckbox("Display images", this.display);
        genericDialog.showDialog();
        this.minVolume = (int)genericDialog.getNextNumber();
        this.display = genericDialog.getNextBoolean();
        return genericDialog.wasOKed();
    }
}

