/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.measure.CurveFitter;
import ij.measure.ResultsTable;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import mcib3d.image3d.ImageHandler;
import mcib3d.utils.ArrayUtil;

public class Radial_3D
implements PlugInFilter {
    ImagePlus imp;
    int radMax;
    boolean fit = false;
    String mes;

    public void run(ImageProcessor ip) {
        this.radMax = (int)Prefs.get((String)"3Dradial.int", (double)10.0);
        ResultsTable rt = ResultsTable.getResultsTable();
        if (rt == null) {
            rt = new ResultsTable();
        }
        if (this.Dialogue()) {
            Roi roi = this.imp.getRoi();
            if (roi == null) {
                IJ.error((String)"Point roi required !");
                return;
            }
            int x = roi.getBounds().x;
            int y = roi.getBounds().y;
            int z = this.imp.getCurrentSlice() - 1;
            Calibration cal = this.imp.getCalibration();
            ImageHandler ima = ImageHandler.wrap((ImagePlus)this.imp);
            ima.setScale(cal.pixelWidth, cal.pixelDepth, cal.getUnit());
            double[] radidx = new double[2 * this.radMax + 1];
            for (int i = 0; i < radidx.length; ++i) {
                radidx[i] = -this.radMax + i;
            }
            IJ.log((String)(x + " " + y + " " + z));
            ArrayUtil sphere = ima.getNeighborhoodSphere(x, y, z, (float)this.radMax, (float)this.radMax, (float)this.radMax);
            IJ.log((String)("Mean in max sphere : " + sphere.getMean() + " StdDev : " + sphere.getStdDev()));
            int me = this.mes.equals("Mean") ? 10 : (this.mes.equals("Median") ? 14 : (this.mes.equals("Min") ? 12 : (this.mes.equals("Max") ? 13 : 11)));
            double[] radtab = ima.radialDistribution(x, y, z, this.radMax, me, null);
            ArrayUtil tab = new ArrayUtil(radtab);
            int ml = tab.getFirstLocalMaxima(tab.size() / 2 + 1, 0.0);
            IJ.log((String)("Max local " + radidx[ml]));
            int maxl = tab.getMaximumIndex();
            IJ.log((String)("Max " + -radidx[maxl]));
            radtab[0] = radtab[1];
            Plot plot = new Plot("Radial distribution", "rad", "mean", radidx, radtab);
            if (this.fit) {
                double[] params = ArrayUtil.fitGaussian((double[])radtab, (double)2.0, (int)this.radMax);
                double[] gauss = new double[2 * this.radMax + 1];
                for (int i = 0; i < gauss.length; ++i) {
                    gauss[i] = CurveFitter.f((int)12, (double[])params, (double)radidx[i]);
                }
                plot.addPoints(radidx, gauss, 0);
                plot.show();
                double sig = params[3];
                if (sig < 0.0) {
                    sig *= -1.0;
                }
                double radius = sig;
                IJ.log((String)("sigma=" + sig + " rad=" + radius));
                if (radius > 10.0) {
                    // empty if block
                }
                IJ.log((String)("radius=" + radius));
                if (Math.abs(params[2]) > 2.0) {
                    IJ.log((String)("TWO OBJECTS ??? " + params[2]));
                }
                double thresh = CurveFitter.f((int)12, (double[])params, (double)(0.675 * params[3]));
                IJ.log((String)("thresh=" + thresh));
                if (thresh < 1.0) {
                    IJ.log((String)("Pb threshold : " + thresh));
                }
                int lcseuil = (int)thresh;
                IJ.log((String)("treshold=" + lcseuil));
                rt.incrementCounter();
                int row = rt.getCounter();
                rt.setValue("Fit", row - 1, sig);
                rt.show("Results");
            } else {
                plot.show();
            }
        }
        Prefs.set((String)"3Dradial.int", (int)this.radMax);
    }

    private boolean Dialogue() {
        String[] meas = new String[]{"Mean", "Median", "Max", "Min", "StdDev"};
        GenericDialog gd = new GenericDialog("3D Radial distribution");
        gd.addNumericField("Radius_max", (double)this.radMax, 0);
        gd.addChoice("Measure", meas, meas[0]);
        gd.addCheckbox("Fit Gaussian", this.fit);
        gd.showDialog();
        this.radMax = (int)gd.getNextNumber();
        this.fit = gd.getNextBoolean();
        this.mes = gd.getNextChoice();
        return !gd.wasCanceled();
    }

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 133;
    }
}

