/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import java.util.List;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.processing.FastFilters3D;
import mcib3d.image3d.segment.LocalThresholder;
import mcib3d.image3d.segment.LocalThresholderConstant;
import mcib3d.image3d.segment.LocalThresholderDiff;
import mcib3d.image3d.segment.LocalThresholderGaussFit;
import mcib3d.image3d.segment.LocalThresholderMean;
import mcib3d.image3d.segment.Segment3DSpots;
import mcib3d.image3d.segment.SpotSegmenter;
import mcib3d.image3d.segment.SpotSegmenterBlock;
import mcib3d.image3d.segment.SpotSegmenterClassical;
import mcib3d.image3d.segment.SpotSegmenterMax;
import mcib_plugins.tools.RoiManager3D_2;

public class SeedSpots_Plus
implements PlugIn {
    ImagePlus seedPlus;
    ImageStack seedStack;
    ImageHandler seed3DImage;
    ImagePlus spotPlus;
    ImageStack spotStack;
    ImageHandler spot3DImage;
    ImagePlus segPlus = null;
    ImageStack segStack;
    Calibration spotCalib = null;
    double resXY = 0.1328;
    double resZ = 0.2;
    double radiusFixed = 0.0;
    double weight = 0.5;
    int local_method = 0;
    int spot_method = 0;
    int output = 0;
    int seeds_threshold = 15;
    int local_background = 65;
    float rad0 = 2.0f;
    float rad1 = 4.0f;
    float rad2 = 6.0f;
    double we = 0.5;
    int radmax = 10;
    double sdpc = 1.0;
    int volumeMin = 1;
    int volumeMax = 1000000;
    String[] local_methods = new String[]{"Constant", "Diff", "Local Mean", "Gaussian fit"};
    String[] spot_methods = new String[]{"Classical", "Maximum", "Block"};
    String[] outputs = new String[]{"Label Image", "Roi Manager 3D", "Both"};
    private boolean watershed = true;
    private int radiusSeeds = 2;
    private boolean debug = true;
    private boolean bigLabel;
    private int diff = 0;

    public void run(String arg) {
        int seed;
        int spot;
        IJ.log((String)"3D spots segmentation");
        int nbima = WindowManager.getImageCount();
        String[] names = new String[nbima + 1];
        for (int i = 0; i < nbima; ++i) {
            names[i] = WindowManager.getImage((int)(i + 1)).getShortTitle();
        }
        names[nbima] = "Automatic";
        if (nbima == 0) {
            IJ.log((String)"Image required :");
            return;
        }
        if (nbima < 2) {
            spot = 0;
            seed = 1;
        } else {
            seed = 0;
            spot = 1;
        }
        this.seeds_threshold = (int)Prefs.get((String)"SeedSpots_GlobalBackground.int", (double)this.seeds_threshold);
        this.local_background = (int)Prefs.get((String)"SeedSpots_LocalBackground.int", (double)this.local_background);
        this.diff = (int)Prefs.get((String)"SeedSpots_Diff.int", (double)this.diff);
        this.rad0 = (float)Prefs.get((String)"SeedSpots_Rad0.real", (double)this.rad0);
        this.rad1 = (float)Prefs.get((String)"SeedSpots_Rad1.real", (double)this.rad1);
        this.rad2 = (float)Prefs.get((String)"SeedSpots_Rad2.real", (double)this.rad2);
        this.we = (float)Prefs.get((String)"SeedSpots_Weight.real", (double)this.we);
        this.radmax = (int)Prefs.get((String)"SeedSpots_RadMax.int", (double)this.radmax);
        this.sdpc = Prefs.get((String)"SeedSpots_SDPC.real", (double)this.sdpc);
        this.local_method = (int)Prefs.get((String)"SeedSpots_LocalMethod.int", (double)this.local_method);
        this.spot_method = (int)Prefs.get((String)"SeedSpots_SpotMethod.int", (double)this.spot_method);
        this.output = (int)Prefs.get((String)"SeedSpots_Output.int", (double)this.output);
        this.watershed = Prefs.get((String)"SeedSpots_Watershed.boolean", (boolean)this.watershed);
        this.volumeMin = (int)Prefs.get((String)"SeedSpots_volMin.int", (double)this.volumeMin);
        this.volumeMax = (int)Prefs.get((String)"SeedSpots_volMax.int", (double)this.volumeMax);
        if (this.spot_method >= this.spot_methods.length) {
            this.spot_method = 0;
        }
        GenericDialog dia = new GenericDialog("Seeds spots");
        dia.addNumericField("Seeds_threshold", (double)this.seeds_threshold, 0);
        dia.addNumericField("Local_Background (0=auto)", (double)this.local_background, 0);
        dia.addChoice("Local_Threshold method", this.local_methods, this.local_methods[this.local_method]);
        dia.addNumericField("Local_diff", (double)this.diff, 0);
        dia.addMessage("Local_parameters (local mean)");
        dia.addNumericField("Radius_0", (double)this.rad0, 2);
        dia.addNumericField("Radius_1", (double)this.rad1, 2);
        dia.addNumericField("Radius_2", (double)this.rad2, 2);
        dia.addNumericField("Weigth", this.we, 2);
        dia.addMessage("Local_parameters (Gauss Fit)");
        dia.addNumericField("Radius_max", (double)this.radmax, 2);
        dia.addNumericField("sd_value", this.sdpc, 2);
        dia.addChoice("Seg_spot method", this.spot_methods, this.spot_methods[this.spot_method]);
        dia.addCheckbox("Watershed", this.watershed);
        dia.addNumericField("Volume_Min (pix)", (double)this.volumeMin, 0);
        dia.addNumericField("Volume_Max (pix)", (double)this.volumeMax, 0);
        dia.addChoice("Seeds", names, names[seed]);
        dia.addChoice("Spots", names, names[spot]);
        dia.addNumericField("Radius_for_seeds (automatic)", (double)this.radiusSeeds, 0);
        dia.addChoice("Output", this.outputs, this.outputs[this.output]);
        dia.addCheckbox("32-bits label", false);
        dia.addCheckbox("Verbose", false);
        dia.showDialog();
        if (dia.wasOKed()) {
            this.seeds_threshold = (int)dia.getNextNumber();
            this.local_background = (int)dia.getNextNumber();
            this.diff = (int)dia.getNextNumber();
            this.rad0 = (float)dia.getNextNumber();
            this.rad1 = (float)dia.getNextNumber();
            this.rad2 = (float)dia.getNextNumber();
            this.we = dia.getNextNumber();
            this.radmax = (int)dia.getNextNumber();
            this.sdpc = dia.getNextNumber();
            this.local_method = dia.getNextChoiceIndex();
            this.spot_method = dia.getNextChoiceIndex();
            this.watershed = dia.getNextBoolean();
            this.volumeMin = (int)dia.getNextNumber();
            this.volumeMax = (int)dia.getNextNumber();
            seed = dia.getNextChoiceIndex();
            spot = dia.getNextChoiceIndex();
            this.radiusSeeds = (int)dia.getNextNumber();
            this.output = dia.getNextChoiceIndex();
            this.bigLabel = dia.getNextBoolean();
            this.debug = dia.getNextBoolean();
            Prefs.set((String)"SeedSpots_GlobalBackground.int", (int)this.seeds_threshold);
            Prefs.set((String)"SeedSpots_LocalBackground.int", (int)this.local_background);
            Prefs.set((String)"SeedSpots_Diff.int", (int)this.diff);
            Prefs.set((String)"SeedSpots_Rad0.real", (double)this.rad0);
            Prefs.set((String)"SeedSpots_Rad1.real", (double)this.rad1);
            Prefs.set((String)"SeedSpots_Rad2.real", (double)this.rad2);
            Prefs.set((String)"SeedSpots_Weight.real", (double)this.we);
            Prefs.set((String)"SeedSpots_RadMax.int", (int)this.radmax);
            Prefs.set((String)"SeedSpots_SDPC.real", (double)this.sdpc);
            Prefs.set((String)"SeedSpots_LocalMethod.int", (int)this.local_method);
            Prefs.set((String)"SeedSpots_SpotMethod.int", (int)this.spot_method);
            Prefs.set((String)"SeedSpots_Output.int", (int)this.output);
            Prefs.set((String)"SeedSpots_Watershed.boolean", (boolean)this.watershed);
            Prefs.set((String)"SeedSpots_volMin.int", (int)this.volumeMin);
            Prefs.set((String)"SeedSpots_volMax.int", (int)this.volumeMax);
            IJ.log((String)"Initial.....");
            this.spotPlus = WindowManager.getImage((int)(spot + 1));
            this.spotStack = this.spotPlus.getImageStack();
            this.spot3DImage = ImageHandler.wrap((ImagePlus)this.spotPlus);
            if (seed < nbima) {
                this.seedPlus = WindowManager.getImage((int)(seed + 1));
                this.seedStack = this.seedPlus.getImageStack();
                this.seed3DImage = ImageHandler.wrap((ImagePlus)this.seedPlus);
            } else {
                this.computeSeeds();
            }
            if (this.spotPlus.getCalibration() != null) {
                this.spotCalib = this.spotPlus.getCalibration();
            }
            IJ.log((String)"Spot segmentation.....");
            this.Segmentation();
            IJ.log((String)"Finished");
            if (this.segPlus != null) {
                this.segPlus.show();
            }
            IJ.log((String)"Finished");
        }
    }

    private void computeSeeds() {
        this.seed3DImage = ImageHandler.wrap((ImageStack)FastFilters3D.filterIntImageStack((ImageStack)this.spotStack, (int)4, (float)this.radiusSeeds, (float)this.radiusSeeds, (float)this.radiusSeeds, (int)0, (boolean)false));
    }

    private void Segmentation() {
        SpotSegmenterMax spotSegmenter;
        LocalThresholderDiff localThresholder;
        Segment3DSpots seg = new Segment3DSpots(this.spot3DImage, this.seed3DImage);
        seg.setSeedsThreshold((float)this.seeds_threshold);
        seg.setBigLabel(this.bigLabel);
        seg.setUseWatershed(this.watershed);
        seg.setVolumeMin(this.volumeMin);
        seg.setVolumeMax(this.volumeMax);
        IJ.log((String)("Spot Image: " + seg.getRawImage().getTitle() + "   Seed Image : " + seg.getSeeds().getTitle()));
        IJ.log((String)("Vol min: " + seg.getVolumeMin() + "   Vol max: " + seg.getVolumeMax()));
        switch (this.local_method) {
            case 1: {
                localThresholder = new LocalThresholderDiff((float)this.diff);
                break;
            }
            case 2: {
                localThresholder = new LocalThresholderMean(this.rad0, this.rad1, this.rad2, this.we);
                break;
            }
            case 3: {
                localThresholder = new LocalThresholderGaussFit(this.radmax, this.sdpc);
                break;
            }
            default: {
                localThresholder = new LocalThresholderConstant((float)this.local_background);
            }
        }
        switch (this.spot_method) {
            case 1: {
                spotSegmenter = new SpotSegmenterMax();
                break;
            }
            case 2: {
                spotSegmenter = new SpotSegmenterBlock();
                break;
            }
            default: {
                spotSegmenter = new SpotSegmenterClassical();
            }
        }
        seg.setLocalThresholder((LocalThresholder)localThresholder);
        seg.setSpotSegmenter((SpotSegmenter)spotSegmenter);
        seg.segmentAll();
        int size = seg.getNbObjects();
        IJ.log((String)("Number of labelled objects: " + size));
        if (this.output == 0 || this.output == 2) {
            this.segPlus = seg.getLabeledImage().getImagePlus();
            if (this.spotCalib != null) {
                this.segPlus.setCalibration(this.spotCalib);
            }
        }
        if (this.output == 1 || this.output == 2) {
            List object3DS = seg.getObjects();
            RoiManager3D_2 roimanager = new RoiManager3D_2();
            roimanager.create3DManager();
        }
    }
}

