/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.AutoThresholder;
import ij.process.ImageProcessor;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.segment.Segment3DNuclei;

public class SegNuclei_
implements PlugInFilter {
    private static final String[] methods = AutoThresholder.getMethods();
    ImagePlus myPlus;
    private String method = methods[0];
    private boolean separate = true;
    private float manual = 0.0f;

    public int setup(String s, ImagePlus imagePlus) {
        this.myPlus = imagePlus;
        return 13;
    }

    public void run(ImageProcessor imageProcessor) {
        if (this.dialog()) {
            ImageHandler imageHandler = ImageHandler.wrap((ImagePlus)this.myPlus);
            Segment3DNuclei segment3DNuclei = new Segment3DNuclei(imageHandler);
            segment3DNuclei.setMethod(AutoThresholder.Method.valueOf((String)this.method));
            segment3DNuclei.setManual(this.manual);
            segment3DNuclei.setSeparate(this.separate);
            ImageHandler seg = segment3DNuclei.segment();
            seg.show();
        }
    }

    private boolean dialog() {
        GenericDialog dialog = new GenericDialog("Nuclei Segmentation");
        dialog.addMessage("3D segmentation of fluorescent nuclei for cell cultures.");
        dialog.addChoice("Auto_Threshold", methods, methods[0]);
        dialog.addNumericField("Manual threshold (0=auto)", 0.0, 0, 6, null);
        dialog.addCheckbox("Separate_nuclei", this.separate);
        dialog.showDialog();
        this.method = dialog.getNextChoice();
        this.manual = (float)dialog.getNextNumber();
        this.separate = dialog.getNextBoolean();
        return dialog.wasOKed();
    }
}

