/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageLabeller;

public class Segment3D_
implements PlugInFilter {
    ImagePlus myPlus;
    boolean debug = false;
    int markers = 0;

    public int setup(String arg, ImagePlus imp) {
        this.myPlus = imp;
        return 13;
    }

    public void run(ImageProcessor ip) {
        Object res;
        int low = 128;
        int min = 0;
        int max = -1;
        boolean individual = false;
        boolean bits32 = false;
        int nbima = WindowManager.getImageCount();
        String[] names = new String[nbima + 1];
        names[0] = "None";
        for (int i = 1; i <= nbima; ++i) {
            names[i] = WindowManager.getImage((int)i).getShortTitle();
        }
        GenericDialog gd = new GenericDialog("Segment3D");
        gd.addMessage("Image to segment : " + this.myPlus.getTitle());
        gd.addMessage("Only objects containing markers pixel will be detected.\nIf none all objects are detected.");
        gd.addChoice("Seeds", names, names[this.markers]);
        gd.addNumericField("Low_threshold (included)", (double)low, 0);
        gd.addNumericField("Min_size", (double)min, 0);
        gd.addNumericField("Max_size (-1 for infinity)", (double)max, 0);
        gd.addCheckbox("Individual voxels are objects", individual);
        gd.addCheckbox("32-bit segmentation (nb objects > 65,535)", bits32);
        gd.showDialog();
        this.markers = gd.getNextChoiceIndex();
        low = (int)gd.getNextNumber();
        min = (int)gd.getNextNumber();
        max = (int)gd.getNextNumber();
        individual = gd.getNextBoolean();
        bits32 = gd.getNextBoolean();
        if (gd.wasCanceled()) {
            return;
        }
        ImageLabeller labeler = new ImageLabeller();
        if (min > 0) {
            labeler.setMinSize(min);
        }
        if (max > 0) {
            labeler.setMaxsize(max);
        }
        ImageHandler img = ImageHandler.wrap((ImagePlus)this.myPlus);
        ImageByte bin = img.thresholdAboveInclusive((float)low);
        bin.setVoxelSize(img);
        bin.show("Bin");
        if (individual) {
            res = labeler.getLabelsIndividualVoxels((ImageHandler)bin);
        } else if (this.markers == 0) {
            res = bits32 ? labeler.getLabelsFloat((ImageHandler)bin) : labeler.getLabels((ImageHandler)bin);
            IJ.log((String)("Nb obj total =" + labeler.getNbObjectsTotal((ImageHandler)bin)));
            IJ.log((String)("Nb obj in range size =" + labeler.getNbObjectsInSizeRange((ImageHandler)bin)));
        } else {
            ImageHandler marker = ImageHandler.wrap((ImagePlus)WindowManager.getImage((int)this.markers));
            res = bits32 ? labeler.getLabelsWithSeedsFloat((ImageHandler)bin, marker) : labeler.getLabelsWithSeeds((ImageHandler)bin, marker);
        }
        res.setVoxelSize(img);
        res.show("Seg");
    }
}

