/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import ij.measure.Calibration;
import ij.plugin.Duplicator;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.text.NumberFormat;
import mcib3d.geom.Objects3DPopulation;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageLabeller;
import mcib3d.utils.ArrayUtil;
import mcib3d.utils.CDFTools;

public class Simple_Dist_Analysis
implements PlugInFilter {
    int nBins = 100;
    Color color = null;
    ImagePlus plus;

    public int setup(String string, ImagePlus ip) {
        this.plus = ip;
        return 5;
    }

    public void run(ImageProcessor ip) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(3);
        ImageInt img = ImageInt.wrap((ImagePlus)this.extractCurrentStack(this.plus));
        Calibration cal = this.plus.getCalibration();
        if (this.Dialogue()) {
            if (cal != null) {
                img.setScale(cal.pixelWidth, cal.pixelDepth, cal.getUnits());
            }
            ImageInt imageInt = img;
            if (img.isBinary()) {
                IJ.log((String)"Binary data, labelling ...");
                ImageLabeller imageLabeller = new ImageLabeller();
                imageInt = imageLabeller.getLabels((ImageHandler)img);
                imageInt.show("Labelled");
            }
            Objects3DPopulation objPopA = new Objects3DPopulation(imageInt);
            IJ.log((String)("nb=" + objPopA.getNbObjects()));
            IJ.log((String)"G analysis, closest point");
            ArrayUtil dist = objPopA.distancesAllClosestCenter();
            ArrayUtil[] arrayUtils = dist.getHistogram(this.nBins);
            Plot plotG = new Plot("G function", "distances (" + cal.getUnit() + ") ", "frequency");
            plotG.setColor(this.color);
            arrayUtils[1].divideAll((double)dist.size());
            plotG.addPoints(arrayUtils[0].getArray(), arrayUtils[1].getArray(), 2);
            plotG.show();
            dist.sort();
            ArrayUtil cdf = CDFTools.cdf((ArrayUtil)dist);
            Plot plotG1 = new Plot("G function cdf", "distances (" + cal.getUnit() + ") ", "frequency");
            plotG1.setColor(this.color);
            plotG1.addPoints(dist.getArray(), cdf.getArray(), 2);
            plotG1.show();
            IJ.log((String)("min=" + nf.format(dist.getMinimum()) + " avg=" + nf.format(dist.getMean()) + " max=" + nf.format(dist.getMaximum())));
            IJ.log((String)("med=" + nf.format(dist.median()) + " sd=" + nf.format(dist.getStdDev())));
            dist = objPopA.distancesAllCenter();
            arrayUtils = dist.getHistogram(this.nBins);
            arrayUtils[1].divideAll((double)dist.size());
            Plot plotH = new Plot("H function", "distances (" + cal.getUnit() + ") ", "frequency");
            plotH.setColor(this.color);
            plotH.addPoints(arrayUtils[0].getArray(), arrayUtils[1].getArray(), 2);
            plotH.show();
            dist.sort();
            cdf = CDFTools.cdf((ArrayUtil)dist);
            Plot plotH1 = new Plot("H function cdf", "distances (" + cal.getUnit() + ") ", "frequency");
            plotH1.setColor(this.color);
            plotH1.addPoints(dist.getArray(), cdf.getArray(), 2);
            plotH1.show();
        }
    }

    private boolean Dialogue() {
        String[] colors = new String[]{"Red", "Green", "Blue", "Cyan", "Magenta", "Yellow", "Orange", "Pink", "Black"};
        GenericDialog gd = new GenericDialog("Spatial Statistics");
        gd.addNumericField("Nb bins for histogram", (double)this.nBins, 0);
        gd.addChoice("Draw_color:", colors, colors[0]);
        gd.showDialog();
        this.nBins = (int)gd.getNextNumber();
        switch (gd.getNextChoiceIndex()) {
            case 0: {
                this.color = Color.red;
                break;
            }
            case 1: {
                this.color = Color.green;
                break;
            }
            case 2: {
                this.color = Color.blue;
                break;
            }
            case 3: {
                this.color = Color.cyan;
                break;
            }
            case 4: {
                this.color = Color.magenta;
                break;
            }
            case 5: {
                this.color = Color.yellow;
                break;
            }
            case 6: {
                this.color = Color.orange;
                break;
            }
            case 7: {
                this.color = Color.pink;
                break;
            }
            default: {
                this.color = Color.black;
            }
        }
        return gd.wasOKed();
    }

    private ImagePlus extractCurrentStack(ImagePlus plus) {
        ImagePlus stack;
        int[] dims = plus.getDimensions();
        int channel = plus.getChannel();
        int frame = plus.getFrame();
        if (dims[2] > 1 || dims[4] > 1) {
            IJ.log((String)("Hyperstack found, extracting current channel " + channel + " and frame " + frame));
            Duplicator duplicator = new Duplicator();
            stack = duplicator.run(plus, channel, channel, 1, dims[3], frame, frame);
        } else {
            stack = plus.duplicate();
        }
        return stack;
    }
}

