/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.ResultsTable;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.util.List;
import mcib3d.geom2.measurements.MeasureIntensity;
import mcib3d.geom2.measurements.MeasureIntensityHist;
import mcib3d.image3d.ImageHandler;
import mcib_plugins.analysis.SimpleMeasure;

public class Simple_MeasureStatistics
implements PlugInFilter {
    ImagePlus myPlus;
    int imaSpots;
    int imaSignal;

    public int setup(String arg, ImagePlus imp) {
        return 13;
    }

    public void run(ImageProcessor ip) {
        if (this.Dialogue()) {
            int row;
            this.myPlus = WindowManager.getImage((int)this.imaSpots);
            int channel = this.myPlus.getChannel();
            int frame = this.myPlus.getFrame();
            int nbCT = this.myPlus.getNChannels() * this.myPlus.getNFrames();
            String title = this.myPlus.getTitle();
            ImageHandler img = ImageHandler.wrap((ImagePlus)SimpleMeasure.extractCurrentStack(this.myPlus));
            ImagePlus seg = img.getImagePlus();
            SimpleMeasure mes = new SimpleMeasure(seg);
            ResultsTable rt = ResultsTable.getResultsTable();
            if (rt == null) {
                rt = new ResultsTable();
            }
            this.myPlus = WindowManager.getImage((int)this.imaSignal);
            ImagePlus plusSignal = SimpleMeasure.extractCurrentStack(this.myPlus);
            title = title.concat(":");
            title = title.concat(plusSignal.getTitle());
            List<Double[]> res = mes.getMeasuresStats(plusSignal);
            int row0 = row = rt.getCounter();
            String[] keys_s = new MeasureIntensity().getNamesMeasurement();
            for (Double[] re : res) {
                rt.incrementCounter();
                for (int k = 0; k < keys_s.length; ++k) {
                    if (re[k] == null) {
                        rt.setValue(keys_s[k], row, Double.NaN);
                        continue;
                    }
                    rt.setValue(keys_s[k], row, re[k].doubleValue());
                }
                rt.setLabel(title, row);
                ++row;
            }
            res = mes.getMeasuresStatsHist(plusSignal);
            row = row0;
            String[] keys_s1 = new MeasureIntensityHist().getNamesMeasurement();
            for (Double[] re : res) {
                for (int k = 0; k < keys_s1.length; ++k) {
                    rt.setValue(keys_s1[k], row, re[k].doubleValue());
                }
                if (nbCT > 1) {
                    rt.setValue("Channel", row, (double)channel);
                    rt.setValue("Frame", row, (double)frame);
                }
                ++row;
            }
            rt.sort("LabelObj");
            rt.updateResults();
            rt.show("Results");
        }
    }

    private boolean Dialogue() {
        int nbima = WindowManager.getImageCount();
        String[] names = new String[nbima];
        for (int i = 0; i < nbima; ++i) {
            names[i] = WindowManager.getImage((int)(i + 1)).getShortTitle();
        }
        this.imaSpots = 0;
        this.imaSignal = nbima > 1 ? nbima - 1 : 0;
        GenericDialog dia = new GenericDialog("Statistical measure");
        dia.addChoice("Objects", names, names[this.imaSpots]);
        dia.addChoice("Signal", names, names[this.imaSignal]);
        dia.showDialog();
        this.imaSpots = dia.getNextChoiceIndex() + 1;
        this.imaSignal = dia.getNextChoiceIndex() + 1;
        return dia.wasOKed();
    }
}

