/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Color;
import mcib3d.geom.Point3D;
import mcib3d.utils.ThreadUtil;
import mcib_plugins.analysis.SpatialAnalysis;

public class Stats_Spat3D
implements PlugInFilter {
    ImagePlus imp;
    Calibration calibration;
    int numEvaluationPointsF = 10000;
    int numRandomSamples = 100;
    double distHardCore = 0.0;
    int imaspots = 0;
    int imamask = 1;
    String[] names;
    Point3D[] evaluationPoints;
    String functions;
    boolean show;
    boolean save;
    int indexcol = 0;
    Color colorDraw = null;
    private int env = 5;
    private int nbcpus;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 5;
    }

    public void run(ImageProcessor ip) {
        int nbIma = WindowManager.getImageCount();
        this.names = new String[nbIma];
        if (nbIma < 2) {
            ImagePlus plus = IJ.getImage();
            if (plus != null && plus.getStackSize() == 1) {
                IJ.log((String)"Creating mask");
                SpatialAnalysis.createMask(plus);
            }
            nbIma = WindowManager.getImageCount();
            this.names = new String[nbIma];
            if (nbIma < 2) {
                IJ.showMessage((String)"Needs 2 images");
                return;
            }
        }
        for (int i = 0; i < nbIma; ++i) {
            this.names[i] = WindowManager.getImage((int)(i + 1)).getShortTitle();
        }
        if (!this.Dialogue()) {
            return;
        }
        this.imp = WindowManager.getImage((int)(this.imaspots + 1));
        this.calibration = this.imp.getCalibration();
        SpatialAnalysis spa = new SpatialAnalysis(this.numEvaluationPointsF, this.numRandomSamples, this.distHardCore, (double)this.env / 100.0);
        spa.setMultiThread(this.nbcpus);
        spa.setColorsPlot(Color.DARK_GRAY, Color.LIGHT_GRAY, this.colorDraw);
        if (spa.process(this.imp, WindowManager.getImage((int)(this.imamask + 1)), this.functions, true, this.show, this.save)) {
            spa.getRandomSample().show("Random Sample");
        }
    }

    private boolean Dialogue() {
        this.numEvaluationPointsF = (int)Prefs.get((String)"Analysis_F_numPoints.double", (double)this.numEvaluationPointsF);
        this.numRandomSamples = (int)Prefs.get((String)"Analysis_F_numRandom.double", (double)this.numRandomSamples);
        this.distHardCore = Prefs.get((String)"Analysis_F_hardCore.double", (double)this.distHardCore);
        this.env = (int)Prefs.get((String)"Analysis_F_env.double", (double)this.env);
        this.indexcol = (int)Prefs.get((String)"Analysis_F_col.double", (double)this.indexcol);
        String[] colors = new String[]{"Red", "Green", "Blue", "Cyan", "Magenta", "Yellow", "Orange", "Pink", "Black"};
        GenericDialog gd = new GenericDialog("Spatial Statistics");
        gd.addMessage("Choose stat functions to evaluate");
        gd.addCheckboxGroup(1, 3, new String[]{"F", "G", "H"}, new boolean[]{true, true, false});
        gd.addNumericField("Nb_points (F function)", Prefs.get((String)"Analysis_F_numPoints.double", (double)this.numEvaluationPointsF), 0);
        gd.addNumericField("Samples", (double)this.numRandomSamples, 0);
        gd.addNumericField("Distance hardcore (" + this.imp.getCalibration().getUnits() + ")", this.distHardCore, 3);
        gd.addNumericField("Error %", (double)this.env, 0);
        gd.addChoice("Spots", this.names, this.names[0]);
        gd.addChoice("Mask", this.names, this.names[1]);
        gd.addSlider("MultiThread", 1.0, (double)ThreadUtil.getNbCpus(), (double)ThreadUtil.getNbCpus());
        gd.addMessage("Plot options");
        gd.addChoice("Draw_color:", colors, colors[this.indexcol]);
        gd.addCheckbox("Show plots", true);
        gd.addCheckbox("Save plots", true);
        gd.showDialog();
        this.functions = "";
        if (gd.getNextBoolean()) {
            this.functions = this.functions.concat("F");
        }
        if (gd.getNextBoolean()) {
            this.functions = this.functions.concat("G");
        }
        if (gd.getNextBoolean()) {
            this.functions = this.functions.concat("H");
        }
        if (this.functions.isEmpty()) {
            IJ.log((String)"Choose at least one function");
            return false;
        }
        this.numEvaluationPointsF = (int)gd.getNextNumber();
        this.numRandomSamples = (int)gd.getNextNumber();
        this.distHardCore = gd.getNextNumber();
        this.env = (int)gd.getNextNumber();
        this.imaspots = gd.getNextChoiceIndex();
        this.imamask = gd.getNextChoiceIndex();
        this.nbcpus = (int)gd.getNextNumber();
        this.indexcol = gd.getNextChoiceIndex();
        this.show = gd.getNextBoolean();
        this.save = gd.getNextBoolean();
        Prefs.set((String)"Analysis_F_numPoints.double", (int)this.numEvaluationPointsF);
        Prefs.set((String)"Analysis_F_numRandom.double", (int)this.numRandomSamples);
        Prefs.set((String)"Analysis_F_hardCore.double", (double)this.distHardCore);
        Prefs.set((String)"Analysis_F_env.double", (int)this.env);
        Prefs.set((String)"Analysis_F_col.double", (int)this.indexcol);
        switch (this.indexcol) {
            case 0: {
                this.colorDraw = Color.red;
                break;
            }
            case 1: {
                this.colorDraw = Color.green;
                break;
            }
            case 2: {
                this.colorDraw = Color.blue;
                break;
            }
            case 3: {
                this.colorDraw = Color.cyan;
                break;
            }
            case 4: {
                this.colorDraw = Color.magenta;
                break;
            }
            case 5: {
                this.colorDraw = Color.yellow;
                break;
            }
            case 6: {
                this.colorDraw = Color.orange;
                break;
            }
            case 7: {
                this.colorDraw = Color.pink;
                break;
            }
            default: {
                this.colorDraw = Color.black;
            }
        }
        return gd.wasOKed();
    }
}

