/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.util.LinkedList;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.processing.ImageStitcher;

public class Stitch2_
implements PlugIn {
    private static final int UNION = 1;
    private static final int INTERSECTION = 2;
    private static int mergeMethod = 1;
    int ima0 = 0;
    int ima1 = 1;
    private double minRatioColoc = 0.5;

    public void run(String s) {
        if (WindowManager.getImageCount() < 2) {
            IJ.showMessage((String)"Requires two images");
            return;
        }
        if (this.Dialogue()) {
            ImagePlus plus0 = WindowManager.getImage((int)this.ima0);
            ImagePlus plus1 = WindowManager.getImage((int)this.ima1);
            ImageHandler handler0 = ImageHandler.wrap((ImagePlus)plus0);
            ImageHandler handler1 = ImageHandler.wrap((ImagePlus)plus1);
            LinkedList<ImageHandler> images = new LinkedList<ImageHandler>();
            images.add(handler0);
            images.add(handler1);
            ImageHandler draw = handler0.createSameDimensions();
            ImageStitcher stitcher = new ImageStitcher(images);
            int merge = mergeMethod == 0 ? 1 : 2;
            stitcher.setMergeMethod(merge);
            stitcher.stitchLabelImages(this.minRatioColoc).drawInImage(draw);
            draw.show(handler0.getTitle() + "_" + handler1.getTitle());
        }
    }

    private boolean Dialogue() {
        int nbima = WindowManager.getImageCount();
        String[] names = new String[nbima];
        for (int i = 0; i < nbima; ++i) {
            names[i] = WindowManager.getImage((int)(i + 1)).getShortTitle();
        }
        String[] methods = new String[]{"Union", "Intersection"};
        GenericDialog dia = new GenericDialog("Stitch label images");
        dia.addChoice("ImageA", names, names[this.ima0]);
        dia.addChoice("ImageB", names, names[this.ima1]);
        dia.addNumericField("Min ratio Coloc", this.minRatioColoc);
        dia.addChoice("Merge method", methods, methods[mergeMethod]);
        dia.showDialog();
        this.ima0 = dia.getNextChoiceIndex() + 1;
        this.ima1 = dia.getNextChoiceIndex() + 1;
        this.minRatioColoc = dia.getNextNumber();
        mergeMethod = dia.getNextChoiceIndex();
        return dia.wasOKed();
    }
}

