/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins.TEST;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.Duplicator;
import ij.plugin.PlugIn;
import ij.plugin.ZProjector;
import ij.process.ImageProcessor;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mcib3d.geom.Vector3D;
import mcib3d.geom.Voxel3D;
import mcib3d.geom2.Object3DInt;
import mcib3d.geom2.measurements.MeasureCentroid;
import mcib3d.geom2.measurements.MeasureEllipsoid;
import mcib3d.geom2.measurements.MeasureFeret;
import mcib3d.image3d.ImageHandler;

public class TranslateCenterOfMass_
implements PlugIn {
    public static void main(String[] args) {
        String nameRaw = "SimulRodGaussian5Stack.tif";
        String nameSeg = "SimulRodGaussian5StackBin.tif";
        nameRaw = "20200819_Swt0031.asd.tif";
        nameSeg = "20200819_Swt0031.binary.tif";
        int radiusCC = 128;
        ImagePlus rawPlus = IJ.openImage((String)("/home/thomas/AMU/Projects/AFMVIDEO/Data/" + nameRaw));
        ImagePlus segPlus = IJ.openImage((String)("/home/thomas/AMU/Projects/AFMVIDEO/Data/" + nameSeg));
        int nFrames = rawPlus.getNFrames();
        HashMap mapCenters = new HashMap();
        HashMap mapFeret = new HashMap();
        List centers = IntStream.rangeClosed(0, nFrames - 1).mapToObj(f -> {
            System.out.println("Processing " + f + " / " + nFrames);
            ImagePlus plus1 = TranslateCenterOfMass_.extractCurrentStack(rawPlus, 0, f);
            ImageHandler raw = ImageHandler.wrap((ImagePlus)plus1);
            ImagePlus plus2 = TranslateCenterOfMass_.extractCurrentStack(segPlus, 0, f);
            ImageHandler seg = ImageHandler.wrap((ImagePlus)plus2);
            Object3DInt object3DInt = new Object3DInt(seg);
            MeasureCentroid center = new MeasureCentroid(object3DInt);
            double cx = center.getValueMeasurement("CX(pix)");
            double cy = center.getValueMeasurement("CY(pix)");
            Voxel3D V = new Voxel3D(cx, cy, (double)f, 1.0);
            mapCenters.put(f, V);
            MeasureFeret feret = new MeasureFeret(object3DInt);
            MeasureEllipsoid ellipsoid = new MeasureEllipsoid(object3DInt);
            Vector3D vect = ellipsoid.getAxis1();
            if (vect.x < 0.0) {
                vect = vect.multiply(-1.0);
            }
            mapFeret.put(f, new Vector3D(vect.getNormalizedVector()));
            return V;
        }).collect(Collectors.toList());
        Voxel3D avg = new Voxel3D(rawPlus.getWidth() / 2, rawPlus.getHeight() / 2, 0, 1.0f);
        ImageStack stackAligned1 = new ImageStack(rawPlus.getWidth(), rawPlus.getHeight());
        Vector3D axisX = new Vector3D(1.0f, 0.0f, 0.0f);
        IntStream.rangeClosed(0, nFrames - 1).forEach(f -> {
            System.out.println("Aligning " + f + " / " + nFrames);
            ImagePlus plus = TranslateCenterOfMass_.extractCurrentStack(rawPlus, 0, f);
            ImageProcessor processor = plus.getProcessor();
            Voxel3D V = (Voxel3D)mapCenters.get(f);
            processor.translate(avg.x - V.x, avg.y - V.y);
            Vector3D vect = (Vector3D)mapFeret.get(f);
            double ang = vect.angleDegrees(axisX);
            if (vect.y > 0.0) {
                ang *= -1.0;
            }
            processor.setInterpolationMethod(2);
            processor.rotate(ang);
            stackAligned1.addSlice(processor);
        });
        ImagePlus plusTrans = new ImagePlus("Aligned1", stackAligned1);
        IJ.run((ImagePlus)plusTrans, (String)"Properties...", (String)("channels=1 slices=1 frames=" + nFrames + " pixel_width=1.0000 pixel_height=1.0000 voxel_depth=1.0000"));
        IJ.saveAsTiff((ImagePlus)plusTrans, (String)("/home/thomas/AMU/Projects/AFMVIDEO/Data/" + nameRaw + "-aligned1.tif"));
        ImageStack stackAligned2 = new ImageStack(rawPlus.getWidth(), rawPlus.getHeight());
        ImagePlus plus0 = TranslateCenterOfMass_.extractCurrentStack(plusTrans, 0, 0);
        ImageProcessor ref0 = plus0.getProcessor();
        IntStream.rangeClosed(0, nFrames - 1).forEach(f -> {
            System.out.println("CC1 " + f);
            ImagePlus plus = TranslateCenterOfMass_.extractCurrentStack(plusTrans, 0, f);
            ImageProcessor processor = plus.getProcessor();
            processor = TranslateCenterOfMass_.bestTranslation(processor, ref0, 10, 128);
            processor = TranslateCenterOfMass_.bestRotation(processor, ref0, 15, 128);
            stackAligned2.addSlice(processor);
        });
        ImagePlus plusTrans2 = new ImagePlus("Aligned2", stackAligned2);
        IJ.log((String)"Performing maximum Z-projection");
        ZProjector zProjector = new ZProjector();
        zProjector.setMethod(0);
        zProjector.setStartSlice(1);
        zProjector.setStopSlice(plusTrans2.getNSlices());
        zProjector.setImage(plusTrans2);
        zProjector.doProjection();
        ImagePlus plusAvg = zProjector.getProjection();
        ImageProcessor avgProcessor = plusAvg.getProcessor();
        plusAvg.show();
        IJ.run((ImagePlus)plusTrans2, (String)"Properties...", (String)("channels=1 slices=1 frames=" + nFrames + " pixel_width=1.0000 pixel_height=1.0000 voxel_depth=1.0000"));
        IJ.saveAsTiff((ImagePlus)plusTrans2, (String)("/home/thomas/AMU/Projects/AFMVIDEO/Data/" + nameRaw + "-aligned2.tif"));
        ImageStack stackAligned3 = new ImageStack(rawPlus.getWidth(), rawPlus.getHeight());
        IntStream.rangeClosed(0, nFrames - 1).forEach(f -> {
            System.out.println("CC2 " + f);
            ImagePlus plus = TranslateCenterOfMass_.extractCurrentStack(plusTrans2, 0, f);
            ImageProcessor processor = plus.getProcessor();
            processor = TranslateCenterOfMass_.bestTranslation(processor, avgProcessor, 5, 128);
            processor = TranslateCenterOfMass_.bestRotation(processor, avgProcessor, 5, 128);
            stackAligned3.addSlice(processor);
        });
        ImagePlus plusTrans3 = new ImagePlus("Aligned3", stackAligned3);
        IJ.run((ImagePlus)plusTrans3, (String)"Properties...", (String)("channels=1 slices=1 frames=" + nFrames + " pixel_width=1.0000 pixel_height=1.0000 voxel_depth=1.0000"));
        IJ.saveAsTiff((ImagePlus)plusTrans3, (String)("/home/thomas/AMU/Projects/AFMVIDEO/Data/" + nameRaw + "-aligned3.tif"));
    }

    private static ImageProcessor bestTranslation(ImageProcessor ima, ImageProcessor ref, int maxT, int radius) {
        double maxCC = Double.NEGATIVE_INFINITY;
        int bestX = 1000;
        int bestY = 1000;
        ImageProcessor best = ima.duplicate();
        for (int tx = -maxT; tx <= maxT; ++tx) {
            for (int ty = -maxT; ty <= maxT; ++ty) {
                double cc = TranslateCenterOfMass_.correlationValueTranslate(ima, ref, tx, ty, radius);
                if (!(cc > maxCC)) continue;
                maxCC = cc;
                bestX = tx;
                bestY = ty;
            }
        }
        best.translate((double)bestX, (double)bestY);
        System.out.println("CC TRANS " + bestX + " " + bestY);
        return best;
    }

    private static ImageProcessor bestRotation(ImageProcessor ima, ImageProcessor ref, int maxAng, int radius) {
        double maxCC = Double.NEGATIVE_INFINITY;
        int bestAng = 1000;
        ImageProcessor best = ima.duplicate();
        for (int ang = -maxAng; ang <= maxAng; ++ang) {
            double cc = TranslateCenterOfMass_.correlationValueRotate(ima, ref, ang, radius);
            if (!(cc > maxCC)) continue;
            maxCC = cc;
            bestAng = ang;
        }
        best.setInterpolationMethod(2);
        best.rotate((double)bestAng);
        System.out.println("CC ROT " + bestAng);
        return best;
    }

    private static ImagePlus extractCurrentStack(ImagePlus plus, int channelI, int frameI) {
        ImagePlus stack;
        int[] dims = plus.getDimensions();
        int channel = channelI == 0 ? plus.getChannel() : channelI;
        int frame = frameI;
        if (dims[2] > 1 || dims[4] > 1) {
            Duplicator duplicator = new Duplicator();
            stack = duplicator.run(plus, channel, channel, 1, dims[3], frame, frame);
        } else {
            stack = plus.duplicate();
        }
        return stack;
    }

    private static double correlationValueTranslate(ImageProcessor ima, ImageProcessor ref, int tx, int ty, int radius) {
        int yyr;
        int xxr;
        double dist2;
        int yy;
        int xx;
        int KernelWidth = ref.getWidth();
        int KernelHeight = ref.getHeight();
        int countpix = 0;
        double kmean = 0.0;
        double smean = 0.0;
        double tk = 0.0;
        double ts = 0.0;
        double skk = 0.0;
        double sss = 0.0;
        double sks = 0.0;
        double rfactor = 0.0;
        double tiny = 1.0E-20;
        int radius2 = radius > 0 ? radius * radius : Integer.MAX_VALUE;
        int xc = KernelWidth / 2;
        int yc = KernelHeight / 2;
        for (xx = 0; xx < KernelWidth; ++xx) {
            for (yy = 0; yy < KernelHeight; ++yy) {
                dist2 = (xx - xc) * (xx - xc) + (yy - yc) * (yy - yc);
                if (!(dist2 < (double)radius2)) continue;
                xxr = xx + tx;
                yyr = yy + ty;
                kmean += (double)ref.getPixelValue(xxr, yyr);
                smean += (double)ima.getPixelValue(xx, yy);
                ++countpix;
            }
        }
        kmean /= (double)countpix;
        smean /= (double)countpix;
        for (xx = 0; xx < KernelWidth; ++xx) {
            for (yy = 0; yy < KernelHeight; ++yy) {
                dist2 = (xx - xc) * (xx - xc) + (yy - yc) * (yy - yc);
                if (!(dist2 < (double)radius2)) continue;
                xxr = xx + tx;
                yyr = yy + ty;
                tk = (double)ref.getPixelValue(xxr, yyr) - kmean;
                ts = (double)ima.getPixelValue(xx, yy) - smean;
                skk += tk * tk;
                sss += ts * ts;
                sks += tk * ts;
            }
        }
        rfactor = sks / (Math.sqrt(skk * sss) + tiny);
        return rfactor;
    }

    private static double correlationValueRotate(ImageProcessor ima, ImageProcessor ref, double ang, int radius) {
        double yyr;
        double xxr;
        double dist2;
        int yy;
        int xx;
        int KernelWidth = ref.getWidth();
        int KernelHeight = ref.getHeight();
        int xc = KernelWidth / 2;
        int yc = KernelHeight / 2;
        int countpix = 0;
        int radius2 = radius > 0 ? radius * radius : Integer.MAX_VALUE;
        double cosa = Math.cos(Math.toRadians(-ang));
        double sina = Math.sin(Math.toRadians(-ang));
        double kmean = 0.0;
        double smean = 0.0;
        double tk = 0.0;
        double ts = 0.0;
        double skk = 0.0;
        double sss = 0.0;
        double sks = 0.0;
        double rfactor = 0.0;
        double tiny = 1.0E-20;
        for (xx = 0; xx < KernelWidth; ++xx) {
            for (yy = 0; yy < KernelHeight; ++yy) {
                dist2 = (xx - xc) * (xx - xc) + (yy - yc) * (yy - yc);
                if (!(dist2 < (double)radius2)) continue;
                xxr = (double)(xx - xc) * cosa + (double)(yy - yc) * sina + (double)xc;
                yyr = (double)(yy - yc) * cosa - (double)(xx - xc) * sina + (double)yc;
                kmean += ref.getInterpolatedPixel(xxr, yyr);
                smean += (double)ima.getPixelValue(xx, yy);
                ++countpix;
            }
        }
        kmean /= (double)countpix;
        smean /= (double)countpix;
        for (xx = 0; xx < KernelWidth; ++xx) {
            for (yy = 0; yy < KernelHeight; ++yy) {
                dist2 = (xx - xc) * (xx - xc) + (yy - yc) * (yy - yc);
                if (!(dist2 < (double)radius2)) continue;
                xxr = (double)(xx - xc) * cosa + (double)(yy - yc) * sina + (double)xc;
                yyr = (double)(yy - yc) * cosa - (double)(xx - xc) * sina + (double)yc;
                tk = ref.getInterpolatedPixel(xxr, yyr) - kmean;
                ts = (double)ima.getPixelValue(xx, yy) - smean;
                skk += tk * tk;
                sss += ts * ts;
                sks += tk * ts;
            }
        }
        rfactor = sks / (Math.sqrt(skk * sss) + tiny);
        return rfactor;
    }

    public void run(String s) {
    }
}

