/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.Duplicator;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import mcib3d.geom.Object3D;
import mcib3d.geom.Objects3DPopulation;
import mcib3d.geom.Point3D;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageLabeller;
import mcib3d.image3d.IterativeThresholding.TrackThreshold;
import mcib3d.image3d.processing.FastFilters3D;

public class Track_Threshold
implements PlugInFilter {
    int volMax = (int)Prefs.get((String)"mcib_iterative_volmax.int", (double)1000.0);
    int volMin = (int)Prefs.get((String)"mcib_iterative_volmin.int", (double)100.0);
    double minTh = (int)Prefs.get((String)"mcib_iterative_thmin.int", (double)0.0);
    int minCont = (int)Prefs.get((String)"mcib_iterative_contmin.int", (double)0.0);
    boolean filter = false;
    Calibration cal;
    private int step = (int)Prefs.get((String)"mcib_iterative_step.int", (double)10.0);
    private int threshold_method = (int)Prefs.get((String)"mcib_iterative_method.int", (double)0.0);
    private int crit = (int)Prefs.get((String)"mcib_iterative_criteria.int", (double)0.0);
    private int seg = (int)Prefs.get((String)"mcib_iterative_seg.int", (double)0.0);
    private boolean start;
    private String[] methods;
    private String[] criteria;
    private String[] segs;

    public int setup(String arg, ImagePlus imp) {
        return 5;
    }

    public void run(ImageProcessor ip) {
        ImagePlus zonePlus;
        ImagePlus plus = IJ.getImage();
        ArrayList<Point3D> point3Ds = null;
        Calibration calibration = plus.getCalibration();
        ImagePlus seeds = WindowManager.getImage((String)"markers");
        if (seeds != null) {
            point3Ds = this.computeMarkers(ImageInt.wrap((ImagePlus)seeds));
        }
        if (!this.dialogue()) {
            return;
        }
        Duplicator dup = new Duplicator();
        int[] dim = plus.getDimensions();
        int selectedTime = plus.getFrame();
        ImagePlus timeDuplicate = dup.run(plus, 1, 1, 1, dim[3], selectedTime, selectedTime);
        if (this.filter) {
            int radX = (int)Math.floor(Math.pow((double)this.volMin * 3.0 / (Math.PI * 4), 0.3333333333333333));
            if (radX > 10) {
                radX = 10;
            }
            if (radX < 1) {
                radX = 1;
            }
            int radZ = radX;
            IJ.log((String)("Filtering with radius " + radX));
            ImageStack res = FastFilters3D.filterIntImageStack((ImageStack)timeDuplicate.getStack(), (int)1, (float)radX, (float)radX, (float)radZ, (int)0, (boolean)true);
            ImagePlus filteredPlus = new ImagePlus("filtered_" + radX, res);
            timeDuplicate.setStack(res);
            filteredPlus.show();
        }
        IJ.log((String)("Threshold method " + this.methods[this.threshold_method]));
        IJ.log((String)("Criteria method " + this.criteria[this.crit]));
        int thmin = (int)this.minTh;
        if (this.start) {
            thmin = (int)ImageHandler.wrap((ImagePlus)timeDuplicate).getMean();
            IJ.log((String)("Mean=" + thmin));
        }
        TrackThreshold TT = new TrackThreshold(this.volMin, this.volMax, this.minCont, this.step, this.step, thmin);
        TT.setMarkers(point3Ds);
        ImagePlus markersPlus = WindowManager.getImage((String)"markers");
        if (markersPlus != null) {
            TT.setImageMarkers(ImageInt.wrap((ImagePlus)markersPlus));
            IJ.log((String)("markers image " + markersPlus));
        }
        if ((zonePlus = WindowManager.getImage((String)"zones")) != null) {
            TT.setImageZones(ImageInt.wrap((ImagePlus)zonePlus));
            IJ.log((String)("zones image " + zonePlus));
        }
        int tmethod = 1;
        if (this.threshold_method == 0) {
            tmethod = 1;
        } else if (this.threshold_method == 1) {
            tmethod = 2;
        } else if (this.threshold_method == 2) {
            tmethod = 3;
        }
        if (timeDuplicate.getBitDepth() == 8) {
            this.threshold_method = 1;
        }
        TT.setMethodThreshold(tmethod);
        int cri = 1;
        switch (this.crit) {
            case 0: {
                cri = 1;
                break;
            }
            case 1: {
                cri = 4;
                break;
            }
            case 2: {
                cri = 2;
                break;
            }
            case 3: {
                cri = 3;
                break;
            }
            case 4: {
                cri = 5;
            }
        }
        TT.setCriteriaMethod(cri);
        ImagePlus res = this.seg == 0 ? TT.segment(timeDuplicate, true) : TT.segmentBest(timeDuplicate, true);
        if (res != null && calibration != null) {
            res.setCalibration(calibration);
        }
        if (res != null) {
            res.show();
        } else {
            IJ.log((String)"NO OBJECTS FOUND !");
        }
    }

    private boolean dialogue() {
        this.methods = new String[]{"STEP", "KMEANS", "VOLUME"};
        this.criteria = new String[]{"ELONGATION", "COMPACTNESS", "VOLUME", "MSER", "EDGES"};
        this.segs = new String[]{"All", "Best"};
        GenericDialog gd = new GenericDialog("sizes");
        gd.addNumericField("Min_vol_pix", (double)this.volMin, 0, 10, "");
        gd.addNumericField("Max_vol_pix", (double)this.volMax, 0, 10, "");
        gd.addNumericField("Min_threshold", this.minTh, 0, 10, "");
        gd.addNumericField("Min_contrast (exp)", (double)this.minCont, 0, 10, "");
        gd.addChoice("Criteria_method", this.criteria, this.criteria[this.crit]);
        gd.addChoice("Threshold_method", this.methods, this.methods[this.threshold_method]);
        gd.addChoice("Segment_results", this.segs, this.segs[this.seg]);
        gd.addNumericField("Value_method", (double)this.step, 1, 10, "");
        gd.addCheckbox("Starts at mean", this.start);
        gd.addCheckbox("Filtering", this.filter);
        gd.showDialog();
        this.volMin = (int)gd.getNextNumber();
        this.volMax = (int)gd.getNextNumber();
        this.minTh = (int)gd.getNextNumber();
        this.minCont = (int)gd.getNextNumber();
        this.crit = gd.getNextChoiceIndex();
        this.threshold_method = gd.getNextChoiceIndex();
        this.seg = gd.getNextChoiceIndex();
        this.step = (int)gd.getNextNumber();
        this.start = gd.getNextBoolean();
        this.filter = gd.getNextBoolean();
        if (this.volMax < this.volMin) {
            int vtemp = this.volMax;
            this.volMax = this.volMin;
            this.volMin = vtemp;
        }
        Prefs.set((String)"mcib_iterative_volmax.int", (int)this.volMax);
        Prefs.set((String)"mcib_iterative_volmin.int", (int)this.volMin);
        Prefs.set((String)"mcib_iterative_thmin.int", (double)this.minTh);
        Prefs.set((String)"mcib_iterative_contmin.int", (int)this.minCont);
        Prefs.set((String)"mcib_iterative_method.int", (int)this.threshold_method);
        Prefs.set((String)"mcib_iterative_criteria.int", (int)this.crit);
        Prefs.set((String)"mcib_iterative_seg.int", (int)this.seg);
        Prefs.set((String)"mcib_iterative_step.int", (int)this.step);
        return gd.wasOKed();
    }

    private ArrayList<Point3D> computeMarkers(ImageInt markImage) {
        if (markImage.isBinary()) {
            ImageLabeller labeler = new ImageLabeller();
            markImage = labeler.getLabels((ImageHandler)markImage);
        }
        ArrayList<Point3D> point3Ds = new ArrayList<Point3D>();
        Objects3DPopulation objects3DPopulation = new Objects3DPopulation(markImage);
        for (Object3D object3D : objects3DPopulation.getObjectsList()) {
            point3Ds.add(object3D.getCenterAsPoint());
        }
        return point3Ds;
    }
}

